-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MOnePower = {}

---@class MOnePower.InputState
---@field InputState integer
local TInputState = {}
TInputState.__index = TInputState
TInputState.group = {}

local function TInputState_from_obj(obj)
    return setmetatable(obj, TInputState)
end

function TInputState.new(InputState)
    return TInputState_from_obj({InputState = InputState})
end
---@param obj MOnePower.InputState
function TInputState:init_from_obj(obj)
    self.InputState = obj.InputState
end

function TInputState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInputState.group)
end

TInputState.from_obj = TInputState_from_obj

TInputState.proto_property = {'InputState'}

TInputState.default = {0}

TInputState.struct = {{name = 'InputState', is_array = false, struct = nil}}

function TInputState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'InputState', self.InputState, 'uint8', false, errs, need_convert)

    TInputState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInputState.proto_property, errs, need_convert)
    return self
end

function TInputState:unpack(_)
    return self.InputState
end

MOnePower.InputState = TInputState

---@class MOnePower.UpgradeSupported
---@field UpgradeSupported boolean
local TUpgradeSupported = {}
TUpgradeSupported.__index = TUpgradeSupported
TUpgradeSupported.group = {}

local function TUpgradeSupported_from_obj(obj)
    return setmetatable(obj, TUpgradeSupported)
end

function TUpgradeSupported.new(UpgradeSupported)
    return TUpgradeSupported_from_obj({UpgradeSupported = UpgradeSupported == nil and true or UpgradeSupported})
end
---@param obj MOnePower.UpgradeSupported
function TUpgradeSupported:init_from_obj(obj)
    self.UpgradeSupported = obj.UpgradeSupported == nil and true or obj.UpgradeSupported
end

function TUpgradeSupported:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeSupported.group)
end

TUpgradeSupported.from_obj = TUpgradeSupported_from_obj

TUpgradeSupported.proto_property = {'UpgradeSupported'}

TUpgradeSupported.default = {false}

TUpgradeSupported.struct = {{name = 'UpgradeSupported', is_array = false, struct = nil}}

function TUpgradeSupported:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpgradeSupported', self.UpgradeSupported, 'bool', false, errs, need_convert)

    TUpgradeSupported:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeSupported.proto_property, errs, need_convert)
    return self
end

function TUpgradeSupported:unpack(_)
    return self.UpgradeSupported
end

MOnePower.UpgradeSupported = TUpgradeSupported

---@class MOnePower.RefSMCChip
---@field RefSMCChip integer[]
local TRefSMCChip = {}
TRefSMCChip.__index = TRefSMCChip
TRefSMCChip.group = {}

local function TRefSMCChip_from_obj(obj)
    return setmetatable(obj, TRefSMCChip)
end

function TRefSMCChip.new(RefSMCChip)
    return TRefSMCChip_from_obj({RefSMCChip = RefSMCChip})
end
---@param obj MOnePower.RefSMCChip
function TRefSMCChip:init_from_obj(obj)
    self.RefSMCChip = obj.RefSMCChip
end

function TRefSMCChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefSMCChip.group)
end

TRefSMCChip.from_obj = TRefSMCChip_from_obj

TRefSMCChip.proto_property = {'RefSMCChip'}

TRefSMCChip.default = {{}}

TRefSMCChip.struct = {{name = 'RefSMCChip', is_array = true, struct = nil}}

function TRefSMCChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefSMCChip', self.RefSMCChip, 'uint8', false, errs, need_convert)

    TRefSMCChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefSMCChip.proto_property, errs, need_convert)
    return self
end

function TRefSMCChip:unpack(_)
    return self.RefSMCChip
end

MOnePower.RefSMCChip = TRefSMCChip

---@class MOnePower.PreAlarmStatus
---@field PreAlarmStatus integer
local TPreAlarmStatus = {}
TPreAlarmStatus.__index = TPreAlarmStatus
TPreAlarmStatus.group = {}

local function TPreAlarmStatus_from_obj(obj)
    return setmetatable(obj, TPreAlarmStatus)
end

function TPreAlarmStatus.new(PreAlarmStatus)
    return TPreAlarmStatus_from_obj({PreAlarmStatus = PreAlarmStatus})
end
---@param obj MOnePower.PreAlarmStatus
function TPreAlarmStatus:init_from_obj(obj)
    self.PreAlarmStatus = obj.PreAlarmStatus
end

function TPreAlarmStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPreAlarmStatus.group)
end

TPreAlarmStatus.from_obj = TPreAlarmStatus_from_obj

TPreAlarmStatus.proto_property = {'PreAlarmStatus'}

TPreAlarmStatus.default = {0}

TPreAlarmStatus.struct = {{name = 'PreAlarmStatus', is_array = false, struct = nil}}

function TPreAlarmStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PreAlarmStatus', self.PreAlarmStatus, 'uint32', false, errs, need_convert)

    TPreAlarmStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPreAlarmStatus.proto_property, errs, need_convert)
    return self
end

function TPreAlarmStatus:unpack(_)
    return self.PreAlarmStatus
end

MOnePower.PreAlarmStatus = TPreAlarmStatus

---@class MOnePower.AlarmStatus
---@field AlarmStatus integer
local TAlarmStatus = {}
TAlarmStatus.__index = TAlarmStatus
TAlarmStatus.group = {}

local function TAlarmStatus_from_obj(obj)
    return setmetatable(obj, TAlarmStatus)
end

function TAlarmStatus.new(AlarmStatus)
    return TAlarmStatus_from_obj({AlarmStatus = AlarmStatus})
end
---@param obj MOnePower.AlarmStatus
function TAlarmStatus:init_from_obj(obj)
    self.AlarmStatus = obj.AlarmStatus
end

function TAlarmStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlarmStatus.group)
end

TAlarmStatus.from_obj = TAlarmStatus_from_obj

TAlarmStatus.proto_property = {'AlarmStatus'}

TAlarmStatus.default = {0}

TAlarmStatus.struct = {{name = 'AlarmStatus', is_array = false, struct = nil}}

function TAlarmStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AlarmStatus', self.AlarmStatus, 'uint32', false, errs, need_convert)

    TAlarmStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlarmStatus.proto_property, errs, need_convert)
    return self
end

function TAlarmStatus:unpack(_)
    return self.AlarmStatus
end

MOnePower.AlarmStatus = TAlarmStatus

---@class MOnePower.UnsupportedProperties
---@field UnsupportedProperties string[]
local TUnsupportedProperties = {}
TUnsupportedProperties.__index = TUnsupportedProperties
TUnsupportedProperties.group = {}

local function TUnsupportedProperties_from_obj(obj)
    return setmetatable(obj, TUnsupportedProperties)
end

function TUnsupportedProperties.new(UnsupportedProperties)
    return TUnsupportedProperties_from_obj({UnsupportedProperties = UnsupportedProperties})
end
---@param obj MOnePower.UnsupportedProperties
function TUnsupportedProperties:init_from_obj(obj)
    self.UnsupportedProperties = obj.UnsupportedProperties
end

function TUnsupportedProperties:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnsupportedProperties.group)
end

TUnsupportedProperties.from_obj = TUnsupportedProperties_from_obj

TUnsupportedProperties.proto_property = {'UnsupportedProperties'}

TUnsupportedProperties.default = {{}}

TUnsupportedProperties.struct = {{name = 'UnsupportedProperties', is_array = true, struct = nil}}

function TUnsupportedProperties:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'UnsupportedProperties', self.UnsupportedProperties, 'string', false, errs,
        need_convert)

    TUnsupportedProperties:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnsupportedProperties.proto_property, errs, need_convert)
    return self
end

function TUnsupportedProperties:unpack(_)
    return self.UnsupportedProperties
end

MOnePower.UnsupportedProperties = TUnsupportedProperties

---@class MOnePower.RefFrudata
---@field RefFrudata integer[]
local TRefFrudata = {}
TRefFrudata.__index = TRefFrudata
TRefFrudata.group = {}

local function TRefFrudata_from_obj(obj)
    return setmetatable(obj, TRefFrudata)
end

function TRefFrudata.new(RefFrudata)
    return TRefFrudata_from_obj({RefFrudata = RefFrudata})
end
---@param obj MOnePower.RefFrudata
function TRefFrudata:init_from_obj(obj)
    self.RefFrudata = obj.RefFrudata
end

function TRefFrudata:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefFrudata.group)
end

TRefFrudata.from_obj = TRefFrudata_from_obj

TRefFrudata.proto_property = {'RefFrudata'}

TRefFrudata.default = {{}}

TRefFrudata.struct = {{name = 'RefFrudata', is_array = true, struct = nil}}

function TRefFrudata:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefFrudata', self.RefFrudata, 'uint8', false, errs, need_convert)

    TRefFrudata:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefFrudata.proto_property, errs, need_convert)
    return self
end

function TRefFrudata:unpack(_)
    return self.RefFrudata
end

MOnePower.RefFrudata = TRefFrudata

---@class MOnePower.PhysicalInterface
---@field PhysicalInterface string
local TPhysicalInterface = {}
TPhysicalInterface.__index = TPhysicalInterface
TPhysicalInterface.group = {}

local function TPhysicalInterface_from_obj(obj)
    return setmetatable(obj, TPhysicalInterface)
end

function TPhysicalInterface.new(PhysicalInterface)
    return TPhysicalInterface_from_obj({PhysicalInterface = PhysicalInterface})
end
---@param obj MOnePower.PhysicalInterface
function TPhysicalInterface:init_from_obj(obj)
    self.PhysicalInterface = obj.PhysicalInterface
end

function TPhysicalInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalInterface.group)
end

TPhysicalInterface.from_obj = TPhysicalInterface_from_obj

TPhysicalInterface.proto_property = {'PhysicalInterface'}

TPhysicalInterface.default = {''}

TPhysicalInterface.struct = {{name = 'PhysicalInterface', is_array = false, struct = nil}}

function TPhysicalInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalInterface', self.PhysicalInterface, 'string', false, errs, need_convert)

    TPhysicalInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalInterface.proto_property, errs, need_convert)
    return self
end

function TPhysicalInterface:unpack(_)
    return self.PhysicalInterface
end

MOnePower.PhysicalInterface = TPhysicalInterface

return MOnePower
