-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MAclostRecordTable = {}

---@class MAclostRecordTable.ShieldAclostEventRecord
---@field ShieldAclostEventRecord integer
local TShieldAclostEventRecord = {}
TShieldAclostEventRecord.__index = TShieldAclostEventRecord
TShieldAclostEventRecord.group = {}

local function TShieldAclostEventRecord_from_obj(obj)
    return setmetatable(obj, TShieldAclostEventRecord)
end

function TShieldAclostEventRecord.new(ShieldAclostEventRecord)
    return TShieldAclostEventRecord_from_obj({ShieldAclostEventRecord = ShieldAclostEventRecord or 255})
end
---@param obj MAclostRecordTable.ShieldAclostEventRecord
function TShieldAclostEventRecord:init_from_obj(obj)
    self.ShieldAclostEventRecord = obj.ShieldAclostEventRecord or 255
end

function TShieldAclostEventRecord:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TShieldAclostEventRecord.group)
end

TShieldAclostEventRecord.from_obj = TShieldAclostEventRecord_from_obj

TShieldAclostEventRecord.proto_property = {'ShieldAclostEventRecord'}

TShieldAclostEventRecord.default = {0}

TShieldAclostEventRecord.struct = {{name = 'ShieldAclostEventRecord', is_array = false, struct = nil}}

function TShieldAclostEventRecord:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ShieldAclostEventRecord', self.ShieldAclostEventRecord, 'uint8', false, errs,
        need_convert)

    TShieldAclostEventRecord:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TShieldAclostEventRecord.proto_property, errs, need_convert)
    return self
end

function TShieldAclostEventRecord:unpack(_)
    return self.ShieldAclostEventRecord
end

MAclostRecordTable.ShieldAclostEventRecord = TShieldAclostEventRecord

---@class MAclostRecordTable.ResetFlag
---@field ResetFlag integer
local TResetFlag = {}
TResetFlag.__index = TResetFlag
TResetFlag.group = {}

local function TResetFlag_from_obj(obj)
    return setmetatable(obj, TResetFlag)
end

function TResetFlag.new(ResetFlag)
    return TResetFlag_from_obj({ResetFlag = ResetFlag or 0})
end
---@param obj MAclostRecordTable.ResetFlag
function TResetFlag:init_from_obj(obj)
    self.ResetFlag = obj.ResetFlag or 0
end

function TResetFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetFlag.group)
end

TResetFlag.from_obj = TResetFlag_from_obj

TResetFlag.proto_property = {'ResetFlag'}

TResetFlag.default = {0}

TResetFlag.struct = {{name = 'ResetFlag', is_array = false, struct = nil}}

function TResetFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetFlag', self.ResetFlag, 'uint8', false, errs, need_convert)

    TResetFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetFlag.proto_property, errs, need_convert)
    return self
end

function TResetFlag:unpack(_)
    return self.ResetFlag
end

MAclostRecordTable.ResetFlag = TResetFlag

---@class MAclostRecordTable.Flag
---@field Flag integer
local TFlag = {}
TFlag.__index = TFlag
TFlag.group = {}

local function TFlag_from_obj(obj)
    return setmetatable(obj, TFlag)
end

function TFlag.new(Flag)
    return TFlag_from_obj({Flag = Flag})
end
---@param obj MAclostRecordTable.Flag
function TFlag:init_from_obj(obj)
    self.Flag = obj.Flag
end

function TFlag:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFlag.group)
end

TFlag.from_obj = TFlag_from_obj

TFlag.proto_property = {'Flag'}

TFlag.default = {0}

TFlag.struct = {{name = 'Flag', is_array = false, struct = nil}}

function TFlag:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Flag', self.Flag, 'uint32', false, errs, need_convert)

    TFlag:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFlag.proto_property, errs, need_convert)
    return self
end

function TFlag:unpack(_)
    return self.Flag
end

MAclostRecordTable.Flag = TFlag

---@class MAclostRecordTable.CurTimeSource
---@field CurTimeSource string
local TCurTimeSource = {}
TCurTimeSource.__index = TCurTimeSource
TCurTimeSource.group = {}

local function TCurTimeSource_from_obj(obj)
    return setmetatable(obj, TCurTimeSource)
end

function TCurTimeSource.new(CurTimeSource)
    return TCurTimeSource_from_obj({CurTimeSource = CurTimeSource})
end
---@param obj MAclostRecordTable.CurTimeSource
function TCurTimeSource:init_from_obj(obj)
    self.CurTimeSource = obj.CurTimeSource
end

function TCurTimeSource:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurTimeSource.group)
end

TCurTimeSource.from_obj = TCurTimeSource_from_obj

TCurTimeSource.proto_property = {'CurTimeSource'}

TCurTimeSource.default = {''}

TCurTimeSource.struct = {{name = 'CurTimeSource', is_array = false, struct = nil}}

function TCurTimeSource:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurTimeSource', self.CurTimeSource, 'string', false, errs, need_convert)

    TCurTimeSource:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurTimeSource.proto_property, errs, need_convert)
    return self
end

function TCurTimeSource:unpack(_)
    return self.CurTimeSource
end

MAclostRecordTable.CurTimeSource = TCurTimeSource

---@class MAclostRecordTable.CurTime
---@field CurTime integer
local TCurTime = {}
TCurTime.__index = TCurTime
TCurTime.group = {}

local function TCurTime_from_obj(obj)
    return setmetatable(obj, TCurTime)
end

function TCurTime.new(CurTime)
    return TCurTime_from_obj({CurTime = CurTime})
end
---@param obj MAclostRecordTable.CurTime
function TCurTime:init_from_obj(obj)
    self.CurTime = obj.CurTime
end

function TCurTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurTime.group)
end

TCurTime.from_obj = TCurTime_from_obj

TCurTime.proto_property = {'CurTime'}

TCurTime.default = {0}

TCurTime.struct = {{name = 'CurTime', is_array = false, struct = nil}}

function TCurTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurTime', self.CurTime, 'uint32', false, errs, need_convert)

    TCurTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurTime.proto_property, errs, need_convert)
    return self
end

function TCurTime:unpack(_)
    return self.CurTime
end

MAclostRecordTable.CurTime = TCurTime

---@class MAclostRecordTable.Id
---@field Id string
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MAclostRecordTable.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {''}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MAclostRecordTable.Id = TId

return MAclostRecordTable
