-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local power_supplies_class_types = require 'class.types.PowerSupplies'
local one_power_class_types = require 'class.types.OnePower'
local power_converter_class_types = require 'class.types.PowerConverter'
local psu_slot_class_types = require 'class.types.PsuSlot'
local aclost_record_table_class_types = require 'class.types.AclostRecordTable'
local power_configuration_class_types = require 'class.types.PowerConfiguration'
local system_power_class_types = require 'class.types.SystemPower'
local power_output_efficiency_curve_class_types = require 'class.types.PowerOutputEfficiencyCurve'
local power_supplies_intf_types = require 'power_mgmt.json_types.PowerSupplies'
local power_supplies_metrics_intf_types = require 'power_mgmt.json_types.PowerSuppliesMetrics'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'
local circuit_intf_types = require 'power_mgmt.json_types.Circuit'
local power_mgmt_intf_types = require 'power_mgmt.json_types.PowerMgmt'
local one_power_intf_types = require 'power_mgmt.json_types.OnePower'
local one_power_metrics_intf_types = require 'power_mgmt.json_types.OnePowerMetrics'
local output_control_intf_types = require 'power_mgmt.json_types.OutputControl'
local power_supply_metrics_intf_types = require 'power_mgmt.json_types.PowerSupplyMetrics'
local temperatures_intf_types = require 'power_mgmt.json_types.Temperatures'
local status_intf_types = require 'power_mgmt.json_types.Status'
local efficiency_curve_intf_types = require 'power_mgmt.json_types.EfficiencyCurve'
local metric_intf_types = require 'power_mgmt.json_types.Metric'
local collector_intf_types = require 'power_mgmt.json_types.Collector'
local capacitor_intf_types = require 'power_mgmt.json_types.Capacitor'
local capacitor_metrics_intf_types = require 'power_mgmt.json_types.CapacitorMetrics'
local black_box_intf_types = require 'power_mgmt.json_types.BlackBox'
local manufacture_intf_types = require 'power_mgmt.json_types.Manufacture'
local transfer_configuration_intf_types = require 'power_mgmt.json_types.TransferConfiguration'
local power_distribution_intf_types = require 'power_mgmt.json_types.PowerDistribution'
local transfer_config_intf_types = require 'power_mgmt.json_types.TransferConfig'
local power_distribution_metrics_intf_types = require 'power_mgmt.json_types.PowerDistributionMetrics'

local PowerSupplies = {
    ['table_name'] = 't_power_supplies',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['primaryKey'] = true,
            ['validator'] = power_supplies_class_types.Id
        },
        ['RetransferDelaySeconds'] = {
            ['baseType'] = 'U32',
            ['usage'] = {'PoweroffPer'},
            ['minimum'] = 10,
            ['maximum'] = 16200,
            ['default'] = 1800,
            ['validator'] = power_supplies_class_types.RetransferDelaySeconds
        }
    },
    ['default_props'] = {['Id'] = power_supplies_class_types.Id.default[1], ['RetransferDelaySeconds'] = 1800},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {
            ['UpgradeStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = power_supplies_intf_types.UpgradeStatus
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies.Metrics'] = {
            ['AllocatedWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_supplies_metrics_intf_types.AllocatedWatts
            },
            ['RequestedWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_supplies_metrics_intf_types.RequestedWatts
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {
            ['SetPsusFanMinPWM'] = {
                ['privilege'] = {'PowerMgmt'},
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'FanMinPWM'}},
                ['rsp'] = {}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Chassis/:ChassisId/PowerSubsystem/PowerSupplies'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'] = {
            ['property_defaults'] = {['UpgradeStatus'] = 0},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPsusFanMinPWM'] = privilege.PowerMgmt}},
            ['interface_types'] = power_supplies_intf_types
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies.Metrics'] = {
            ['property_defaults'] = {['AllocatedWatts'] = 4294967295, ['RequestedWatts'] = 4294967295},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = power_supplies_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local Circuit = {
    ['table_name'] = 't_circuit',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.PowerEquipment.Circuit'] = {
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = circuit_intf_types.Id
            },
            ['CircuitType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Mains', 'Branch', 'Bus', 'Feeder', 'Subfeed', ''},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = circuit_intf_types.CircuitType
            },
            ['PhaseWiringType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'OneOrTwoPhase3Wire', 'OnePhase3Wire', 'ThreePhase4Wire', 'ThreePhase5Wire', 'TwoPhase3Wire',
                    'TwoPhase4Wire', ''
                },
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = circuit_intf_types.PhaseWiringType
            },
            ['NominalVoltage'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'AC100To127V', 'AC100To240V', 'AC100To277V', 'AC120V', 'AC200To240V', 'AC200To277V', 'AC208V',
                    'AC230V', 'AC240AndDC380V', 'AC240V', 'AC277AndDC380V', 'AC277V', 'AC400V', 'AC480V', 'DC12V',
                    'DC16V', 'DC1_8V', 'DC240V', 'DC380V', 'DC3_3V', 'DC48V', 'DC5V', 'DC9V', 'DCNeg48V', ''
                },
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = circuit_intf_types.NominalVoltage
            },
            ['InputVoltageStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = circuit_intf_types.InputVoltageStatus
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj(
        '/bmc/kepler/PowerEquipment/PowerDistributions/:PowerDistributionId/Circuits/:CircuitId'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.PowerEquipment.Circuit'] = {
            ['property_defaults'] = {
                ['Id'] = circuit_intf_types.Id.default[1],
                ['CircuitType'] = circuit_intf_types.CircuitType.default[1],
                ['PhaseWiringType'] = circuit_intf_types.PhaseWiringType.default[1],
                ['NominalVoltage'] = circuit_intf_types.NominalVoltage.default[1],
                ['InputVoltageStatus'] = circuit_intf_types.InputVoltageStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = circuit_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerMgmt = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt'] = {
            ['IsManufacturerMismatch'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = power_mgmt_intf_types.IsManufacturerMismatch
            },
            ['IsModelMismatch'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = power_mgmt_intf_types.IsModelMismatch
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerMgmt'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerMgmt'] = {
            ['property_defaults'] = {
                ['IsManufacturerMismatch'] = power_mgmt_intf_types.IsManufacturerMismatch.default[1],
                ['IsModelMismatch'] = power_mgmt_intf_types.IsModelMismatch.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = power_mgmt_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local OnePower = {
    ['table_name'] = 't_onepower',
    ['prop_configs'] = {
        ['PhysicalInterface'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = one_power_class_types.PhysicalInterface
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = one_power_class_types.RefFrudata
        },
        ['UnsupportedProperties'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = one_power_class_types.UnsupportedProperties
        },
        ['AlarmStatus'] = {['usage'] = {}, ['baseType'] = 'U32', ['validator'] = one_power_class_types.AlarmStatus},
        ['PreAlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = one_power_class_types.PreAlarmStatus
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = one_power_class_types.RefSMCChip
        },
        ['UpgradeSupported'] = {
            ['usage'] = {'CSR'},
            ['default'] = true,
            ['baseType'] = 'Boolean',
            ['validator'] = one_power_class_types.UpgradeSupported
        },
        ['InputState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = one_power_class_types.InputState}
    },
    ['default_props'] = {
        ['PhysicalInterface'] = one_power_class_types.PhysicalInterface.default[1],
        ['RefFrudata'] = one_power_class_types.RefFrudata.default[1],
        ['UnsupportedProperties'] = one_power_class_types.UnsupportedProperties.default[1],
        ['AlarmStatus'] = one_power_class_types.AlarmStatus.default[1],
        ['PreAlarmStatus'] = one_power_class_types.PreAlarmStatus.default[1],
        ['RefSMCChip'] = one_power_class_types.RefSMCChip.default[1],
        ['UpgradeSupported'] = true,
        ['InputState'] = one_power_class_types.InputState.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SlotNumber'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['primaryKey'] = true,
                ['validator'] = one_power_intf_types.SlotNumber
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Manufacturer
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Model
            },
            ['PowerSupplyType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PowerSupplyType
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Presence
            },
            ['PowerSupplyChannel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['validator'] = one_power_intf_types.PowerSupplyChannel
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SerialNumber
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PartNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.FirmwareVersion
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Protocol
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.DeviceLocator
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.ProductionDate
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Position
            },
            ['DMTFPowerSupplyType'] = {
                ['baseType'] = 'U8',
                ['enum'] = {1, 2, 3, 4, 5, 6, 7, 8},
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 4,
                ['validator'] = one_power_intf_types.DMTFPowerSupplyType
            },
            ['SourceType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['default'] = 1,
                ['validator'] = one_power_intf_types.SourceType
            },
            ['IsPartOfSysPower'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.IsPartOfSysPower
            },
            ['TotalRunningHours'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_intf_types.TotalRunningHours
            },
            ['LineInputVoltageType'] = {
                ['baseType'] = 'String',
                ['enum'] = {
                    'AC120V', 'AC240V', 'AC1277V', 'ACandDCWideRange', 'ACWideRange', 'DC240V', 'DC380V', 'DCNeg48V',
                    'HVDC', 'Unknown'
                },
                ['readOnly'] = true,
                ['default'] = 'Unknown',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.LineInputVoltageType
            },
            ['RelaySwitchedCount'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = one_power_intf_types.RelaySwitchedCount
            },
            ['WorkMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.WorkMode
            },
            ['DeepSleepStandbyPowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 65535,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.DeepSleepStandbyPowerWatts
            },
            ['RedundancyGroupId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = one_power_intf_types.RedundancyGroupId
            },
            ['InputVoltageType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = one_power_intf_types.InputVoltageType
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['OutputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputPowerWatts
            },
            ['InputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputPowerWatts
            },
            ['InputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputVoltage
            },
            ['OutputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputVoltage
            },
            ['InputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputCurrentAmps
            },
            ['OutputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputCurrentAmps
            },
            ['Rate'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.Rate
            },
            ['RatedCurrentAmps'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_metrics_intf_types.RatedCurrentAmps
            },
            ['InputFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_metrics_intf_types.InputFrequencyHz
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.OutputControl'] = {
            ['OutputPowerLimitWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = output_control_intf_types.OutputPowerLimitWatts
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.Metrics'] = {
            ['EnergykWh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = true},
                ['validator'] = power_supply_metrics_intf_types.EnergykWh
            },
            ['EnergySensorResetTime'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.EnergySensorResetTime
            },
            ['EnergyApparentkVAh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.EnergyApparentkVAh
            },
            ['EnergyLifetimekWh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.EnergyLifetimekWh
            },
            ['EnergyReactivekVARh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.EnergyReactivekVARh
            },
            ['InputCurrentAmpsCrestFactor'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputCurrentAmpsCrestFactor
            },
            ['InputCurrentAmpsTHDPercent'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputCurrentAmpsTHDPercent
            },
            ['InputPowerWattsApparentVA'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputPowerWattsApparentVA
            },
            ['InputPowerWattsPhaseAngleDegrees'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputPowerWattsPhaseAngleDegrees
            },
            ['InputPowerWattsPowerFactor'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputPowerWattsPowerFactor
            },
            ['InputPowerWattsReactiveVAR'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputPowerWattsReactiveVAR
            },
            ['InputVoltageCrestFactor'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.InputVoltageCrestFactor
            },
            ['OutputPowerWattsApparentVA'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.OutputPowerWattsApparentVA
            },
            ['OutputPowerWattsPhaseAngleDegrees'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.OutputPowerWattsPhaseAngleDegrees
            },
            ['OutputPowerWattsPowerFactor'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.OutputPowerWattsPowerFactor
            },
            ['OutputPowerWattsReactiveVAR'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false', ['volatile'] = false},
                ['validator'] = power_supply_metrics_intf_types.OutputPowerWattsReactiveVAR
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['EnvTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.EnvTemperatureCelsius
            },
            ['PrimaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.PrimaryChipTemperatureCelsius
            },
            ['SecondaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.SecondaryChipTemperatureCelsius
            },
            ['InletTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = temperatures_intf_types.InletTemperatureCelsius
            },
            ['InnerTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = temperatures_intf_types.InnerTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['OutputState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputState
            },
            ['CommunicationStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'SHM'},
                ['validator'] = status_intf_types.CommunicationStatus
            },
            ['Failure'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Failure
            },
            ['Fan1Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Fan1Fault
            },
            ['Fan2Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.Fan2Fault
            },
            ['FanFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.FanFault
            },
            ['InputVoltageFault'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 32768,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.InputVoltageFault
            },
            ['LossOfInput'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.LossOfInput
            },
            ['OutputCurrentFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OutputCurrentFault
            },
            ['OutputVoltageFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OutputVoltageFault
            },
            ['OverTemperature'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.OverTemperature
            },
            ['SleepMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.SleepMode
            },
            ['DeepSleepEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DeepSleepEnabled
            },
            ['InputVoltageStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['enum'] = {0, 1, 2, 3},
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageStatus
            },
            ['DualInputVoltageStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DualInputVoltageStatus
            },
            ['ScanStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.ScanStatus
            },
            ['EquipmentMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.EquipmentMode
            },
            ['TPSUStatusHigh'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.TPSUStatusHigh
            },
            ['TPSUStatusLow'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR', 'SHM'},
                ['validator'] = status_intf_types.TPSUStatusLow
            },
            ['MainCircuitVINStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = status_intf_types.MainCircuitVINStatus
            },
            ['BackupCircuitVINStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['default'] = 255,
                ['validator'] = status_intf_types.BackupCircuitVINStatus
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = status_intf_types.Health
            },
            ['IsUpgrading'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = status_intf_types.IsUpgrading
            },
            ['NormalAndRedundancySupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = status_intf_types.NormalAndRedundancySupported
            },
            ['MfrSpecificStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.MfrSpecificStatus
            },
            ['CMLStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.CMLStatus
            },
            ['OtherStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.OtherStatus
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.EfficiencyCurve'] = {
            ['EfficiencyCurve'] = {
                ['baseType'] = 'Array',
                ['items'] = {['$ref'] = '#/defs/EfficiencyCurveObject'},
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'const'},
                ['validator'] = efficiency_curve_intf_types.EfficiencyCurve
            },
            ['PowerLevel'] = {
                ['baseType'] = 'String',
                ['enum'] = {
                    '80PLUS', '80PLUS Bronze', '80PLUS Silver', '80PLUS Gold', '80PLUS Platinum', '80PLUS Titanium',
                    'N/A'
                },
                ['readOnly'] = true,
                ['default'] = 'N/A',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = efficiency_curve_intf_types.PowerLevel
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Release.OnePower.Collector'] = {},
        ['bmc.kepler.Chassis.PowerSubsystem.Capacitor'] = {
            ['HardwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = capacitor_intf_types.HardwareVersion
            },
            ['PowerState'] = {
                ['baseType'] = 'String',
                ['enum'] = {'On', 'Off', 'N/A'},
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['readOnly'] = true,
                ['default'] = 'N/A',
                ['validator'] = capacitor_intf_types.PowerState
            },
            ['VOUTDebounceMilliseconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = capacitor_intf_types.VOUTDebounceMilliseconds
            },
            ['DepthOfDischargeVolts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = capacitor_intf_types.DepthOfDischargeVolts
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.Capacitor.Metrics'] = {
            ['CapacityMicrofarads'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = capacitor_metrics_intf_types.CapacityMicrofarads
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SetPowerWorkMode'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'PowerWorkMode'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['Reset'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'ForceRestart', 'ForceOff', 'ForceOn', 'On', 'PowerCycle'},
                        ['param'] = 'ResetType'
                    }
                },
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetPowerSupplyCircuit'] = {
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {0, 1}, ['param'] = 'PowerSupplyCircuit'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.OutputControl'] = {
            ['SetOutputPowerLimitWatts'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'OutputPowerLimitWatts'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.Metrics'] = {
            ['Reset'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'PowerMgmt'}}
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['SetSleepMode'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'SleepMode'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetAlarmLatch'] = {
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {0, 1}, ['param'] = 'SwitchStatus'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        },
        ['bmc.kepler.Release.OnePower.Collector'] = {
            ['GetFanSpeed'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'U16', ['param'] = 'FanSpeed'}},
                ['privilege'] = {'ReadOnly'},
                ['displayDescription'] = 'Get PSU fan speed. For example: getpsufanspeed OnePower_0_010109',
                ['cmdName'] = 'getpsufanspeed'
            },
            ['GetRegisterValue'] = {
                ['req'] = {
                    {['baseType'] = 'U32', ['displayDescription'] = 'PSU register address.', ['param'] = 'Cmd'},
                    {['baseType'] = 'U32', ['displayDescription'] = 'Read length.', ['param'] = 'Length'}
                },
                ['rsp'] = {{['baseType'] = 'U8[]', ['param'] = 'OutData'}},
                ['privilege'] = {'ReadOnly'},
                ['displayDescription'] = 'Get PSU register value. For example: getpsureg OnePower_0_010109 144 2',
                ['cmdName'] = 'getpsureg'
            }
        },
        ['bmc.kepler.Chassis.PowerSubsystem.Capacitor'] = {
            ['Reset'] = {
                ['req'] = {{['baseType'] = 'String', ['enum'] = {'ForceOff', 'On'}, ['param'] = 'ResetType'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetVOUTDebounceMilliseconds'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'VOUTDebounceMilliseconds'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetDepthOfDischargeVolts'] = {
                ['req'] = {{['baseType'] = 'U32', ['param'] = 'DepthOfDischargeVolts'}},
                ['rsp'] = {},
                ['privilege'] = {'PowerMgmt'}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerMgmt/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['property_defaults'] = {
                ['SlotNumber'] = 0,
                ['Manufacturer'] = one_power_intf_types.Manufacturer.default[1],
                ['Model'] = one_power_intf_types.Model.default[1],
                ['PowerSupplyType'] = 0,
                ['Presence'] = 0,
                ['PowerSupplyChannel'] = 0,
                ['SerialNumber'] = one_power_intf_types.SerialNumber.default[1],
                ['PartNumber'] = one_power_intf_types.PartNumber.default[1],
                ['FirmwareVersion'] = one_power_intf_types.FirmwareVersion.default[1],
                ['Protocol'] = one_power_intf_types.Protocol.default[1],
                ['DeviceLocator'] = one_power_intf_types.DeviceLocator.default[1],
                ['ProductionDate'] = one_power_intf_types.ProductionDate.default[1],
                ['Position'] = one_power_intf_types.Position.default[1],
                ['DMTFPowerSupplyType'] = 4,
                ['SourceType'] = 1,
                ['IsPartOfSysPower'] = true,
                ['TotalRunningHours'] = one_power_intf_types.TotalRunningHours.default[1],
                ['LineInputVoltageType'] = 'Unknown',
                ['RelaySwitchedCount'] = one_power_intf_types.RelaySwitchedCount.default[1],
                ['WorkMode'] = one_power_intf_types.WorkMode.default[1],
                ['DeepSleepStandbyPowerWatts'] = 65535,
                ['RedundancyGroupId'] = one_power_intf_types.RedundancyGroupId.default[1],
                ['InputVoltageType'] = one_power_intf_types.InputVoltageType.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {
                    ['SetPowerWorkMode'] = privilege.PowerMgmt,
                    ['Reset'] = privilege.PowerMgmt,
                    ['SetPowerSupplyCircuit'] = privilege.PowerMgmt
                }
            },
            ['interface_types'] = one_power_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['property_defaults'] = {
                ['OutputPowerWatts'] = one_power_metrics_intf_types.OutputPowerWatts.default[1],
                ['InputPowerWatts'] = one_power_metrics_intf_types.InputPowerWatts.default[1],
                ['InputVoltage'] = one_power_metrics_intf_types.InputVoltage.default[1],
                ['OutputVoltage'] = one_power_metrics_intf_types.OutputVoltage.default[1],
                ['InputCurrentAmps'] = one_power_metrics_intf_types.InputCurrentAmps.default[1],
                ['OutputCurrentAmps'] = one_power_metrics_intf_types.OutputCurrentAmps.default[1],
                ['Rate'] = one_power_metrics_intf_types.Rate.default[1],
                ['RatedCurrentAmps'] = one_power_metrics_intf_types.RatedCurrentAmps.default[1],
                ['InputFrequencyHz'] = one_power_metrics_intf_types.InputFrequencyHz.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = one_power_metrics_intf_types
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.OutputControl'] = {
            ['property_defaults'] = {
                ['OutputPowerLimitWatts'] = output_control_intf_types.OutputPowerLimitWatts.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['SetOutputPowerLimitWatts'] = privilege.PowerMgmt}
            },
            ['interface_types'] = output_control_intf_types
        },
        ['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.Metrics'] = {
            ['property_defaults'] = {
                ['EnergykWh'] = power_supply_metrics_intf_types.EnergykWh.default[1],
                ['EnergySensorResetTime'] = power_supply_metrics_intf_types.EnergySensorResetTime.default[1],
                ['EnergyApparentkVAh'] = power_supply_metrics_intf_types.EnergyApparentkVAh.default[1],
                ['EnergyLifetimekWh'] = power_supply_metrics_intf_types.EnergyLifetimekWh.default[1],
                ['EnergyReactivekVARh'] = power_supply_metrics_intf_types.EnergyReactivekVARh.default[1],
                ['InputCurrentAmpsCrestFactor'] = power_supply_metrics_intf_types.InputCurrentAmpsCrestFactor.default[1],
                ['InputCurrentAmpsTHDPercent'] = power_supply_metrics_intf_types.InputCurrentAmpsTHDPercent.default[1],
                ['InputPowerWattsApparentVA'] = power_supply_metrics_intf_types.InputPowerWattsApparentVA.default[1],
                ['InputPowerWattsPhaseAngleDegrees'] = power_supply_metrics_intf_types.InputPowerWattsPhaseAngleDegrees
                    .default[1],
                ['InputPowerWattsPowerFactor'] = power_supply_metrics_intf_types.InputPowerWattsPowerFactor.default[1],
                ['InputPowerWattsReactiveVAR'] = power_supply_metrics_intf_types.InputPowerWattsReactiveVAR.default[1],
                ['InputVoltageCrestFactor'] = power_supply_metrics_intf_types.InputVoltageCrestFactor.default[1],
                ['OutputPowerWattsApparentVA'] = power_supply_metrics_intf_types.OutputPowerWattsApparentVA.default[1],
                ['OutputPowerWattsPhaseAngleDegrees'] = power_supply_metrics_intf_types.OutputPowerWattsPhaseAngleDegrees
                    .default[1],
                ['OutputPowerWattsPowerFactor'] = power_supply_metrics_intf_types.OutputPowerWattsPowerFactor.default[1],
                ['OutputPowerWattsReactiveVAR'] = power_supply_metrics_intf_types.OutputPowerWattsReactiveVAR.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['Reset'] = privilege.PowerMgmt}},
            ['interface_types'] = power_supply_metrics_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['property_defaults'] = {
                ['EnvTemperatureCelsius'] = temperatures_intf_types.EnvTemperatureCelsius.default[1],
                ['PrimaryChipTemperatureCelsius'] = temperatures_intf_types.PrimaryChipTemperatureCelsius.default[1],
                ['SecondaryChipTemperatureCelsius'] = temperatures_intf_types.SecondaryChipTemperatureCelsius.default[1],
                ['InletTemperatureCelsius'] = temperatures_intf_types.InletTemperatureCelsius.default[1],
                ['InnerTemperatureCelsius'] = temperatures_intf_types.InnerTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = temperatures_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['property_defaults'] = {
                ['OutputState'] = status_intf_types.OutputState.default[1],
                ['CommunicationStatus'] = status_intf_types.CommunicationStatus.default[1],
                ['Failure'] = status_intf_types.Failure.default[1],
                ['Fan1Fault'] = status_intf_types.Fan1Fault.default[1],
                ['Fan2Fault'] = status_intf_types.Fan2Fault.default[1],
                ['FanFault'] = status_intf_types.FanFault.default[1],
                ['InputVoltageFault'] = 32768,
                ['LossOfInput'] = status_intf_types.LossOfInput.default[1],
                ['OutputCurrentFault'] = status_intf_types.OutputCurrentFault.default[1],
                ['OutputVoltageFault'] = status_intf_types.OutputVoltageFault.default[1],
                ['OverTemperature'] = status_intf_types.OverTemperature.default[1],
                ['SleepMode'] = status_intf_types.SleepMode.default[1],
                ['DeepSleepEnabled'] = status_intf_types.DeepSleepEnabled.default[1],
                ['InputVoltageStatus'] = status_intf_types.InputVoltageStatus.default[1],
                ['DualInputVoltageStatus'] = status_intf_types.DualInputVoltageStatus.default[1],
                ['ScanStatus'] = status_intf_types.ScanStatus.default[1],
                ['EquipmentMode'] = 255,
                ['TPSUStatusHigh'] = status_intf_types.TPSUStatusHigh.default[1],
                ['TPSUStatusLow'] = status_intf_types.TPSUStatusLow.default[1],
                ['MainCircuitVINStatus'] = 255,
                ['BackupCircuitVINStatus'] = 255,
                ['Health'] = 255,
                ['IsUpgrading'] = status_intf_types.IsUpgrading.default[1],
                ['NormalAndRedundancySupported'] = status_intf_types.NormalAndRedundancySupported.default[1],
                ['MfrSpecificStatus'] = 255,
                ['CMLStatus'] = status_intf_types.CMLStatus.default[1],
                ['OtherStatus'] = status_intf_types.OtherStatus.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['SetSleepMode'] = privilege.PowerMgmt, ['SetAlarmLatch'] = privilege.PowerMgmt}
            },
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.EfficiencyCurve'] = {
            ['property_defaults'] = {
                ['EfficiencyCurve'] = efficiency_curve_intf_types.EfficiencyCurve.default[1],
                ['PowerLevel'] = 'N/A'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = efficiency_curve_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Release.OnePower.Collector'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['GetFanSpeed'] = privilege.ReadOnly, ['GetRegisterValue'] = privilege.ReadOnly}
            },
            ['interface_types'] = collector_intf_types
        },
        ['bmc.kepler.Chassis.PowerSubsystem.Capacitor'] = {
            ['property_defaults'] = {
                ['HardwareVersion'] = capacitor_intf_types.HardwareVersion.default[1],
                ['PowerState'] = 'N/A',
                ['VOUTDebounceMilliseconds'] = capacitor_intf_types.VOUTDebounceMilliseconds.default[1],
                ['DepthOfDischargeVolts'] = capacitor_intf_types.DepthOfDischargeVolts.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['HardwareVersion'] = {['read'] = privilege.ReadOnly},
                    ['VOUTDebounceMilliseconds'] = {['read'] = privilege.ReadOnly},
                    ['DepthOfDischargeVolts'] = {['read'] = privilege.ReadOnly}
                },
                ['methods'] = {
                    ['Reset'] = privilege.PowerMgmt,
                    ['SetVOUTDebounceMilliseconds'] = privilege.PowerMgmt,
                    ['SetDepthOfDischargeVolts'] = privilege.PowerMgmt
                }
            },
            ['interface_types'] = capacitor_intf_types
        },
        ['bmc.kepler.Chassis.PowerSubsystem.Capacitor.Metrics'] = {
            ['property_defaults'] = {
                ['CapacityMicrofarads'] = capacitor_metrics_intf_types.CapacityMicrofarads.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {['CapacityMicrofarads'] = {['read'] = privilege.ReadOnly}}
            },
            ['interface_types'] = capacitor_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerConverter = {
    ['prop_configs'] = {
        ['PhysicalInterface'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['validator'] = power_converter_class_types.PhysicalInterface
        },
        ['RefFrudata'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.FrudataService.Frudata',
            ['validator'] = power_converter_class_types.RefFrudata
        },
        ['UnsupportedProperties'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String[]',
            ['validator'] = power_converter_class_types.UnsupportedProperties
        },
        ['AlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = power_converter_class_types.AlarmStatus
        },
        ['PreAlarmStatus'] = {
            ['usage'] = {},
            ['baseType'] = 'U32',
            ['validator'] = power_converter_class_types.PreAlarmStatus
        },
        ['RefSMCChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = power_converter_class_types.RefSMCChip
        }
    },
    ['default_props'] = {
        ['PhysicalInterface'] = power_converter_class_types.PhysicalInterface.default[1],
        ['RefFrudata'] = power_converter_class_types.RefFrudata.default[1],
        ['UnsupportedProperties'] = power_converter_class_types.UnsupportedProperties.default[1],
        ['AlarmStatus'] = power_converter_class_types.AlarmStatus.default[1],
        ['PreAlarmStatus'] = power_converter_class_types.PreAlarmStatus.default[1],
        ['RefSMCChip'] = power_converter_class_types.RefSMCChip.default[1]
    },
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SlotNumber'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SlotNumber
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Manufacturer
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Model
            },
            ['PowerSupplyType'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PowerSupplyType
            },
            ['Presence'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Presence
            },
            ['PowerSupplyChannel'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['validator'] = one_power_intf_types.PowerSupplyChannel
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.SerialNumber
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.PartNumber
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.FirmwareVersion
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Protocol
            },
            ['DeviceLocator'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.DeviceLocator
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.ProductionDate
            },
            ['Position'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.Position
            },
            ['TotalRunningHours'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_intf_types.TotalRunningHours
            },
            ['LineInputVoltageType'] = {
                ['baseType'] = 'String',
                ['enum'] = {
                    'AC120V', 'AC240V', 'AC1277V', 'ACandDCWideRange', 'ACWideRange', 'DC240V', 'DC380V', 'DCNeg48V',
                    'HVDC', 'Unknown'
                },
                ['readOnly'] = true,
                ['default'] = 'Unknown',
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_intf_types.LineInputVoltageType
            },
            ['WorkMode'] = {['baseType'] = 'String', ['readOnly'] = true, ['validator'] = one_power_intf_types.WorkMode},
            ['RedundancyGroupId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = one_power_intf_types.RedundancyGroupId
            },
            ['InputVoltageType'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['validator'] = one_power_intf_types.InputVoltageType
            },
            ['DMTFPowerSupplyType'] = {
                ['baseType'] = 'U8',
                ['enum'] = {1, 2, 3, 4, 5, 6, 7, 8},
                ['readOnly'] = true,
                ['validator'] = one_power_intf_types.DMTFPowerSupplyType
            },
            ['SourceType'] = {['baseType'] = 'U8', ['readOnly'] = true, ['validator'] = one_power_intf_types.SourceType},
            ['IsPartOfSysPower'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['default'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = one_power_intf_types.IsPartOfSysPower
            },
            ['RelaySwitchedCount'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = one_power_intf_types.RelaySwitchedCount
            },
            ['DeepSleepStandbyPowerWatts'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 65535,
                ['validator'] = one_power_intf_types.DeepSleepStandbyPowerWatts
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['OutputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputPowerWatts
            },
            ['InputPowerWatts'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputPowerWatts
            },
            ['InputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputVoltage
            },
            ['OutputVoltage'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputVoltage
            },
            ['InputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.InputCurrentAmps
            },
            ['OutputCurrentAmps'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.OutputCurrentAmps
            },
            ['Rate'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = one_power_metrics_intf_types.Rate
            },
            ['RatedCurrentAmps'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_metrics_intf_types.RatedCurrentAmps
            },
            ['InputFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = one_power_metrics_intf_types.InputFrequencyHz
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['EnvTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.EnvTemperatureCelsius
            },
            ['PrimaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.PrimaryChipTemperatureCelsius
            },
            ['SecondaryChipTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['usage'] = {'CSR'},
                ['validator'] = temperatures_intf_types.SecondaryChipTemperatureCelsius
            },
            ['InletTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = temperatures_intf_types.InletTemperatureCelsius
            },
            ['InnerTemperatureCelsius'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true', ['volatile'] = true},
                ['validator'] = temperatures_intf_types.InnerTemperatureCelsius
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['OutputState'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputState
            },
            ['CommunicationStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.CommunicationStatus
            },
            ['Failure'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Failure
            },
            ['Fan1Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Fan1Fault
            },
            ['Fan2Fault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.Fan2Fault
            },
            ['FanFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.FanFault
            },
            ['InputVoltageFault'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['default'] = 32768,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageFault
            },
            ['LossOfInput'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.LossOfInput
            },
            ['OutputCurrentFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputCurrentFault
            },
            ['OutputVoltageFault'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OutputVoltageFault
            },
            ['OverTemperature'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OverTemperature
            },
            ['SleepMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.SleepMode
            },
            ['DeepSleepEnabled'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DeepSleepEnabled
            },
            ['InputVoltageStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['enum'] = {0, 1, 2, 3},
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.InputVoltageStatus
            },
            ['DualInputVoltageStatus'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.DualInputVoltageStatus
            },
            ['ScanStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.ScanStatus
            },
            ['CMLStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.CMLStatus
            },
            ['OtherStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.OtherStatus
            },
            ['MfrSpecificStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['usage'] = {'CSR'},
                ['validator'] = status_intf_types.MfrSpecificStatus
            },
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['validator'] = status_intf_types.Health
            },
            ['IsUpgrading'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = status_intf_types.IsUpgrading
            },
            ['NormalAndRedundancySupported'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = true,
                ['validator'] = status_intf_types.NormalAndRedundancySupported
            },
            ['EquipmentMode'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.EquipmentMode
            },
            ['TPSUStatusHigh'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.TPSUStatusHigh
            },
            ['TPSUStatusLow'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.TPSUStatusLow
            },
            ['MainCircuitVINStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.MainCircuitVINStatus
            },
            ['BackupCircuitVINStatus'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = status_intf_types.BackupCircuitVINStatus
            }
        },
        ['bmc.kepler.Metric'] = {},
        ['bmc.kepler.Debug.BlackBox'] = {},
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['SetPowerWorkMode'] = {
                ['req'] = {{['baseType'] = 'U8', ['param'] = 'PowerWorkMode'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['Reset'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {'ForceRestart', 'ForceOff', 'ForceOn', 'On', 'PowerCycle'},
                        ['param'] = 'ResetType'
                    }
                },
                ['rsp'] = {}
            },
            ['SetPowerSupplyCircuit'] = {
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {0, 1}, ['param'] = 'PowerSupplyCircuit'}},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['SetSleepMode'] = {
                ['req'] = {{['baseType'] = 'String', ['param'] = 'SleepMode'}},
                ['rsp'] = {{['baseType'] = 'U8', ['param'] = 'CmdResult'}},
                ['privilege'] = {'PowerMgmt'}
            },
            ['SetAlarmLatch'] = {
                ['req'] = {{['baseType'] = 'U8', ['enum'] = {0, 1}, ['param'] = 'SwitchStatus'}},
                ['rsp'] = {}
            }
        },
        ['bmc.kepler.Metric'] = {
            ['GetData'] = {
                ['req'] = {{['baseType'] = 'String[]', ['param'] = 'MetricName'}},
                ['rsp'] = {
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/DataCollectionItem'}, ['param'] = 'Val'}
                }
            },
            ['GetItems'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['param'] = 'Component'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Classification'},
                    {['baseType'] = 'Array', ['items'] = {['$ref'] = '#/defs/TagProp'}, ['param'] = 'Identification'},
                    {['baseType'] = 'String[]', ['param'] = 'MetricName'}
                }
            },
            ['SynDataAcquisitionEnable'] = {['req'] = {{['baseType'] = 'U8', ['param'] = 'Enabled'}}, ['rsp'] = {}}
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['DumpPsuBlackbox'] = {
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'ReadOnly'}
            }
        }
    },
    ['mdb_signal_configs'] = {
        ['bmc.kepler.Metric'] = {
            ['CollectSignal'] = {
                {['baseType'] = 'String', ['param'] = 'MetricName'}, {['baseType'] = 'String', ['param'] = 'TagPath'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Systems/:SystemId/PowerConverter/:ID'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Systems.PowerMgmt.OnePower'] = {
            ['property_defaults'] = {
                ['SlotNumber'] = 0,
                ['Manufacturer'] = one_power_intf_types.Manufacturer.default[1],
                ['Model'] = one_power_intf_types.Model.default[1],
                ['PowerSupplyType'] = 0,
                ['Presence'] = 0,
                ['PowerSupplyChannel'] = 0,
                ['SerialNumber'] = one_power_intf_types.SerialNumber.default[1],
                ['PartNumber'] = one_power_intf_types.PartNumber.default[1],
                ['FirmwareVersion'] = one_power_intf_types.FirmwareVersion.default[1],
                ['Protocol'] = one_power_intf_types.Protocol.default[1],
                ['DeviceLocator'] = one_power_intf_types.DeviceLocator.default[1],
                ['ProductionDate'] = one_power_intf_types.ProductionDate.default[1],
                ['Position'] = one_power_intf_types.Position.default[1],
                ['TotalRunningHours'] = one_power_intf_types.TotalRunningHours.default[1],
                ['LineInputVoltageType'] = 'Unknown',
                ['WorkMode'] = one_power_intf_types.WorkMode.default[1],
                ['RedundancyGroupId'] = one_power_intf_types.RedundancyGroupId.default[1],
                ['InputVoltageType'] = one_power_intf_types.InputVoltageType.default[1],
                ['DMTFPowerSupplyType'] = one_power_intf_types.DMTFPowerSupplyType.default[1],
                ['SourceType'] = one_power_intf_types.SourceType.default[1],
                ['IsPartOfSysPower'] = true,
                ['RelaySwitchedCount'] = one_power_intf_types.RelaySwitchedCount.default[1],
                ['DeepSleepStandbyPowerWatts'] = 65535
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetPowerWorkMode'] = privilege.PowerMgmt}},
            ['interface_types'] = one_power_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Metrics'] = {
            ['property_defaults'] = {
                ['OutputPowerWatts'] = one_power_metrics_intf_types.OutputPowerWatts.default[1],
                ['InputPowerWatts'] = one_power_metrics_intf_types.InputPowerWatts.default[1],
                ['InputVoltage'] = one_power_metrics_intf_types.InputVoltage.default[1],
                ['OutputVoltage'] = one_power_metrics_intf_types.OutputVoltage.default[1],
                ['InputCurrentAmps'] = one_power_metrics_intf_types.InputCurrentAmps.default[1],
                ['OutputCurrentAmps'] = one_power_metrics_intf_types.OutputCurrentAmps.default[1],
                ['Rate'] = one_power_metrics_intf_types.Rate.default[1],
                ['RatedCurrentAmps'] = one_power_metrics_intf_types.RatedCurrentAmps.default[1],
                ['InputFrequencyHz'] = one_power_metrics_intf_types.InputFrequencyHz.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = one_power_metrics_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Temperatures'] = {
            ['property_defaults'] = {
                ['EnvTemperatureCelsius'] = temperatures_intf_types.EnvTemperatureCelsius.default[1],
                ['PrimaryChipTemperatureCelsius'] = temperatures_intf_types.PrimaryChipTemperatureCelsius.default[1],
                ['SecondaryChipTemperatureCelsius'] = temperatures_intf_types.SecondaryChipTemperatureCelsius.default[1],
                ['InletTemperatureCelsius'] = temperatures_intf_types.InletTemperatureCelsius.default[1],
                ['InnerTemperatureCelsius'] = temperatures_intf_types.InnerTemperatureCelsius.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = temperatures_intf_types
        },
        ['bmc.kepler.Systems.PowerMgmt.OnePower.Status'] = {
            ['property_defaults'] = {
                ['OutputState'] = status_intf_types.OutputState.default[1],
                ['CommunicationStatus'] = status_intf_types.CommunicationStatus.default[1],
                ['Failure'] = status_intf_types.Failure.default[1],
                ['Fan1Fault'] = status_intf_types.Fan1Fault.default[1],
                ['Fan2Fault'] = status_intf_types.Fan2Fault.default[1],
                ['FanFault'] = status_intf_types.FanFault.default[1],
                ['InputVoltageFault'] = 32768,
                ['LossOfInput'] = status_intf_types.LossOfInput.default[1],
                ['OutputCurrentFault'] = status_intf_types.OutputCurrentFault.default[1],
                ['OutputVoltageFault'] = status_intf_types.OutputVoltageFault.default[1],
                ['OverTemperature'] = status_intf_types.OverTemperature.default[1],
                ['SleepMode'] = status_intf_types.SleepMode.default[1],
                ['DeepSleepEnabled'] = status_intf_types.DeepSleepEnabled.default[1],
                ['InputVoltageStatus'] = status_intf_types.InputVoltageStatus.default[1],
                ['DualInputVoltageStatus'] = status_intf_types.DualInputVoltageStatus.default[1],
                ['ScanStatus'] = status_intf_types.ScanStatus.default[1],
                ['CMLStatus'] = status_intf_types.CMLStatus.default[1],
                ['OtherStatus'] = status_intf_types.OtherStatus.default[1],
                ['MfrSpecificStatus'] = 255,
                ['Health'] = 255,
                ['IsUpgrading'] = status_intf_types.IsUpgrading.default[1],
                ['NormalAndRedundancySupported'] = status_intf_types.NormalAndRedundancySupported.default[1],
                ['EquipmentMode'] = 255,
                ['TPSUStatusHigh'] = status_intf_types.TPSUStatusHigh.default[1],
                ['TPSUStatusLow'] = status_intf_types.TPSUStatusLow.default[1],
                ['MainCircuitVINStatus'] = status_intf_types.MainCircuitVINStatus.default[1],
                ['BackupCircuitVINStatus'] = status_intf_types.BackupCircuitVINStatus.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['SetSleepMode'] = privilege.PowerMgmt}},
            ['interface_types'] = status_intf_types
        },
        ['bmc.kepler.Metric'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = metric_intf_types
        },
        ['bmc.kepler.Debug.BlackBox'] = {
            ['property_defaults'] = {},
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['DumpPsuBlackbox'] = privilege.ReadOnly}},
            ['interface_types'] = black_box_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PsuSlot = {
    ['table_name'] = 't_psu_slot',
    ['prop_configs'] = {
        ['SlotNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['validator'] = psu_slot_class_types.SlotNumber
        },
        ['SlotI2cAddr'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.SlotI2cAddr},
        ['FruI2cAddr'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.FruI2cAddr},
        ['Presence'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = psu_slot_class_types.Presence
        },
        ['I2cChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_slot_class_types.I2cChip
        },
        ['PsuChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterfaces'] = {'bmc.kepler.Chip', 'bmc.kepler.Chip.BlockIO'},
            ['validator'] = psu_slot_class_types.PsuChip
        },
        ['PsuBackupChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterfaces'] = {'bmc.kepler.Chip', 'bmc.kepler.Chip.BlockIO'},
            ['validator'] = psu_slot_class_types.PsuBackupChip
        },
        ['FruChip'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['refInterface'] = 'bmc.kepler.Chip.BlockIO',
            ['validator'] = psu_slot_class_types.FruChip
        },
        ['OutputState'] = {['usage'] = {'CSR'}, ['baseType'] = 'U8', ['validator'] = psu_slot_class_types.OutputState},
        ['FruSource'] = {
            ['usage'] = {'CSR'},
            ['enum'] = {0, 1, 2},
            ['baseType'] = 'U8',
            ['validator'] = psu_slot_class_types.FruSource
        },
        ['IsSupportPowerOnUpgrade'] = {
            ['usage'] = {'CSR'},
            ['default'] = true,
            ['baseType'] = 'Boolean',
            ['validator'] = psu_slot_class_types.IsSupportPowerOnUpgrade
        }
    },
    ['default_props'] = {
        ['SlotNumber'] = psu_slot_class_types.SlotNumber.default[1],
        ['SlotI2cAddr'] = psu_slot_class_types.SlotI2cAddr.default[1],
        ['FruI2cAddr'] = psu_slot_class_types.FruI2cAddr.default[1],
        ['Presence'] = 255,
        ['I2cChip'] = psu_slot_class_types.I2cChip.default[1],
        ['PsuChip'] = psu_slot_class_types.PsuChip.default[1],
        ['PsuBackupChip'] = psu_slot_class_types.PsuBackupChip.default[1],
        ['FruChip'] = psu_slot_class_types.FruChip.default[1],
        ['OutputState'] = psu_slot_class_types.OutputState.default[1],
        ['FruSource'] = psu_slot_class_types.FruSource.default[1],
        ['IsSupportPowerOnUpgrade'] = true
    }
}

local AclostRecordTable = {
    ['table_name'] = 't_aclost_record',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String',
            ['validator'] = aclost_record_table_class_types.Id
        },
        ['CurTime'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U32',
            ['validator'] = aclost_record_table_class_types.CurTime
        },
        ['CurTimeSource'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'String',
            ['validator'] = aclost_record_table_class_types.CurTimeSource
        },
        ['Flag'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U32',
            ['validator'] = aclost_record_table_class_types.Flag
        },
        ['ResetFlag'] = {
            ['usage'] = {'ResetPer'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = aclost_record_table_class_types.ResetFlag
        },
        ['ShieldAclostEventRecord'] = {
            ['usage'] = {'PoweroffPer'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = aclost_record_table_class_types.ShieldAclostEventRecord
        }
    },
    ['default_props'] = {
        ['Id'] = aclost_record_table_class_types.Id.default[1],
        ['CurTime'] = aclost_record_table_class_types.CurTime.default[1],
        ['CurTimeSource'] = aclost_record_table_class_types.CurTimeSource.default[1],
        ['Flag'] = aclost_record_table_class_types.Flag.default[1],
        ['ResetFlag'] = 0,
        ['ShieldAclostEventRecord'] = 255
    }
}

local DftPowerSupply = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/SelfTest/DftPowerSupply/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerConfiguration = {
    ['table_name'] = 't_power_configuration',
    ['prop_configs'] = {
        ['SinglePsuSupport'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 0,
            ['validator'] = power_configuration_class_types.SinglePsuSupport
        },
        ['Id'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['primaryKey'] = true,
            ['default'] = 1,
            ['validator'] = power_configuration_class_types.Id
        },
        ['MinAvailablePSUCountForUpgrade'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8',
            ['default'] = 255,
            ['validator'] = power_configuration_class_types.MinAvailablePSUCountForUpgrade
        }
    },
    ['default_props'] = {['SinglePsuSupport'] = 0, ['Id'] = 1, ['MinAvailablePSUCountForUpgrade'] = 255}
}

local SystemPower = {
    ['table_name'] = 't_syspower_cfg',
    ['prop_configs'] = {
        ['Id'] = {
            ['primaryKey'] = true,
            ['baseType'] = 'String',
            ['default'] = 'SystemPower',
            ['validator'] = system_power_class_types.Id
        },
        ['PsuFruConfig'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['validator'] = system_power_class_types.PsuFruConfig
        },
        ['CalibrateAccumulatedTime'] = {
            ['baseType'] = 'U32',
            ['default'] = 0,
            ['validator'] = system_power_class_types.CalibrateAccumulatedTime
        }
    },
    ['default_props'] = {['Id'] = 'SystemPower', ['PsuFruConfig'] = 0, ['CalibrateAccumulatedTime'] = 0}
}

local DftCanChannel = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Type'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Type
            },
            ['Id'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Id
            },
            ['Slot'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.Slot
            },
            ['Param'] = {
                ['baseType'] = 'U8[]',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = manufacture_intf_types.Param
            },
            ['DeviceNum'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.DeviceNum
            },
            ['ItemName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ItemName
            },
            ['PrompteReady'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteReady
            },
            ['PrompteFinish'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.PrompteFinish
            },
            ['ProcessPeriod'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['usage'] = {'CSR'},
                ['validator'] = manufacture_intf_types.ProcessPeriod
            },
            ['Status'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {'Complete', 'Testing', 'Unstart'},
                ['default'] = 'Unstart',
                ['validator'] = manufacture_intf_types.Status
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.Manufacture'] = {
            ['Start'] = {['req'] = {}, ['rsp'] = {}},
            ['Stop'] = {['req'] = {}, ['rsp'] = {}},
            ['GetResult'] = {
                ['req'] = {},
                ['rsp'] = {
                    {['baseType'] = 'String', ['enum'] = {'Succeed', 'Failed', 'Non'}, ['param'] = 'Status'},
                    {['baseType'] = 'String', ['param'] = 'Description'}
                }
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/Manufacture/InteractTest/DftCanChannel/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.Manufacture'] = {
            ['property_defaults'] = {
                ['Type'] = manufacture_intf_types.Type.default[1],
                ['Id'] = manufacture_intf_types.Id.default[1],
                ['Slot'] = manufacture_intf_types.Slot.default[1],
                ['Param'] = manufacture_intf_types.Param.default[1],
                ['DeviceNum'] = manufacture_intf_types.DeviceNum.default[1],
                ['ItemName'] = manufacture_intf_types.ItemName.default[1],
                ['PrompteReady'] = manufacture_intf_types.PrompteReady.default[1],
                ['PrompteFinish'] = manufacture_intf_types.PrompteFinish.default[1],
                ['ProcessPeriod'] = manufacture_intf_types.ProcessPeriod.default[1],
                ['Status'] = 'Unstart'
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = manufacture_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerOutputEfficiencyCurve = {
    ['table_name'] = 't_power_efficiency_curve',
    ['prop_configs'] = {
        ['Position'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = power_output_efficiency_curve_class_types.Position
        },
        ['PartNumber'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['primaryKey'] = true,
            ['validator'] = power_output_efficiency_curve_class_types.PartNumber
        },
        ['InputVoltage'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U16',
            ['primaryKey'] = true,
            ['validator'] = power_output_efficiency_curve_class_types.InputVoltage
        },
        ['LoadPercentRange'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'U8[]',
            ['validator'] = power_output_efficiency_curve_class_types.LoadPercentRange
        },
        ['EfficiencyCurve'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'Double[]',
            ['validator'] = power_output_efficiency_curve_class_types.EfficiencyCurve
        },
        ['PowerLevel'] = {
            ['usage'] = {'CSR'},
            ['baseType'] = 'String',
            ['default'] = 'N/A',
            ['enum'] = {
                '80PLUS', '80PLUS Bronze', '80PLUS Silver', '80PLUS Gold', '80PLUS Platinum', '80PLUS Titanium', 'N/A'
            },
            ['validator'] = power_output_efficiency_curve_class_types.PowerLevel
        }
    },
    ['default_props'] = {
        ['Position'] = power_output_efficiency_curve_class_types.Position.default[1],
        ['PartNumber'] = power_output_efficiency_curve_class_types.PartNumber.default[1],
        ['InputVoltage'] = power_output_efficiency_curve_class_types.InputVoltage.default[1],
        ['LoadPercentRange'] = power_output_efficiency_curve_class_types.LoadPercentRange.default[1],
        ['EfficiencyCurve'] = power_output_efficiency_curve_class_types.EfficiencyCurve.default[1],
        ['PowerLevel'] = 'N/A'
    }
}

local PowerDistribution = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfiguration'] = {
            ['ExpectedPowerSupplyCircuit'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant',
                    'ParityCrossRedundant'
                },
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = transfer_configuration_intf_types.ExpectedPowerSupplyCircuit
            },
            ['CurrentPowerSupplyCircuit'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant',
                    'ParityCrossRedundant'
                },
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = transfer_configuration_intf_types.CurrentPowerSupplyCircuit
            },
            ['RetransferDelaySeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = transfer_configuration_intf_types.RetransferDelaySeconds
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfiguration'] = {
            ['SetExpectedPowerSupplyCircuit'] = {
                ['req'] = {
                    {
                        ['baseType'] = 'String',
                        ['enum'] = {
                            'MainCircuit', 'BackupCircuit', 'HalfCrossRedundant', 'QuarterCrossRedundant',
                            'ParityCrossRedundant'
                        },
                        ['param'] = 'PowerSupplyCircuit'
                    }
                },
                ['rsp'] = {{['baseType'] = 'U32', ['param'] = 'TaskId'}},
                ['privilege'] = {'PowerMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/PowerEquipment/PowerDistribution'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfiguration'] = {
            ['property_defaults'] = {
                ['ExpectedPowerSupplyCircuit'] = transfer_configuration_intf_types.ExpectedPowerSupplyCircuit.default[1],
                ['CurrentPowerSupplyCircuit'] = transfer_configuration_intf_types.CurrentPowerSupplyCircuit.default[1],
                ['RetransferDelaySeconds'] = transfer_configuration_intf_types.RetransferDelaySeconds.default[1]
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['methods'] = {['SetExpectedPowerSupplyCircuit'] = privilege.PowerMgmt}
            },
            ['interface_types'] = transfer_configuration_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local PowerDistributionId = {
    ['prop_configs'] = {},
    ['default_props'] = {},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.PowerEquipment.PowerDistribution'] = {
            ['Health'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 0,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['validator'] = power_distribution_intf_types.Health
            },
            ['Version'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.Version
            },
            ['UUID'] = {
                ['baseType'] = 'String',
                ['pattern'] = [=[^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$]=],
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.UUID
            },
            ['UserLabel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minLength'] = 1,
                ['maxLength'] = 20,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = power_distribution_intf_types.UserLabel
            },
            ['EquipmentType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['enum'] = {
                    'RackPDU', 'FloorPDU', 'Switchgear', 'PowerShelf', 'AutomaticTransferSwitch',
                    'ManualTransferSwitch', ''
                },
                ['validator'] = power_distribution_intf_types.EquipmentType
            },
            ['AssetTag'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minLength'] = 1,
                ['maxLength'] = 20,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = power_distribution_intf_types.AssetTag
            },
            ['FirmwareVersion'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.FirmwareVersion
            },
            ['Manufacturer'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.Manufacturer
            },
            ['Model'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.Model
            },
            ['PartNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.PartNumber
            },
            ['SerialNumber'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.SerialNumber
            },
            ['ProductionDate'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['minLength'] = 1,
                ['maxLength'] = 20,
                ['validator'] = power_distribution_intf_types.ProductionDate
            },
            ['PowerCapacityVA'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.PowerCapacityVA
            },
            ['LocationServiceLabel'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.LocationServiceLabel
            },
            ['LocationReference'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Top', 'Bottom', 'Front', 'Rear', 'Left', 'Right', 'Middle', ''},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.LocationReference
            },
            ['LocationOrientation'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {
                    'BackToFront', 'BottomToTop', 'FrontToBack', 'LeftToRight', 'RightToLeft', 'TopToBottom', ''
                },
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.LocationOrientation
            },
            ['LocationType'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['enum'] = {'Backplane', 'Bay', 'Connector', 'Embedded', 'Slot', 'Socket', ''},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.LocationType
            },
            ['LocationOrdinalValue'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_intf_types.LocationOrdinalValue
            }
        },
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfig'] = {
            ['ActiveMainsId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.ActiveMainsId
            },
            ['AutoTransferEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.AutoTransferEnabled
            },
            ['ClosedTransitionAllowed'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.ClosedTransitionAllowed
            },
            ['ClosedTransitionTimeoutSeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 4294967295,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.ClosedTransitionTimeoutSeconds
            },
            ['PreferredMainsId'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.PreferredMainsId
            },
            ['RetransferDelaySeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 4294967295,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.RetransferDelaySeconds
            },
            ['RetransferEnabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.RetransferEnabled
            },
            ['TransferInhibit'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.TransferInhibit
            },
            ['TransferDelaySeconds'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 4294967295,
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.TransferDelaySeconds
            },
            ['OverNominalFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.OverNominalFrequencyHz
            },
            ['OverVoltageRMSPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.OverVoltageRMSPercent
            },
            ['TransferSensitivity'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['enum'] = {'Low', 'Medium', 'High', ''},
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.TransferSensitivity
            },
            ['UnderNominalFrequencyHz'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.UnderNominalFrequencyHz
            },
            ['UnderVoltageRMSPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = false,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'PowerMgmt'}},
                ['validator'] = transfer_config_intf_types.UnderVoltageRMSPercent
            }
        },
        ['bmc.kepler.PowerEquipment.PowerDistribution.Metrics'] = {
            ['AbsoluteHumidity'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.AbsoluteHumidity
            },
            ['EnergyApparentkVAh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.EnergyApparentkVAh
            },
            ['EnergyLifetimekWh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.EnergyLifetimekWh
            },
            ['EnergyReactivekVARh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.EnergyReactivekVARh
            },
            ['EnergykWh'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.EnergykWh
            },
            ['EnergySensorResetTime'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.EnergySensorResetTime
            },
            ['HumidityPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.HumidityPercent
            },
            ['PowerLoadPercent'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerLoadPercent
            },
            ['PowerApparentVA'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerApparentVA
            },
            ['PowerPhaseAngleDegrees'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = 1000,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerPhaseAngleDegrees
            },
            ['PowerFactor'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerFactor
            },
            ['PowerReactiveVAR'] = {
                ['baseType'] = 'Double',
                ['readOnly'] = true,
                ['default'] = -1,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerReactiveVAR
            },
            ['PowerWatts'] = {
                ['baseType'] = 'U32',
                ['readOnly'] = true,
                ['default'] = 4294967295,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.PowerWatts
            },
            ['TemperatureCelsius'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['default'] = 255,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['validator'] = power_distribution_metrics_intf_types.TemperatureCelsius
            }
        },
        ['bmc.kepler.Object.Properties'] = {
            ['ClassName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ClassName
            },
            ['ObjectName'] = {
                ['baseType'] = 'String',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectName
            },
            ['ObjectIdentifier'] = {
                ['baseType'] = 'Struct',
                ['$ref'] = '#/defs/StructIdentifier',
                ['readOnly'] = true,
                ['validator'] = properties_intf_types.ObjectIdentifier
            }
        }
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfig'] = {
            ['TransferControl'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'PowerMgmt'}}
        },
        ['bmc.kepler.PowerEquipment.PowerDistribution.Metrics'] = {
            ['ResetMetrics'] = {['req'] = {}, ['rsp'] = {}, ['privilege'] = {'PowerMgmt'}}
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/PowerEquipment/PowerDistribution/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.PowerEquipment.PowerDistribution'] = {
            ['property_defaults'] = {
                ['Health'] = 0,
                ['Version'] = power_distribution_intf_types.Version.default[1],
                ['UUID'] = power_distribution_intf_types.UUID.default[1],
                ['UserLabel'] = power_distribution_intf_types.UserLabel.default[1],
                ['EquipmentType'] = power_distribution_intf_types.EquipmentType.default[1],
                ['AssetTag'] = power_distribution_intf_types.AssetTag.default[1],
                ['FirmwareVersion'] = power_distribution_intf_types.FirmwareVersion.default[1],
                ['Manufacturer'] = power_distribution_intf_types.Manufacturer.default[1],
                ['Model'] = power_distribution_intf_types.Model.default[1],
                ['PartNumber'] = power_distribution_intf_types.PartNumber.default[1],
                ['SerialNumber'] = power_distribution_intf_types.SerialNumber.default[1],
                ['ProductionDate'] = power_distribution_intf_types.ProductionDate.default[1],
                ['PowerCapacityVA'] = 4294967295,
                ['LocationServiceLabel'] = power_distribution_intf_types.LocationServiceLabel.default[1],
                ['LocationReference'] = power_distribution_intf_types.LocationReference.default[1],
                ['LocationOrientation'] = power_distribution_intf_types.LocationOrientation.default[1],
                ['LocationType'] = power_distribution_intf_types.LocationType.default[1],
                ['LocationOrdinalValue'] = 255
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['UserLabel'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['AssetTag'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}
                }
            },
            ['interface_types'] = power_distribution_intf_types
        },
        ['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfig'] = {
            ['property_defaults'] = {
                ['ActiveMainsId'] = transfer_config_intf_types.ActiveMainsId.default[1],
                ['AutoTransferEnabled'] = transfer_config_intf_types.AutoTransferEnabled.default[1],
                ['ClosedTransitionAllowed'] = transfer_config_intf_types.ClosedTransitionAllowed.default[1],
                ['ClosedTransitionTimeoutSeconds'] = 4294967295,
                ['PreferredMainsId'] = transfer_config_intf_types.PreferredMainsId.default[1],
                ['RetransferDelaySeconds'] = 4294967295,
                ['RetransferEnabled'] = transfer_config_intf_types.RetransferEnabled.default[1],
                ['TransferInhibit'] = transfer_config_intf_types.TransferInhibit.default[1],
                ['TransferDelaySeconds'] = 4294967295,
                ['OverNominalFrequencyHz'] = transfer_config_intf_types.OverNominalFrequencyHz.default[1],
                ['OverVoltageRMSPercent'] = 255,
                ['TransferSensitivity'] = transfer_config_intf_types.TransferSensitivity.default[1],
                ['UnderNominalFrequencyHz'] = transfer_config_intf_types.UnderNominalFrequencyHz.default[1],
                ['UnderVoltageRMSPercent'] = 255
            },
            ['privileges'] = {
                ['path'] = privilege.ReadOnly,
                ['props'] = {
                    ['ActiveMainsId'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['AutoTransferEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['ClosedTransitionAllowed'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['ClosedTransitionTimeoutSeconds'] = {
                        ['read'] = privilege.ReadOnly,
                        ['write'] = privilege.PowerMgmt
                    },
                    ['PreferredMainsId'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['RetransferDelaySeconds'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['RetransferEnabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['TransferInhibit'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['TransferDelaySeconds'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['OverNominalFrequencyHz'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['OverVoltageRMSPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['TransferSensitivity'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['UnderNominalFrequencyHz'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt},
                    ['UnderVoltageRMSPercent'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.PowerMgmt}
                },
                ['methods'] = {['TransferControl'] = privilege.PowerMgmt}
            },
            ['interface_types'] = transfer_config_intf_types
        },
        ['bmc.kepler.PowerEquipment.PowerDistribution.Metrics'] = {
            ['property_defaults'] = {
                ['AbsoluteHumidity'] = -1,
                ['EnergyApparentkVAh'] = -1,
                ['EnergyLifetimekWh'] = -1,
                ['EnergyReactivekVARh'] = -1,
                ['EnergykWh'] = -1,
                ['EnergySensorResetTime'] = power_distribution_metrics_intf_types.EnergySensorResetTime.default[1],
                ['HumidityPercent'] = 255,
                ['PowerLoadPercent'] = 255,
                ['PowerApparentVA'] = -1,
                ['PowerPhaseAngleDegrees'] = 1000,
                ['PowerFactor'] = -1,
                ['PowerReactiveVAR'] = -1,
                ['PowerWatts'] = 4294967295,
                ['TemperatureCelsius'] = 255
            },
            ['privileges'] = {['path'] = privilege.ReadOnly, ['methods'] = {['ResetMetrics'] = privilege.PowerMgmt}},
            ['interface_types'] = power_distribution_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['privileges'] = {['path'] = privilege.ReadOnly},
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('PowerSupplies', PowerSupplies):set_bus(bus)
    class('Circuit', Circuit):set_bus(bus)
    class('PowerMgmt', PowerMgmt):set_bus(bus)
    class('OnePower', OnePower):set_bus(bus)
    class('PowerConverter', PowerConverter):set_bus(bus)
    class('PsuSlot', PsuSlot):set_bus(bus)
    class('AclostRecordTable', AclostRecordTable):set_bus(bus)
    class('DftPowerSupply', DftPowerSupply):set_bus(bus)
    class('PowerConfiguration', PowerConfiguration):set_bus(bus)
    class('SystemPower', SystemPower):set_bus(bus)
    class('DftCanChannel', DftCanChannel):set_bus(bus)
    class('PowerOutputEfficiencyCurve', PowerOutputEfficiencyCurve):set_bus(bus)
    class('PowerDistribution', PowerDistribution):set_bus(bus)
    class('PowerDistributionId', PowerDistributionId):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplPowerSuppliesPowerSuppliesSetPsusFanMinPWM(cb)
    class('PowerSupplies')['bmc.kepler.Chassis.PowerSubsystem.PowerSupplies'].SetPsusFanMinPWM = function(obj, ctx, ...)
        local req = power_supplies_intf_types.SetPsusFanMinPWMReq.new(...):validate(nil, nil, true)
        local rsp = power_supplies_intf_types.SetPsusFanMinPWMRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerOnePowerSetPowerWorkMode(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerWorkMode = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerWorkModeReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerWorkModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerOnePowerReset(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower'].Reset = function(obj, ctx, ...)
        local req = one_power_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerOnePowerSetPowerSupplyCircuit(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerSupplyCircuit = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerSupplyCircuitReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerSupplyCircuitRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerOutputControlSetOutputPowerLimitWatts(cb)
    class('OnePower')['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.OutputControl'].SetOutputPowerLimitWatts =
        function(obj, ctx, ...)
            local req = output_control_intf_types.SetOutputPowerLimitWattsReq.new(...):validate(nil, nil, true)
            local rsp = output_control_intf_types.SetOutputPowerLimitWattsRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerPowerSupplyMetricsReset(cb)
    class('OnePower')['bmc.kepler.Chassis.PowerSubsystem.PowerSupply.Metrics'].Reset = function(obj, ctx, ...)
        local req = power_supply_metrics_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = power_supply_metrics_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerStatusSetSleepMode(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetSleepMode = function(obj, ctx, ...)
        local req = status_intf_types.SetSleepModeReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetSleepModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerStatusSetAlarmLatch(cb)
    class('OnePower')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetAlarmLatch = function(obj, ctx, ...)
        local req = status_intf_types.SetAlarmLatchReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetAlarmLatchRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricGetData(cb)
    class('OnePower')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricGetItems(cb)
    class('OnePower')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerMetricSynDataAcquisitionEnable(cb)
    class('OnePower')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerCollectorGetFanSpeed(cb)
    class('OnePower')['bmc.kepler.Release.OnePower.Collector'].GetFanSpeed = function(obj, ctx, ...)
        local req = collector_intf_types.GetFanSpeedReq.new(...):validate(nil, nil, true)
        local rsp = collector_intf_types.GetFanSpeedRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerCollectorGetRegisterValue(cb)
    class('OnePower')['bmc.kepler.Release.OnePower.Collector'].GetRegisterValue = function(obj, ctx, ...)
        local req = collector_intf_types.GetRegisterValueReq.new(...):validate(nil, nil, true)
        local rsp = collector_intf_types.GetRegisterValueRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerCapacitorReset(cb)
    class('OnePower')['bmc.kepler.Chassis.PowerSubsystem.Capacitor'].Reset = function(obj, ctx, ...)
        local req = capacitor_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = capacitor_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerCapacitorSetVOUTDebounceMilliseconds(cb)
    class('OnePower')['bmc.kepler.Chassis.PowerSubsystem.Capacitor'].SetVOUTDebounceMilliseconds =
        function(obj, ctx, ...)
            local req = capacitor_intf_types.SetVOUTDebounceMillisecondsReq.new(...):validate(nil, nil, true)
            local rsp = capacitor_intf_types.SetVOUTDebounceMillisecondsRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplOnePowerCapacitorSetDepthOfDischargeVolts(cb)
    class('OnePower')['bmc.kepler.Chassis.PowerSubsystem.Capacitor'].SetDepthOfDischargeVolts = function(obj, ctx, ...)
        local req = capacitor_intf_types.SetDepthOfDischargeVoltsReq.new(...):validate(nil, nil, true)
        local rsp = capacitor_intf_types.SetDepthOfDischargeVoltsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterOnePowerSetPowerWorkMode(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerWorkMode = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerWorkModeReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerWorkModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterOnePowerReset(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower'].Reset = function(obj, ctx, ...)
        local req = one_power_intf_types.ResetReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.ResetRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterOnePowerSetPowerSupplyCircuit(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower'].SetPowerSupplyCircuit = function(obj, ctx, ...)
        local req = one_power_intf_types.SetPowerSupplyCircuitReq.new(...):validate(nil, nil, true)
        local rsp = one_power_intf_types.SetPowerSupplyCircuitRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterStatusSetSleepMode(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetSleepMode = function(obj, ctx, ...)
        local req = status_intf_types.SetSleepModeReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetSleepModeRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterStatusSetAlarmLatch(cb)
    class('PowerConverter')['bmc.kepler.Systems.PowerMgmt.OnePower.Status'].SetAlarmLatch = function(obj, ctx, ...)
        local req = status_intf_types.SetAlarmLatchReq.new(...):validate(nil, nil, true)
        local rsp = status_intf_types.SetAlarmLatchRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricGetData(cb)
    class('PowerConverter')['bmc.kepler.Metric'].GetData = function(obj, ctx, ...)
        local req = metric_intf_types.GetDataReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricGetItems(cb)
    class('PowerConverter')['bmc.kepler.Metric'].GetItems = function(obj, ctx, ...)
        local req = metric_intf_types.GetItemsReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.GetItemsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterMetricSynDataAcquisitionEnable(cb)
    class('PowerConverter')['bmc.kepler.Metric'].SynDataAcquisitionEnable = function(obj, ctx, ...)
        local req = metric_intf_types.SynDataAcquisitionEnableReq.new(...):validate(nil, nil, true)
        local rsp = metric_intf_types.SynDataAcquisitionEnableRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerConverterBlackBoxDumpPsuBlackbox(cb)
    class('PowerConverter')['bmc.kepler.Debug.BlackBox'].DumpPsuBlackbox = function(obj, ctx, ...)
        local req = black_box_intf_types.DumpPsuBlackboxReq.new(...):validate(nil, nil, true)
        local rsp = black_box_intf_types.DumpPsuBlackboxRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureStart(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureStop(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftPowerSupplyManufactureGetResult(cb)
    class('DftPowerSupply')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureStart(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].Start = function(obj, ctx, ...)
        local req = manufacture_intf_types.StartReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StartRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureStop(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].Stop = function(obj, ctx, ...)
        local req = manufacture_intf_types.StopReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.StopRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplDftCanChannelManufactureGetResult(cb)
    class('DftCanChannel')['bmc.kepler.Manufacture'].GetResult = function(obj, ctx, ...)
        local req = manufacture_intf_types.GetResultReq.new(...):validate(nil, nil, true)
        local rsp = manufacture_intf_types.GetResultRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerDistributionTransferConfigurationSetExpectedPowerSupplyCircuit(cb)
    class('PowerDistribution')['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfiguration']
        .SetExpectedPowerSupplyCircuit = function(obj, ctx, ...)
        local req = transfer_configuration_intf_types.SetExpectedPowerSupplyCircuitReq.new(...):validate(nil, nil, true)
        local rsp =
            transfer_configuration_intf_types.SetExpectedPowerSupplyCircuitRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerDistributionIdTransferConfigTransferControl(cb)
    class('PowerDistributionId')['bmc.kepler.PowerEquipment.PowerDistribution.TransferConfig'].TransferControl =
        function(obj, ctx, ...)
            local req = transfer_config_intf_types.TransferControlReq.new(...):validate(nil, nil, true)
            local rsp = transfer_config_intf_types.TransferControlRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

-- The callback needs to be registered during app initialization
function M.ImplPowerDistributionIdPowerDistributionMetricsResetMetrics(cb)
    class('PowerDistributionId')['bmc.kepler.PowerEquipment.PowerDistribution.Metrics'].ResetMetrics =
        function(obj, ctx, ...)
            local req = power_distribution_metrics_intf_types.ResetMetricsReq.new(...):validate(nil, nil, true)
            local rsp = power_distribution_metrics_intf_types.ResetMetricsRsp.new(cb(obj, ctx, req:unpack())):validate()
            return rsp:unpack(true)
        end
end

return M
