*openUBMC 支持电源远程解锁能力功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>lisongwei</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025/11/26</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>2025/11/26</td>
        <td>1.0</td>
        <td>初稿</td>
        <td>lisongwei</td>
        <td>/</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>BMC</td>
        <td>Baseboard Management Controller</td>
        <td>基板管理控制器</td>
    </tr>
    <tr>
        <td>PSU</td>
        <td>Power Supply Unit</td>
        <td>电源供应单元</td>
    </tr>
    <tr>
        <td>PMBus</td>
        <td>Power Management Bus</td>
        <td>电源管理总线</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
当电源遇到电气故障如电压不稳触发死锁保护后，需要现场拔插操作进行恢复，导致故障恢复周期长。支持电源远程复位操作后，可以通过复位电源的方式实现电源远程解锁，显著降低故障恢复时间。

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
本功能新增一条CLI命令，用户可以登录BMC后台使用该命令，从而向指定PSU发送复位命令。

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
### 1.3.1 场景触发条件及对象
使用角色：系统管理员。
使用工具：CLI命令。
使用技能：具备基本的BMC管理经验。
### 1.3.2 使用时间及频度
使用时间：当电源触发死锁保护后，恢复时执行。
### 1.3.3 主要场景及子场景
机架场景，当电源触发死锁保护时，使用命令远程发起复位。

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 电源强制复位接口 | 依据CLI命令标准，提供强制复位PSU接口 |
| 2 | 基于PMBus协议复位PSU | 基于PMBus协议，实施复位PSU的动作 |

# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->
本方案依据CLI标准接口，新增复位指定PSU的接口。用户在执行该接口时，需要传入待复位PSU的编号和复位方式作为入参。CLI命令执行时，判断用户输入参数的合法性，之后将参数传给power_mgmt组件的PSU复位函数。power_mgmt组件根据传入的参数，基于PMBus协议向PSU发送命令字，从而实现复位功能。函数执行完成后，CLI命令获取函数的执行结果，并回显相关信息给用户呈现。

此外，该命令只在机架场景新增。对于机柜场景，需要修改产品仓代码配置，移除该新增命令，确保命令在机柜场景中不存在。

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->
1) 本方案在CLI命令下新增映射器配置，在默认target下新增一个dataitem，命名为psuswitch，用于实现PSU复位功能的命令入口。该映射器接受两个入参，为PSU的编号以及对该PSU实施的操作。
2) 用户传入参数后，映射器首先对输入的参数进行校验以及转换，具体需要执行以下操作：
   * 检查用户输入的PSU编号符合规则，并将输入的编号由字符串转换为数字。
   * 检查用户输入的操作在支持范围内（当前仅支持输入的操作为强制复位），并将输入的操作由数字转换为字符串。
3) 完成参数转换后，映射器需要在资源树中查询是否有与用户输入PSU编号一致的OnePower对象。如果未查询到符合要求的对象，说明用户输入的编号有误，返回错误。如果查询到对象，则调用该对象提供的Reset函数，并将用户输入的操作作为参数传入。
4) Reset函数收到入参后，执行内部的复位流程。power_mgmt模块在初始化时会根据当前环境上电源具体使用的协议，挂接对应的操作函数。Reset函数内部流程将通过PMBus协议向PSU发送命令字，从而完成复位动作。
5) Reset函数执行完毕后，映射器获取该函数的执行结果，对返回值进行解析，并在屏幕上显示对应的回显信息。

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```mermaid
graph TB
    subgraph A[BMC后台页面]
        A1[用户输入CLI命令]
        A2[北向接口组件]
    end

    subgraph B[mdb_service]
        B1[资源树路径查询]
    end

    subgraph C[power_mgmt]
        C1[电源组件控制驱动]
        C2[电源组件读写接口]
    end

    subgraph D[硬件层]
        D1[电源组件读写接口]
        D2[电源硬件单元] 
    end

    A1 --> A2
    A2 --> B1
    B1 --> A2
    A2 --> C1
    C1 --> C2
    C2 --> D1
    D1 --> D2
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->
```mermaid
sequenceDiagram
    participant User as 用户
    participant Remote as 北向接口组件
    participant MDB as mdb_service组件
    participant PM as power_mgmt组件
    participant Driver as 电源控制驱动
    participant HW as 电源硬件

    User->>Remote: 发送强制复位命令
    Note over Remote: 命令入参校验
    Remote->>MDB: 查询电源模块资源树路径
    MDB-->>Remote: 返回资源树路径
    Note over Remote: 路径有效性校验
    Remote->>PM: 发送强制复位命令
    PM->>Driver: 调用强制复位接口
    Driver->>HW: 发送强制复位命令字
    HW-->>Driver: 返回操作结果
    Driver-->>PM: 返回操作结果
    PM-->>Remote: 返回操作结果
    Remote-->>User: 返回操作结果
```

### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
本功能同时依赖power_mgmt组件和北向接口进行开发。一方面，需要北向接口新增开发该CLI命令；另一方面需要power_mgmt组件实现复位PSU的功能函数，并在资源树中提供。对于北向接口组件，当前CLI命令中不存在操作PSU的相关dataitem，需要新增命令。对于power_mgmt组件，当前已经在资源树上提供了复位PSU的总接口，但是并未具体实现基于PMBus实现复位操作的内部接口。因此为实现本功能，两个组件均需要新增功能。

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
不涉及

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持电源远程解锁能力 | NA | 是，新增ipmcset接口，新增的dataitem为psuswitch | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
当前功能对现有在网的功能无影响。新增的CLI命令需要人工执行才会触发，在不执行该新增命令的前提下，系统运行状况和新增该命令前的状态相比无变化。

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
不涉及

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
| 用例编号 |	用例名称 |	前置条件 |	操作步骤  |	预期结果 |
| ---- | ---- | --- | ------ | ---------------- | 
| 1 | 发送CLI命令复位正常PSU | 1. BMC正常运行<br>2. 环境上有两个以上PSU，且均处于正常状态 | 1. 登录BMC后台，执行ipmcset命令复位PSU，预期有结果a | a. PSU发生复位，复位后正常运行 |
| 2 | 发送CLI命令复位异常PSU | 1. BMC正常运行<br>2. 环境上有两个以上PSU，待操作PSU处于死锁保护状态，其余均处于正常状态 | 1. 登录BMC后台，执行ipmcset命令复位PSU，预期有结果a | a. PSU发生复位，复位后正常运行 | 
| 3 | 发送CLI命令复位唯一PSU | 1. BMC正常运行<br>2. 环境上仅有一个PSU | 1. 登录BMC后台，执行ipmcset命令复位PSU，预期有结果a | a. ipmcset命令回显失败，无PSU发生复位 | 
| 4 | 发送CLI命令连续复位PSU | 1. BMC正常运行<br>2. 环境上有两个以上PSU，且均处于正常状态 | 1. 登录BMC后台，执行ipmcset命令复位PSU1，预期有结果a<br>2. 执行ipmcset命令复位PSU2，预期有结果b<br>3. 等待60秒后，执行ipmcset命令复位PSU2，预期有结果c | a. ipmcset命令回显成功<br>b. ipmcset命令回显失败<br>c. ipmcset命令回显成功 | 
| 5 | CLI命令传入无效PSU编号 | 1. BMC正常运行 | 1. 登录BMC后台，执行ipmcset命令复位PSU，传入的PSU编号超出环境上PSU的实际数量，预期有结果a | a. ipmcset命令回显失败，无PSU发生复位 |
| 6 | CLI命令传入无效PSU字符串 | 1. BMC正常运行 | 1. 登录BMC后台，执行ipmcset命令复位PSU，传入的PSU编号不符合格式要求，预期有结果a | a. ipmcset命令回显失败，无PSU发生复位 |
| 7 | CLI命令传入无效操作 | 1. BMC正常运行 | 1. 登录BMC后台，执行ipmcset命令复位PSU，传入的操作不为强制复位，预期有结果a | a. ipmcset命令回显失败，无PSU发生复位 |
| 8 | 在不支持环境执行复位PSU命令 | 1. BMC正常运行<br>2. 操作环境为机柜环境 | 1. 登录BMC后台，执行ipmcset命令复位PSU，预期有结果a | a. ipmcset命令回显失败，回显提示无该命令 |

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
本方案开发的新增命令具有良好扩展性，后续开发CLI命令对PSU执行其他操作时，可以通过新增该命令下支持解析的操作完成传入，无需开发新CLI命令。power_mgmt组件内部接收到其他操作的入参后，通过解析入参取值即可开发对应的新功能，无需对整体架构进行大规模调整。

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
本方案中新开发的基于PMBus协议对PSU进行复位的流程为通用处理方式。该复位功能可以在power_mgmt组件中由其他业务流程调用，也可以由其他类似的北向接口调用。

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
可直接验证。

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
本功能涉及资料修改，需要在CLI接口文档中新增该接口的相关说明，以便用户了解和使用该接口。

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->

### 2.2.6 可靠性分析
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | BMC场景 | BMC重启 | 重启期间无法发送命令 | 一般 | BMC重启完成后，自动恢复北向接口服务 | 系统默认支持该功能 |||
| 2 | 服务重启 | 北向接口服务重启 | 重启期间无法发送命令 | 一般 | 服务重启完成后自动重新注册接口 | 系统默认支持该功能 |||
| 3 | 环境只有一个PSU时进行复位 | 环境只有一个PSU时进行复位 | PSU复位会导致环境掉电 | 一般 | 复位接口进行校验，当复位的PSU是唯一可用的PSU时禁止复位 | 新开发该功能 |||
| 4 | 同时复位多个PSU | 环境存在两个PSU，同时进行复位 | PSU复位会导致环境掉电 | 一般 | PSU复位时，60秒内禁止再进行PSU复位操作 | 继承V2判断条件与时间规格 |||
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 是 | 基于CLI命令的标准访问控制机制 |
| 敏感数据 | 否 | 无 |
| 日志（操作日志、维护日志、安全日志、运行日志） | 否 | 无 |
| 文档 | 是 | 提供完善的接口文档，说明接口的使用方法、安全注意事项等 |
| 加密及算法 | 否 | 无 |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 否 | 无 |
| 新增对外接口入参校验 | 是 | 对接口的查询参数进行校验，防止无效参数或恶意参数导致的系统异常 |
| 新增开源及三方软件引入 | 否 | 无 |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1 电源强制复位接口
### 3.1.1 功能实现设计
本功能新增映射器配置，允许用户执行CLI命令，指定dataitem为psuswitch，并传入PSU编号以及希望执行的操作。映射器接受用户的传入后进行必要的参数校验以及转换，之后调用传入PSU对应的OnePower对象提供的Reset函数，执行PSU的复位操作。在Reset函数执行完成后，适配器获取函数执行的结果，并将回显信息输出在屏幕上。
### 3.1.2 功能详细设计
本功能在target.json文件下新增映射器配置，Uri为`/cli/v1/_/psuswitch`。该映射器允许用户的输入形如`ipmcset -d psuswitch -v psu<N> <value>`，其中`psu<N>`为待操作的PSU编号，取值范围为1~30（此处的取值范围为映射器限制的取值范围，后续有进一步的校验流程）。`<value>`为用户希望执行的操作，当前仅支持改参数传入的值为2，含义为强制复位。

获取用户的输入信息后，映射器首先将用户转换为后续需要使用的格式。对于输入`psu<N>`，需要首先去除前缀`psu`，之后将字符类型的PSU编号转换为数字类型。对于输入`<value>`，需要根据实际的输入值返回对应的字符串。对于当前场景，当`<value>`输入为2时，转换为字符串`ForceRestart`，其他输入均转换为字符串`Unknown`，以便后续流程抛出异常。因此映射器的Statments字段需要新增两个对象：`GetSlotNumber`和`GetResetType`，完成以上转换工作。

完成用户的入参转换后，映射器需要根据入参传入的PSU编号获取资源树上对应的`bmc.kepler.Systems.PowerMgmt.OnePower`接口，从而调用该接口的`Reset`函数。由于该接口所在路径在资源树上的命名不包含PSU编号，因此不能通过直接使用上一步获取到的PSU编号拼接路径的方式访问该路径，而是需要使用查询的方式进行访问。映射器的ProcessingFlow字段首先需要实现一个接口调用流程：该流程访问资源树`/bmc/kepler/MdbService`路径下的`bmc.kepler.Mdb`接口，调用`GetPath`函数，查询并返回含有与输入数值一致的SlotNumber属性的路径。通过该查询流程，映射器可以正确获取与传入PSU编号相对应的接口，保证实际操作的PSU与入参一致。此外，若用户输入的PSU编号超出实际PSU的数量，则此处查询返回空值，映射器能够感知该异常情况并报错呈现。

获取到与输入PSU编号对应的路径后，即可执行其复位函数。映射器在Statments字段下新增一个对象`SetPsuSwitch`，该字段接受上一步中获取的路径和输入的PSU编号作为入参，调用plugins目录下新增的脚本psuswitch.lua。该脚本访问路径下`bmc.kepler.Systems.PowerMgmt.OnePower`接口的`Reset`函数，从而对PSU执行复位操作。执行完毕后，脚本判断执行结果并将返回值传出给映射器，由新增的echoes/ipmcset/_psuswitch文件解析执行结果并呈现给用户。
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
不涉及
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
不涉及
#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及
## 3.2 基于PMBus协议复位PSU
### 3.2.1 功能实现设计
本功能在power_mgmt组件下新增基于PMBus协议的复位接口，用以实际执行复位动作。当前power_mgmt组件已经在资源树上呈现了对外的`Reset`函数，当power_mgmt组件初始化时，会根据当前单板实际的电源协议（PMBus或其他协议等），为`Reset`函数挂接对应的内部实现。本功能需要新增基于PMBus协议的内部实现，当上层传入的参数为`ForceRestart`时，通过PMBus向PSU发送命令，从而实际执行复位动作。
### 3.2.2 功能详细设计
本功能在protocol目录下的pmbus.lua文件中新增`reset`函数，组件已经确保当执行上层`Reset`函数时，能自动执行到该新增函数。根据PMBus协议手册，当需要复位PSU时，应当向PSU发送命令字`0x01`，且写入一字节数据`0x00`。组件底层已经实现了`chip_bytewrite`接口，用于向PSU发送命令字和字节数据。因此新增的`reset`接口只需调用`chip_bytewrite`写入必要数据即可。
### 3.2.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
不涉及
#### 3.2.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
不涉及
#### 3.2.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
不涉及