*openUBMC 支持电源模块接触不良告警及输出欠压告警优化功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>hardware_sig</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>付明权</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025.11.7</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
    <tr>
        <td>xxx</td>
        <td>xxx</td>
        <td>xxx</td>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景
<!-- 描述该需求的来源或背景，比如：支撑XXX功能、XXX优化等；以及该需求对用户（含组件）带来什么具体价值，如果没有该需求，对用户（含组件）带来什么损失； -->
BMC需要对电源模式接触不良告警（0x0300004d）及输出欠压告警（0x03000017）逻辑进行排查优化，补充相关异常场景检查，对特殊的的场景进行告警屏蔽，避免误告警

## 1.2 功能描述
<!-- 描述该需求交付的整体功能，主要实现XXX功能，解决XXX问题，明确方案如何实现 -->
排查电源模式接触不良告警（0x0300004d）及输出欠压告警（0x03000017）的告警逻辑，补齐告警遗漏场景，并对无需告警的特殊场景进行告警屏蔽

## 1.3 功能场景
<!-- 描述该需求的业务使用场景，内容包括：
1) 场景出发条件及对象：什么角色/工具/接口等在什么具体情况下使用该特性，使用对象技能如何？
2) 使用时间及频度
3) 描述该特性主要有哪些场景、子场景及关键任务操作 -->
1、电源接触不良及输出欠压的场景，正常产生告警，且告警信息正常
2、无需产生告警的特殊场景下，无告警产生

## 1.4 功能列表
<!-- 描述该需求交付的功能列表，内容包括：列出功能详细描述，标题、描述。 -->
| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | BMC支持PSU输出欠压告警增加OPOK信号异常检测 | BMC支持在PSU输出欠压时，进行告警检查与上报 |
| 2 | 支持PSU电源模块接触不良告警 | BMC支持在PSU电源模块接触不良时，进行告警检查与上报 |


# 2.功能设计
## 2.1 总体方案分析
<!-- 描述该方案的总体设计（注：相关输出方案可同步刷新到各组件仓） -->

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述
<!-- 描述该方案的整体实现，内容包括：涉及的关键点，实现策略等 -->

**电源输出欠压告警：**
检查逻辑：
检查逻辑：
1、BMC实时读取检测每个PSU的0x7A命令，若bit4值持续6s为1，则认为输出欠压；
2、电源IPOK正常时，若整机硬件检测到OPOK为低且PSU的0x80寄存器bit4为0，持续30s，则认为输出欠压

屏蔽场景（仅针对检查逻辑2）：
1、在线升级场景：在线升级过程中，不进行输出欠压检测；
2、深度休眠模式：深度休眠模式电源无输出，深度休眠模式下屏蔽相关告警
3、电源主动关机场景：电源厂商自定义状态（0x80）的bit3为1
4、电源在位信息异常场景：电源厂商自定义状态（0x80）的bit6为0
5、电源异常场景：电源上报的故障状态存在不为0时，不进行告警检测，包括电流输出状态（0x7B）、电压输入状态（0x7C）、过温故障状态（0x7D）、风扇故障状态（0x81），电压输出故障状态（0x7A）

**电源模块接触不良告警：**
检查逻辑：
1、PSON（PSU输入信号）：电源PSON在MV12模式时，BMC实时读取每个电源的寄存器0x80的bit7值。若带内上电模式下，某个电源模块0x80的bit7值为0，则上报PSU的PSON信号异常；
2、OPOK（PSU输出信号）：实际检测每个PSU的0x80命令，若bit4为1并且整机硬件检测到OPOK为低，持续25s，则认为OPOK虚插；
3、INSTALLED（PSU输入信号）：MV12模式下，检测每个PSU的0x80命令，若某个电源0x80的bit6值连续25s为0，则认为INSTALLED虚插；
屏蔽场景：
1、深度休眠模式：深度休眠模式0x80上报值默认为0x00，因此深度休眠模式下屏蔽相关告警
2、启机前5s：首次上电前5s以及退出深度休眠前5s，0x80上报默认值为0x00，因此对0x80读取值做25s滤波，避免首次上电前5s误告警；
3、在线升级场景：在线升级过程中，不进行虚插检测；
4、升级失败场景：DCDC升级失败后读取0x80失败，不进行虚插检测。PFC升级失败后，DCDC正常检测IO信号，不涉及虚插误告警
5、通信失败场景：不进行虚插检测；

#### 2.1.1.2 开发视图
<!-- 开发视图面向系统开发及软件管理，描述系统代码结构，构建结构的视图，主要解决系统技术实现和开发的问题，它依托逻辑视图，描述代码、构建结构 -->
```mermaid
flowchart LR
    subgraph Layer1[上层-告警管理层]
        Event[event组件<br/>配置告警对象<br/>接收并上报告警]
    end

    subgraph Layer2[单电源CSR容器]
        CSR[单电源CSR<br/>承载OnePower和告警对象]
        OnePower[OnePower对象<br/>组件轮询寄存器后刷新属性]
        Alarm[告警对象<br/>表达式消费OnePower属性并判定告警]
    end

    subgraph Layer3[硬件信号层]
        Scanner[Scanner对象<br/>从CPLD获取IPOK/OPOK/PSON等信号]
        CPLD[CPLD]
    end

    Event -.配置表达式.-> Alarm
    Alarm -.触发告警.-> Event
    Scanner -->|采集信号| CPLD
    Scanner -->|同步到| OnePower
    OnePower -->|属性同步| Alarm
    CSR --- OnePower
    CSR --- Alarm

    style Event fill:#e1f0ff
    style Alarm fill:#ffebcc
    style Scanner fill:#e8f5e9
    style CPLD fill:#e8f5e9
    style OnePower fill:#f2f9ff
    style CSR fill:#f9f9f9
    style Layer1 fill:#f0f0f0
    style Layer2 fill:#fafafa
    style Layer3 fill:#f0f8f0
```

#### 2.1.1.3 运行视图
<!-- 运行视图面向系统运行，描述系统启动过程、运行期交互的视图，主要解决系统运行期交互，描述各可执行交付件在运行期的交互关系 -->

```mermaid
sequenceDiagram
    participant Event as event组件
    box 单电源CSR
        participant Alarm as 告警对象
        participant OnePower as OnePower对象
        participant Scanner as Scanner对象
    end
    participant CPLD as CPLD

    Note over Event,Alarm: 初始化阶段
    Event->>Alarm: 配置告警表达式并订阅OnePower属性

    Note over Scanner,OnePower: 组件侧轮询阶段
    loop 轮询周期
        Scanner->>CPLD: 读取IPOK/OPOK/PSON等信号
        Scanner->>OnePower: 同步硬件状态
        OnePower->>OnePower: 轮询寄存器并计算内部状态
        OnePower->>Alarm: 刷新输出电压状态等属性
    end

    loop CSR表达式计算
        Alarm->>Alarm: 根据同步属性求值
        alt 条件满足
            Alarm->>Event: 触发告警事件
        else
            Note over Alarm: 保持清除
        end
        Event->>Event: 汇总并上报告警
    end
```


### 2.1.2 内部依赖分析
<!-- 是否涉及与其他组件接口依赖，如果涉及需要确认当前是否已完成，是否匹配当前需求开发诉求 -->
不涉及

### 2.1.3 外部依赖分析
<!-- 是否涉及与平台SDK的依赖关系 -->
不涉及

### 2.1.4 北向接口分析
<!-- 需要分析当前功能是否有以下接口影响，如果有影响，则需要具体的补充影响点。其中注意点如下：
（1）如果有新增IPMI接口，请排查代码中IPMI命令注册的过滤字段，是否完全和IPMI命令的定义一致？
（2）新增一个接口时，需要咨询SIG组是否还有其他的接口受影响 -->
| 特性 | SNMP | CLI | WEB | KVM_VMM | IPMI(RMCP/RMCP+) | HMM | Redfish |
| ---- | ---- | ---- | --- | ------ | ---------------- | --- | ------- |
| 支持电源模块接触不良告警及输出欠压告警优化 | NA | NA | NA | NA | NA | NA | NA |

### 2.1.5 兼容性分析
<!-- 当前的功能对现有在网的功能是否有影响，具体的影响点进行分析之后输出影响分析表格 -->
不涉及

### 2.1.6 定制化接口分析
<!-- 如果支持定制化设置，则需要给出定制化时的默认值（空定制化项条件下的设置值），如果涉及到定制化接口变更或新增，注意定制化接口文档需配套修改。注意定制化默认值变更对白牌包的影响 -->
不涉及

### 2.1.7 导入导出分析
<!-- 如果支持导入导出的配置，则需要分析导入导出的schema。 -->
不涉及

### 2.1.8 传感器分析
<!-- 如果需要新增传感器，则需要提前登记和评审新增的传感器要素。新增传感器评审需要上SIG-Interface进行评审 -->
不涉及

### 2.1.9 精准告警事件分析
<!-- 如果需要新增事件，则需要提前登记和评审新增的时间要素 -->
已有告警事件，0x03000017告警（电源输出欠压告警），0x0300004d告警（电源接触不良告警）

### 2.1.10 系统锁定分析
<!-- 对外的接口或者命令是否支持系统锁定 -->
不涉及

### 2.1.11 用例场景分析
<!-- 以表格的形式输出该需求涉及的用例场景 -->
电源输出电压欠压告警：
|用例编号|	场景|	预期|
|---|---|---|
|1|	升级电源，查看告警信息	|不产生电源输出欠压告警
|2|	设置电源深度休眠，查看告警信息|	不产生电源输出欠压告警
|3| 构造输出过压故障，查看告警信息	| 不产生电源输出欠压告警
|4| 构造输出欠压故障，查看告警信息	| 产生电源输出欠压告警
|5| 构造过温故障，查看告警信息	| 不产生电源输出欠压告警
|6| 构造输入过压故障，查看告警信息	| 不产生电源输出欠压告警
|7| 构造风扇故障，查看告警信息	| 不产生电源输出欠压告警
|8| 构造缓起继电器吸合异常，查看告警信息	| 产生电源输出欠压告警
|9| 构造母线过压故障，查看告警信息	| 产生电源输出欠压告警
|10| 构造母线欠压故障，查看告警信息	| 产生电源输出欠压告警

电源接触不良告警：
|用例编号|	场景|	预期|
|---|---|---|
|1|	设置电源深度休眠，查看告警信息	| 不产生电源模块接触不良告警
|2|	电源退出深度休眠，查看告警信息	| 不产生电源模块接触不良告警
|3|	BMC启动，查看告警信息	|不产生电源模块接触不良告警
|4|	升级电源，查看告警信息	|不产生电源模块接触不良告警
|5|	上电场景，模拟电源0x80的bit7为0，查看告警信息	|产生电源模块接触不良告警
|6|	上电场景，模拟电源0x80的bit6为0，查看告警信息	|产生电源模块接触不良告警
|7| 模拟电源opok为低，查看告警信息	|产生电源模块接触不良告警
|8|	构造电源通讯异常，查看告警信息	|不产生电源模块接触不良告警
|9|	构造电源PSON接触不良，查看告警信息	|产生电源模块接触不良告警
|10|	构造电源INSTALLED接触不良，查看告警信息	|产生电源模块接触不良告警
|11|	构造电源OPOK接触不良，查看告警信息	|产生电源模块接触不良告警

## 2.2 非功能质量属性设计
### 2.2.1 扩展性分析
<!-- 考虑后续新增类似功能可以很好地扩展 -->
不涉及

### 2.2.2 重用性分析
<!-- 是否为通用处理方式、接口，如果是得考虑重用性 -->
不涉及

### 2.2.3 可测试性分析
<!-- 此需求如何验证，是否可直接验证，or通过XXX功能覆盖验证，or需要单独怎加测试接口验证 -->
可通过电源打桩包和实际构造环境验证

### 2.2.4 资料分析
<!-- 是否涉及资料修改 -->
不涉及

### 2.2.5 资源使用分析
<!-- 新增线程、内存分配、模型属性名长度是否合理，CPU占用率是否会激增，Flash中新增文件是否合理（频繁读写Flash会大幅缩短emmc寿命）；是否涉及消息队列，如果涉及请检查是否存在某些场景下消息队列会满导致消息丢失，例如大量消息发送到队列且处理消息需要耗费较长时间的场景。 -->
不涉及

### 2.2.6 可靠性分析
电源输出欠压告警：
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | BMC场景 |电源深度休眠场景，电源无输出|产生电源输出欠压告警|一般|电源固件升级场景不进行电源升级检测||||
| 2 | 电源升级场景 |电源进行固件升级时，电源会无输出|产生电源输出欠压告警|一般|电源固件升级场景不进行电源升级检测||||


电源接触不良告警：
| 编号 | 场景 | 问题描述 | 可靠性影响 | 问题级别 | 建议解决方案/需求 | 讨论结果 | 跟踪人 | 备注 |
| --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1 | BMC场景 |电源退出深度休眠后5s，0x80上报默认值0|产生电源接触不良误告警|一般|返回默认无效值，不进行告警检查||||
| 2 | 电源启机场景 |电源首次上电后5s，0x80上报默认值0|产生电源接触不良误告警|一般|返回默认无效值，不进行告警检查||||
| 3 | 数据获取异常状态 |获取电源状态信息失败|无法进行告警判断|一般|返回默认无效值，不进行告警检查||||
### 2.2.7 安全性分析
| 安全合规项 | 是否涉及 | 现有的防护措施 |
| --- | --- | --- |
| 访问控制（通道、文件权限、用户权限、查询权限、配置权限、接口权限） | 不涉及 |  |
| 敏感数据 | 不涉及 |  |
| 日志（操作日志、维护日志、安全日志、运行日志） | 不涉及 |  |
| 文档 | 不涉及 |  |
| 加密及算法 | 不涉及 |  |
| 新增关键资源（密钥、证书、关键配置）备份、恢复 | 不涉及 |  |
| 新增对外接口入参校验 | 不涉及 |  |
| 新增开源及三方软件引入 | 不涉及 |  |
# 3.功能实现
<!-- 通过表格、流程图、简明文字描述提供，力求容易看懂、容易实现，详细描述细节。 -->
## 3.1【功能编号】BMC支持PSU输出欠压告警增加OPOK信号异常检测
### 3.1.1 功能实现设计
告警采用软件检查+CSR配置方式实现，组件业务侧通过CSR同步方式获取电源的IPOK和OPOK状态，由软件进行输出欠压告警的检查，将检查结果维护到电源输出电压状态的bit4上。在CSR中配置的告警对象同步组件侧维护的输出电压欠压检查结果进行告警产生和消除。

数据源：
|数据名称|数据源|
|---|---|
|电源IPOK|power_mgmt组件的电源属性InputState，从Scanner对象同步|
|电源OPOK|power_mgmt组件的电源属性OutputState，从Scanner对象同步|
|电流输出电压状态（0x7A）|power_mgmt组件维护的电源属性OutputVoltageFault|
|电源输出电流状态（0x7B）|power_mgmt组件维护的电源属性OutputCurrentFault|
|电源输入电压状态（0x7C）|power_mgmt组件维护的电源属性InputVoltageFault|
|电源过温状态（0x7D）|power_mgmt组件维护的电源属性OverTemperature|
|电源风扇故障状态（0x81）|power_mgmt组件维护的电源属性FanFault|
|电源厂商自定义状态（0x80）|power_mgmt组件维护的电源属性MfrSpecificStatus|
|电源是否正在升级|power_mgmt组件维护的电源属性IsUpgrading|
|电源是否深度休眠|power_mgmt组件维护的电源属性DeepSleepEnabled|

检查逻辑：<br>
1、BMC实时读取检测每个PSU的0x7A命令，若bit4值持续6s为1，则认为输出欠压<br>
2、电源IPOK正常时，若整机硬件检测到OPOK为低且PSU的0x80寄存器bit4为0，持续30s，则认为输出欠压<br>

屏蔽场景（仅针对检查逻辑2）：<br>
1、在线升级场景：在线升级过程中，不进行输出欠压检测<br>
2、深度休眠模式：深度休眠模式电源无输出，深度休眠模式下屏蔽相关告警<br>
3、电源主动关机场景：电源厂商自定义状态（0x80）的bit3为1<br>
4、电源在位信息异常场景：电源厂商自定义状态（0x80）的bit6为0<br>
5、电源异常场景：电源上报的故障状态存在不为0时，不进行告警检测，包括电流输出状态（0x7B）、电压输入状态（0x7C）、过温故障状态（0x7D）、风扇故障状态（0x81），电压输出故障状态（0x7A）

### 3.1.2 功能详细设计
检测流程：<br>
1、检查电源电压输出状态，若bit4值持续6s为1，则产生告警，不进行后续检查<br>
2、获取电源升级状态，若电源正常升级，不进行后续检查<br>
3、获取电源深度休眠状态，若处于深度休眠，不进行后续检查<br>
4、获取电源电源厂商自定义状态，若bit3为1或者bit6为0，不进行后续检查<br>
5、获取电源其他故障状态，若处于屏蔽场景，不进行后续检查<br>
6、若电源IPOK正常且OPOK信号持续为低30s，并且PSU的0x80寄存器bit4为0，则产生告警，否则保持清除状态<br>
流程图：
```mermaid
flowchart TD
    Init([event组件配置]) --> Config[event组件在CSR中配置<br/>电源输出欠压告警对象]
    Config --> SetRef[告警对象配置读值属性<br/>同步OnePower.OutputVoltageFault整属性]
    SetRef --> SetExpr[配置检测表达式<br/>判定OutputVoltageFault bit4是否为1]
    SetExpr --> Ready([等待OnePower输出电压状态变化])
    
    Ready --> PropChange{OutputVoltageFault<br/>属性变化事件}
    PropChange --> Update[告警对象读值属性同步更新<br/>获取整个位图数据]
    Update --> Calc[表达式自动计算]
    
    Calc --> CheckBit4{OutputVoltageFault bit4为1?}
    CheckBit4 -->|是| Trigger[触发输出欠压告警事件]
    CheckBit4 -->|否| Clear([保持告警清除])
    
    Trigger --> Report[event组件上报<br/>输出欠压告警 0x03000017]
    Report --> Ready
    Clear --> Ready
    
    Update -.组件侧轮询检测.-> NoteComp[组件侧OnePower对象通过定时轮询寄存器执行检测：<br/>1. 每次轮询时先判断0x7A bit4连续6s为1，记为检查逻辑1，若成立保持OutputVoltageFault bit4为1，不再改写<br/>2. 若逻辑1不成立，再执行检查逻辑2，要求IPOK正常、OPOK低30s且0x80 bit4为0，全部满足后才将bit4置1<br/>3. 若逻辑2也不满足，则按当前状态保持不变<br/>4. 两条逻辑前均判断屏蔽条件：升级中、深度休眠、0x80 bit3为1、0x80 bit6为0、其他故障<br/>5. 轮询结果写回OutputVoltageFault属性，由CSR告警对象表达式判定bit4产消告警]
    
    style Init fill:#d4edda
    style Config fill:#d4edda
    style SetRef fill:#d4edda
    style SetExpr fill:#d4edda
    style Ready fill:#e1f5e1
    style PropChange fill:#fff4cc
    style Update fill:#e8f4f8
    style Calc fill:#e8f4f8
    style CheckBit4 fill:#ffe5cc
    style Trigger fill:#ffd6cc
    style Report fill:#ffcccc
    style Clear fill:#f0f0f0
    style NoteComp fill:#fffacd
```
时序图：
```mermaid
sequenceDiagram
    participant Event as event组件
    box 单电源CSR
        participant Alarm as 电源输出欠压告警对象
        participant Scanner as Scanner对象
        participant OnePower as OnePower对象
    end
    
    Note over Alarm,OnePower: 告警对象、Scanner对象、OnePower对象<br/>均在同一CSR中配置
    
    Note over Event,Alarm: 初始化阶段
    Event->>Alarm: 配置输出欠压检测表达式
    Note right of Event: 同步OnePower.OutputVoltageFault整属性<br/>表达式判定其中bit4是否为1
    Alarm->>OnePower: 建立整属性同步关系
    
    Note over Scanner,OnePower: 组件侧检测流程
    
    loop 组件侧轮询周期
        Scanner->>OnePower: 同步最新IPOK OPOK等状态
        OnePower->>OnePower: 定时轮询0x7A 0x80寄存器并执行检查逻辑1，条件为0x7A bit4连续6s等于1<br/>屏蔽条件不过则跳出
        alt 检查逻辑1满足
            Note over OnePower: OutputVoltageFault bit4已为1<br/>无需改写，保持现值
        else 逻辑1不满足
            OnePower->>OnePower: 继续执行检查逻辑2，条件为IPOK正常且OPOK低30s且0x80 bit4等于0
            alt 检查逻辑2满足
                Note over OnePower: 将OutputVoltageFault bit4置1
            else 检查逻辑2不满足
                Note over OnePower: 保持属性原样，不修改bit4
            end
        end
        OnePower->>Alarm: 将轮询结果写回OutputVoltageFault整属性
    end
    
    loop 告警对象检测
        Alarm->>Alarm: 表达式自动计算(读取bit4)
        alt bit4为1
            Alarm->>Event: 触发输出欠压告警事件
            Event->>Event: 上报告警(0x03000017)
        else bit4为0
            Note over Alarm: 保持告警清除，等待下一次属性变化
        end
    end
```
### 3.1.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
DT设计参考：
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| firmware_mgmt | IT | 测试BMC固件更新生效状态 | test_update_bmc_active_status | 状态机为parallel_upgrading | 1.更新固件生效资源<br/>2.访问bmc.kepler.firmware_mgmt下/bmc/kepler/UpdateService/FirmwareActive/BMC接口<br/>3.查看/bmc/kepler/UpdateService/FirmwareActive中生效对象生效信息<br/>4.查看/bmc/kepler/UpdateService/FirmwareActive/BMC下bmc.kepler.UpdateService.FirmwareActiveInfo中生效信息 | 1.更新成功<br/>2.访问成功<br/>3.查询到bmc生效资源<br/>4.bmc生效信息：'FirmwareId'='BMC', 'FirmwareType'='BMC', 'ActiveStatus'='Ready' |
#### 3.1.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| power_mgmt | UT | 深度休眠退出应清除Mfr状态并置255 | test_set_resource_exit_deep_sleep | DeepSleepEnabled=1 | 将 DeepSleepEnabled 设置为0，触发 `set_resource` | `clear_debounced_val` 被调用，`MfrSpecificStatus` 置255 |
| power_mgmt | UT | 非深度休眠切换不应触发清零 | test_set_resource_no_transition | DeepSleepEnabled=0 | 再次写入0，调用 `set_resource` | 不触发防抖清零，属性保持原值 |
| power_mgmt | UT | 扩展条件满足时拉高OutputVoltageFault bit4并同步其他故障位 | test_check_input_output_fault_updates_voltage | `health_event` 全部正常且扩展条件返回1 | 调用 `check_input_output_fault`，模拟OPOK异常 | `OutputVoltageFault` 由0置16，电流/输入电压故障被同步 |
| power_mgmt | UT | 无电压信息时保持原故障位 | test_check_input_output_fault_without_voltage_info | 仅有 `output_current_fault` 输入 | 执行 `check_input_output_fault` | 仅更新 `OutputCurrentFault`，`OutputVoltageFault` 保持8 |
| power_mgmt | UT | 扩展条件全部满足返回1 | test_check_output_voltage_fault_extend_condition_true | 无屏蔽条件 | 调用 `check_output_voltage_fault_extend_condition` | 返回1，为逻辑2提供置位依据 |
| power_mgmt | UT | 扩展条件任一屏蔽项命中即返回0（输入状态/升级/深度休眠/输出状态/0x80 bitmask/各类故障） | test_extend_condition_input_state 等10例 | 分别构造单一屏蔽条件 | 调用对应 `check_output_voltage_fault_extend_condition` | 均返回0，验证屏蔽链路有效 |

#### 3.1.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
无

## 3.2【功能编号】支持PSU电源模块接触不良告警
### 3.2.1 功能实现设计
告警采用CSR配置方式，在CSR的告警对象使用组件提供数据源以及Scanner对象配置告警表达式，实现告警的产生和清除
<br>
数据源：
|数据名称|数据源|
|---|---|
|PSON信号|电源CSR的Scanner对象|
|电源OPOK|电源CSR的Scanner对象|
|电源厂商自定义状态（0x80）|power_mgmt组件维护的电源属性MfrSpecificStatus|
|电源是否正在升级|power_mgmt组件维护的电源属性IsUpgrading|
|电源是否深度休眠|power_mgmt组件维护的电源属性DeepSleepEnabled|

检查逻辑：<br>
1、PSON（PSU输入信号）：电源PSON在MV12模式（上电）时，BMC实时读取每个电源的寄存器0x80的bit7值。若带内上电模式下，某个电源模块0x80的bit7值为0，则上报PSU的PSON信号异常<br>
2、OPOK（PSU输出信号）：实际检测每个PSU的0x80命令，若bit4为1并且整机硬件检测到OPOK为低，持续25s，则认为OPOK虚插<br>
3、INSTALLED（PSU输入信号）：MV12模式下，检测每个PSU的0x80命令，若某个电源0x80的bit6值连续25s为0，则认为INSTALLED虚插<br>
屏蔽场景：<br>
1、深度休眠模式：深度休眠模式0x80上报值默认为0x00，因此深度休眠模式下屏蔽相关告警<br>
2、启机前5s：首次上电前5s以及退出深度休眠前5s，0x80上报默认值为0x00，因此对0x80读取值做25s滤波，避免首次上电前5s误告警<br>
3、在线升级场景：在线升级过程中，不进行虚插检测<br>
4、升级失败场景：DCDC升级失败后读取0x80失败，不进行虚插检测。PFC升级失败后，DCDC正常检测IO信号，不涉及虚插误告警<br>
5、通信失败场景：不进行虚插检测<br>
### 3.2.2 功能详细设计
检查流程：
1、获取电源深度休眠状态，若深度休眠开启，则不进行告警检查<br>
2、获取电源升级状态，若当前正在升级，则不进行告警检查<br>
3、获取电源厂商自定义状态，若获取失败，则不进行告警检查（默认为无效值255，退出深度休眠后25s内采用255，防止误告警）<br>
4、若当前bit4为1且opok为低，或者上电状态下且bit7为0或bit6为0，则产生告警<br>
流程图：

```mermaid
flowchart TD
    Init([event组件配置]) --> Config[event组件在单电源CSR中配置<br/>电源模块接触不良告警对象]
    Config --> SetRef[告警对象配置读值属性同步<br/>OnePower MfrSpecificStatus 0x80<br/>Scanner OPOK<br/>Scanner PSON<br/>OnePower IsUpgrading 与 DeepSleepEnabled]
    SetRef --> Ready([等待属性变化通知])

    Ready --> PropChange{属性变化事件}
    PropChange -->|0x80变化| Path80[OnePower通知告警对象]
    PropChange -->|OPOK变化| PathOpok[Scanner通知告警对象]
    PropChange -->|PSON变化| PathPson[Scanner通知告警对象]

    Path80 --> Update80[告警对象读值属性同步更新]
    PathOpok --> UpdateOpok[告警对象读值属性同步更新]
    PathPson --> UpdatePson[告警对象读值属性同步更新]

    Update80 --> Calc[表达式自动计算]
    UpdateOpok --> Calc
    UpdatePson --> Calc

    Calc --> CheckSleep{DeepSleepEnabled?<br/>深度休眠模式}
    CheckSleep -->|是| NoAlarm([不触发告警])
    CheckSleep -->|否| CheckUpgrade{IsUpgrading?<br/>是否正在升级}
    CheckUpgrade -->|是| NoAlarm
    CheckUpgrade -->|否| Check80Valid{0x80是否有效?<br/>255视为无效}

    Check80Valid -->|否| NoAlarm
    Check80Valid -.无效值说明.-> Note255[0x80 无效值 255 场景：<br/>1. 读取失败或通信异常<br/>2. 退出深度休眠后25秒内暂置255<br/>3. 升级失败导致0x80不可用]
    Check80Valid -->|是| Branch{告警条件判断}

    Branch --> CondOpok{0x80 bit4为1 且 OPOK为低 持续25s?}
    CondOpok -->|是| Trigger[触发接触不良告警事件]

    Branch --> CondPson{上电模式为MV12 且 0x80 bit7为0?}
    CondPson -->|是| Trigger

    Branch --> CondInstalled{上电模式为MV12 且 0x80 bit6持续25s为0?}
    CondInstalled -->|是| Trigger

    CondOpok -->|否| NoAlarm
    CondPson -->|否| NoAlarm
    CondInstalled -->|否| NoAlarm

    Trigger --> Report[event组件上报<br/>接触不良告警<br/>0x0300004d]
    Report --> Ready
    NoAlarm --> Ready

    style Init fill:#d4edda
    style Config fill:#d4edda
    style SetRef fill:#d4edda
    style Ready fill:#e1f5e1
    style PropChange fill:#fff4cc
    style CheckSleep fill:#cce5ff
    style CheckUpgrade fill:#cce5ff
    style Check80Valid fill:#cce5ff
    style Branch fill:#fff4cc
    style CondOpok fill:#ffe5cc
    style CondPson fill:#ffe5cc
    style CondInstalled fill:#ffe5cc
    style Trigger fill:#ffd6cc
    style Report fill:#ffcccc
    style NoAlarm fill:#f0f0f0
```

时序图：

```mermaid
sequenceDiagram
    participant Event as event组件
    box 单电源CSR
        participant Alarm as 电源模块接触不良告警对象
        participant Scanner as Scanner对象
        participant OnePower as OnePower对象
    end

    Note over Alarm: 告警对象读值属性同步：<br/>OnePower MfrSpecificStatus 0x80,<br/>Scanner OPOK, Scanner PSON,<br/>IsUpgrading, DeepSleepEnabled

    Note over Event,Alarm: 初始化阶段
    Event->>Alarm: 配置接触不良检测表达式

    Note over Event,Alarm: 运行阶段-属性变化驱动

    alt 场景1: 0x80状态变化
        OnePower->>Alarm: 通知0x80变化
        Alarm->>Alarm: 表达式自动计算
        Note right of Alarm: 检查屏蔽条件：<br/>深度休眠 升级 0x80有效性<br/>若0x80为255 表示无效值 场景含读取失败 通信异常<br/>退出深度休眠25秒内 暂置255 以及升级失败
        alt 满足OPOK虚插(0x80.bit4==1 且 OPOK==低 持续25s)
            Alarm->>Event: 触发接触不良告警(0x0300004d)
        else 满足INSTALLED虚插(MV12 且 0x80.bit6 持续25s为0)
            Alarm->>Event: 触发接触不良告警(0x0300004d)
        else 满足PSON异常(MV12 且 0x80.bit7==0)
            Alarm->>Event: 触发接触不良告警(0x0300004d)
        else
            Note over Alarm: 不满足，继续等待
        end
    end

    alt 场景2: OPOK变化
        Scanner->>Alarm: 通知OPOK变化
        Alarm->>Alarm: 表达式自动计算
        Note right of Alarm: 校验(0x80.bit4==1 且 OPOK==低 持续25s)
        alt 条件满足
            Alarm->>Event: 触发接触不良告警(0x0300004d)
        else
            Note over Alarm: 条件未满足
        end
    end

    alt 场景3: PSON变化
        Scanner->>Alarm: 通知PSON变化
        Alarm->>Alarm: 表达式自动计算
        Note right of Alarm: 校验MV12相关条件<br/>若0x80为255 则跳过告警判断
        alt 满足PSON异常或INSTALLED虚插
            Alarm->>Event: 触发接触不良告警(0x0300004d)
        else
            Note over Alarm: 条件未满足
        end
    end
```
### 3.2.3 开发者测试
<!--
增加模块接口：以活动图/流程图等形式明确模块内处理流程，针对模块处理流程中的分支进行覆盖
修改模块接口处理流程：覆盖修改影响流程分支
-->
DT设计参考：
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| firmware_mgmt | IT | 测试BMC固件更新生效状态 | test_update_bmc_active_status | 状态机为parallel_upgrading | 1.更新固件生效资源<br/>2.访问bmc.kepler.firmware_mgmt下/bmc/kepler/UpdateService/FirmwareActive/BMC接口<br/>3.查看/bmc/kepler/UpdateService/FirmwareActive中生效对象生效信息<br/>4.查看/bmc/kepler/UpdateService/FirmwareActive/BMC下bmc.kepler.UpdateService.FirmwareActiveInfo中生效信息 | 1.更新成功<br/>2.访问成功<br/>3.查询到bmc生效资源<br/>4.bmc生效信息：'FirmwareId'='BMC', 'FirmwareType'='BMC', 'ActiveStatus'='Ready' |
#### 3.2.3.1 单元测试
<!-- UT，主要是功能单元测试，测试对象是功能单元接口。UT测试设计要从黑盒（功能）角度设计，从输入(I)、处理（B）、预期输出（O）的角度进行用例分析设计，测试覆盖率仅作为反馈，用于分析哪些功能场景没有覆盖到，从而指导测试设计优化并补充测试用例 -->
| 组件名 | 用例类型 | 测试用例描述 | 用例名称 | 预置条件 | 操作步骤 | 预期结果 |
| --- | --- | --- | --- | --- | --- | --- |
| power_mgmt | UT | 获取0x80成功时应按实际值同步到CSR | test_update_mfr_specific_status_success | 无 | 打桩 `get_specific` 返回 0x5a，调用 `update_mfr_specific_status` | `health_event.mfr_specific_status` 更新为 0x5a，可用于告警表达式 |
| power_mgmt | UT | 获取0x80失败时应返回无效值255屏蔽告警 | test_update_mfr_specific_status_failed | 无 | 打桩 `get_specific` 抛异常，调用 `update_mfr_specific_status` | `health_event.mfr_specific_status` 被置为255，告警检测自动跳过 |
| power_mgmt | UT | 退出深度休眠后应自动写255屏蔽虚插告警 | test_set_resource_exit_deep_sleep | DeepSleepEnabled=1，位于 `test_onepower.lua` | 调用 `set_resource` 将 DeepSleepEnabled 置0 | 调用 `clear_debounced_val`，`MfrSpecificStatus` 置255 |
| power_mgmt | UT | 非深度休眠切换不应误清Mfr状态 | test_set_resource_no_transition | DeepSleepEnabled=0 | 重复写0调用 `set_resource` | `MfrSpecificStatus` 保持123，未触发防抖 |
| power_mgmt | UT | 其他属性写入不影响0x80同步 | test_set_resource_other_property | DeepSleepEnabled=1 | 调用 `set_resource` 写入无关属性 | 仅更新对应属性，`MfrSpecificStatus` 不变，避免误触发接触不良告警 |

#### 3.2.3.2 集成测试
<!-- IT，主要是组件/模块内的集成测试，测试对象是模块/组件接口。IT测试设计将模块/组件当作黑盒测试，IT测试用例中禁止对组件/模块内部代码打桩，如果确实有少量场景难以构造，可以考虑在测试框架中统一打桩并提供接口供测试用例调用构造场景。
说明：API测试属于IT，其测试对象是微服务接口。
PCST，是指PC上的服务集成测试，测试对象是功能需求。PCST测试设计，要覆盖正常功能、异常功能和交叉功能，采用灰盒 -->
无