local lu = require 'luaunit'
local pcie_device_app = require 'pcie_device_app'
local bs = require 'mc.bitstring'

TestPCIeDeviceApp = {}

function TestPCIeDeviceApp:test_receiver_report_bdf_ipmi()
    local rsp_body = {
        new = function() end,
    }

    local device_type = "PCIeCard"

    local req = {
        Length = 7,
        Data = string.char(0x02, 0x00, 0x00, 0x00, 0x1c, 0x00,
            0x00, 0x02, 0x00, 0x00, 0x01, 0x40, 0x00, 0x00)
    }

    local ctx = { HostId = 1 }

    local device_service = {}
    function device_service:on_set_pcie_bdf(host_id, device_type, card_infos)
        self.host_id = host_id
        self.device_type = device_type
        self.card_infos = card_infos
    end

    local biz_topo_service = {}

    function biz_topo_service:set_device_present_by_map(host_id, device_type, slotid2ssbdf)
        self.host_id = host_id
        self.device_type = device_type
        self.slotid2ssbdf = slotid2ssbdf
    end

    pcie_device_app.device_service = device_service
    pcie_device_app.biz_topo_service = biz_topo_service

    pcie_device_app:set_device_bdfs(rsp_body, device_type, req, ctx)

    lu.assertEquals(device_service.host_id, 1)
    lu.assertEquals(device_service.device_type, "PCIeCard")

    lu.assertEquals(biz_topo_service.host_id, 1)
    lu.assertEquals(biz_topo_service.device_type, "PCIeCard")
end