local lu = require 'luaunit'
local manufacture_npucard = require 'others.manufacture_npucard'
local pcie_device = require 'pcie_device_app'
local orm_object_manage = require 'mc.orm.object_manage'
local mdb_config_manage = require 'mc.mdb.micro_component.config_manage'
local intf_debug = require 'mc.mdb.micro_component.debug'
TestManufactureNpucard = {}

function TestManufactureNpucard:test_on_import()
    local records = {
      {
            Enabled = true,
            CustomType = "NPU",
            QuadrupleId = "test",
            CarType = "test",
            save = function()
            end
        }   
    }
    local ctx = {
        is_empty = function()
            return true
        end,
        get_initiator = function ()
            return {}
        end
    }

    local db = {
            PCIeCardDisplayCustom = {
                CustomType = {
                    eq = function(id)
                        return id
                    end
                }
            },
            select = function (table)
                return {
                    where = function(table)
                        return {
                            all = function ()
                                return records
                            end
                        }
                    end
                }
            end
        }
    manufacture_npucard.on_import({}, {}, {test = "NPU"})

    manufacture_npucard.on_import(db, ctx,{
        BMCSet_AtlasCustomString = {
            Value = "NPU"
        }
    })
    manufacture_npucard.on_import(db, ctx,{
        BMCSet_AtlasCustomString = {
            Value = nil
        }
    })
     manufacture_npucard.on_import(db, ctx,{
        BMCSet_AtlasCustomString = {
            Value = "test"
        }
    })
end

function TestManufactureNpucard:test_on_exprot()
    local records = {
      {
            Enabled = true,
            CustomType = "NPU",
            QuadrupleId = "test",
            CarType = "test",
            save = function()
            end
        }   
    }
    local db = {
        PCIeCardDisplayCustom = {
            CustomType = {
                eq = function(id)
                    return id
                end
            }
        },
        select = function (table)
            return { 
                where = function ()
                    return {
                        first = function ()
                            return records
                        end
                    }
                end
            }
        end
        }
        local data = manufacture_npucard.on_export(db)
        lu.assertEquals(data.BMCSet_AtlasCustomString, 'NPU')
end

TestPcieDeviceApp = {}

function TestPcieDeviceApp:test_init()
    local tmp_orm_object_manage = orm_object_manage.get_instance
    orm_object_manage.get_instance = function(...)
        return {
            start = function ()
                return nil
            end
        }
    end
    local tmp_on_add_object = orm_object_manage.on_add_object
    orm_object_manage.on_add_object = function (...)
        return
    end
    local tmp_on_delete_object = orm_object_manage.on_delete_object
    orm_object_manage.on_delete_object = function (...)
        return
    end
    local tmp_on_add_object_complete = orm_object_manage.add_object_complete
    orm_object_manage.add_object_complete = function (...)
        return
    end
    local tmp_on_delete_object_complete = orm_object_manage.on_delete_object_complete
    orm_object_manage.on_delete_object_complete = function (...)
        return
    end
    local tmp_on_recover = mdb_config_manage.on_revocer
    mdb_config_manage.on_revocer = function (...)
        return
    end
    local tmp_on_import = mdb_config_manage.on_import
    mdb_config_manage.on_import = function (...)
        return
    end
    local tmp_on_export = mdb_config_manage.on_export
    mdb_config_manage.on_export = function (func)
        func()
    end
    local tmp_on_dump = intf_debug.on_dump
    intf_debug.on_dump = function (...)
        return
    end
    local pcie_device_obj = {
        check_dependencies = function (...)
            return
        end,
        register_rpc = function (...)
            return
        end,
        register_ipmi = function (...)
            return
        end
    }
    local tmp_super = pcie_device.super
    pcie_device.super = {
        init = function(...)
        end
    }
    local ret = pcall(pcie_device.init, pcie_device_obj)
    lu.assertEquals(ret, true)
    orm_object_manage.get_instance = tmp_orm_object_manage
    orm_object_manage.on_add_object = tmp_on_add_object
    orm_object_manage.on_delete_object = tmp_on_delete_object
    orm_object_manage.on_add_object_complete = tmp_on_add_object_complete
    orm_object_manage.on_delete_object_complete = tmp_on_delete_object_complete
    mdb_config_manage.on_import = tmp_on_import
    mdb_config_manage.on_export = tmp_on_export
    mdb_config_manage.on_revocer = tmp_on_recover
    intf_debug.on_dump = tmp_on_dump
    pcie_device.super = tmp_super
end