-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local config_manage = require 'config_manage.config_manage'
local manufacture_npucard = require 'others.manufacture_npucard'
local json = require 'cjson'

TestConfigManage = {}

function TestConfigManage:test_custom_import()
    local data = {
            ConfigData = {
                CustomSettings ={
                    id = "test"
                }
            }
        }
    local t_json = json.decode
    json.decode = function(data)
        return data
    end
    local temp = manufacture_npucard.on_import
    manufacture_npucard.on_import = function(...)
    end
    config_manage.on_import({}, {}, data, "custom")

    config_manage.on_import({}, {}, {}, "custom")

    manufacture_npucard.on_import = temp
    json.decode = t_json
end

function TestConfigManage:test_custom_export()
    local temp = manufacture_npucard.on_export
    manufacture_npucard.on_export = function (db, ctx)
        return {
             CustomSettings ={
                    id = "test"
                }
        }
    end
    config_manage.on_export({}, {}, "custom")
    manufacture_npucard.on_export = temp
end