-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local cmn = require 'common'
local c_device_service = require 'device.device_service'
local utils = require 'mc.utils'
local client = require 'pcie_device.client'
local c_eth_device = require 'device.class.eth_device'

TestEthDevice = {}

local DATA_PATH<const> = './test_data/'

function TestEthDevice:test_sync_bdf_info()
    local mds_obj1 = {
        path = '', name = "ethport1", LaneId = 0,
        SocketID = 0, ControllerIndex = 0, Bus = 0
    }
    local mds_obj2 = {
        path = '', name = "ethport2", LaneId = 4,
        SocketID = 0, ControllerIndex = 0, Bus = 0
    }
    local target_pcie_connector = {
        position = "010101", start_lane = 2,
        mds_obj = {
            name = "t_connector_1",
            RefPCIeAddrInfo = "addrinfo_1"
        },
        src_connector = {
            build_ready = true,
            die_idxs = {0, 0, 0, 0, 256, 256, 256, 256},
            bus_nums = {1, 2, 3, 4, 5, 6, 7, 8},
            c_idxs = {0, 0, 0, 0, 3, 3, 3, 3},
            bcu_index = 1,
            mds_obj = {name = "src_connector_1"}
        }
    }
    cmn.skynet.fork = function(cb) cb() end
    local eth_obj1 = c_eth_device.new(mds_obj1, "0101", nil)
    local eth_obj2 = c_eth_device.new(mds_obj2, "0101", nil)
    eth_obj1:sync_bdf_info(target_pcie_connector)
    eth_obj2:sync_bdf_info(target_pcie_connector)
    lu.assertEquals(eth_obj1.mds_obj.SocketID, 0)
    lu.assertEquals(eth_obj1.mds_obj.ControllerIndex, 0)
    lu.assertEquals(eth_obj1.mds_obj.Bus, 3)
    lu.assertEquals(eth_obj2.mds_obj.SocketID, 1)
    lu.assertEquals(eth_obj2.mds_obj.ControllerIndex, 3)
    lu.assertEquals(eth_obj2.mds_obj.Bus, 7)
end