-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local json = require 'cjson'
local log = require 'mc.logging'
local manufacture_npucard = require 'others.manufacture_npucard'

local config_manage = {}

--配置导入接口
function config_manage.on_import(db, ctx, config_data, import_type)
    local data = json.decode(config_data)
    if not data or not data.ConfigData or type(data.ConfigData) ~='table' then
        log:error('import data [%s] is invalid', config_data)
        return
    end

    --装备定制化
    if import_type == 'custom' then
        if data.ConfigData.CustomSettings then
            manufacture_npucard.on_import(db, ctx, data.ConfigData.CustomSettings)
        end
        return
    end
end

--配置导出接口
function config_manage.on_export(db, ctx, export_type)
    local data = {}
    if export_type == "custom" then
        data.CustomSettings = manufacture_npucard.on_export(db, ctx)
        log:notice('Export npucard customize config successfully')
        return json.encode({ConfigData = data})
    end
    log:notice("Export npucard customize config null")
    return json.encode({ConfigData = nil})
end

return config_manage