-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local M = {}

-- PCIe卡加载错误码
M.load_error = {
    NO_MATCHING_BUSINESS_CONNECTOR = 1, -- 
    NO_MATCHING_PCIE_ADDR_INFO = 2,      -- 通过业务连接器没有匹配到指定槽位的PCIeAddrInfo对象
    TIANCHI_CONNECTOR_NOT_READY = 3      -- 天池连接器状态未就绪
}

-- 设备类型
M.device_type = {
    PCIE_CARD = 'PCIeCard', -- PCIe标卡
    OCP_CARD = 'OCPCard',   -- OCP
    DISK = 'Disk',           -- NVMe
    SAS = 'SAS',             -- SAS
    NPU_CARD = 'NPUCard'    -- NPU卡
}

-- 部件类型ComponentType和本组件定义的设备类型的映射关系
M.com_type_to_type = {
    [2] = M.device_type.DISK,
    [8] = M.device_type.PCIE_CARD,
    [83] = M.device_type.OCP_CARD,
    [71] = M.device_type.SAS
}

-- 本组件定义的设备类型和部件类型ComponentType的映射关系
M.type_to_com_type = {
    [M.device_type.DISK] = 2,
    [M.device_type.PCIE_CARD] = 8,
    [M.device_type.OCP_CARD] = 83,
    [M.device_type.SAS] = 71
}

-- PCIe控制器类型（0:PCIeCore，1:NIC，2:SAS，3:SATA，4:ZIP，5:SEC）
M.controller_type = {
    PCIE = 0,
    NIC = 1,
    SAS = 2,
    SATA = 3,
    ZIP = 4,
    SEC = 5
}

-- SerDes模式配置
M.serdes_mode = {
    NONE = 0,
    PCIE = 1,
    HCCS_DMI = 2,
    SATA = 3,
    SAS = 4,
    CXL = 5,
    GBE_ETH = 6,
    USB = 7,
    GPIO = 8
}

-- PCIe控制器类型和SerDes模式配置的映射关系
M.controller_type_to_work_mode = {
    [M.controller_type.PCIE] = M.serdes_mode.PCIE,   -- PCIeCore对应WorkMode 1
    [M.controller_type.SAS] = M.serdes_mode.SAS,     -- SAS对应WorkMode 4
    [M.controller_type.SATA] = M.serdes_mode.SATA    -- SATA对应WorkMode 3
}

M.com_type = {
    DISK = 2,
    RAID_CARD = 6,
    PCIE_CARD = 8,
    MEZZ_CARD = 11,
    NIC_CARD = 13,
    OCP_CARD = 83
}

M.TOPO_STATUS = {
    INITIAL_STATE = 0,        -- 初始状态，状态去重之后设置
    -- 基础组件端口状态
    MATCHED = 1,              -- 匹配成功
    INCORRECT_CONNECTION = 2, -- 线缆连接错误
    UNIT_NOT_SUPPORT = 3,     -- 组件不支持，白名单中没有配置该组件信息
    -- 对端组件状态
    UNIT_NOT_EXIT = 4,        -- 组件不存在，基础组件端口没有读取到该组件信息
    INCOMPLETE_CONNECTION = 5, -- 组件连接不完整（部分线缆未插或连接器连接不完整）
    IGNORE_VALUE = 255        -- 状态量255为EVENT忽略值，EVENT不会进行告警产生或恢复
}

M.PCIE_SLOT_ID_VALUE = {
    MIN_SLOT_ID_VALUE = 0,
    MAX_SLOT_ID_VALUE = 255,
}

M.DBD_CONT = {
    CONT_NUM = 2
}

M.PROP_PORT_LINK_INFO = { [1] = 'Port1LinkInfo', [2] = 'Port2LinkInfo' }

M.PROP_PORT_STATUS = { [1] = 'Port1Status', [2] = 'Port2Status' }

M.ON_ADD_STATUS = {
    ["ON_ADD"] = 1,
    ["ON_ADD_COMPLETE"] = 2
}

M.REFINE_ALARM_STATUS = {
    ["CONN_ALARM"] = 1,         -- 对应精细化告警场景，告警在riser卡上
    ["UNIT_CONFIG_ALARM"] = 2   -- 对应非精细化告警场景，告警在unit_config上
}
return M