-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local c_base = require 'biz_topo.class.base'

---@class PCIeAddrInfo: Base @PCIe地址（槽位）信息
local c_pcie_addr_info = class(c_base, nil, true)

function c_pcie_addr_info:update_device_bdf(dev_bus, dev_device, dev_function)
    self:set_prop('DevBus', dev_bus)
    self:set_prop('DevDevice', dev_device)
    self:set_prop('DevFunction', dev_function)
end

function c_pcie_addr_info:update_vid_did(vid, did)
    self:set_prop('VendorID', vid)
    self:set_prop('DeviceID', did)
end

function c_pcie_addr_info:ctor(mds_obj, position)
    self.default_interface = 'bmc.kepler.Systems.PcieAddrInfo'
    self.mds_obj = mds_obj
    self.position = position
end

function c_pcie_addr_info:update_multihost_presence(v)
    self:set_prop('MultihostPresence', v)
end

return c_pcie_addr_info