-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local log = require 'mc.logging'

local ipmi_chan_cfg_obj = class()

function ipmi_chan_cfg_obj:ctor(obj)
    self.mds_obj = obj
    self.configs = {}
end

local function config_new(HostId, Instance)
    return { HostId = HostId, Instance = Instance }
end

function ipmi_chan_cfg_obj:init()
    if self.mds_obj.Maps and #self.mds_obj.Maps ~= 0 and
        #self.mds_obj.Maps[1] ~= 0 then
        for i, config in ipairs(self.mds_obj.Maps) do
            self.mds_obj.Maps[i] = config_new(table.unpack(config))

            -- 初始化 configs
            if not self.configs[self.mds_obj.Maps[i].HostId] then
                self.configs[self.mds_obj.Maps[i].HostId] = {}
            end
            log:notice('[ipmi_chan_cfg_obj] host_id=%s, instance=%s',
                self.mds_obj.Maps[i].HostId, self.mds_obj.Maps[i].Instance)
            self.configs[self.mds_obj.Maps[i].HostId] = self.mds_obj.Maps[i].Instance
        end
    end
end

return ipmi_chan_cfg_obj