-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local log = require 'mc.logging'
local cmn = require 'common'

---@class Base @通用基类
local c_base = class()

function c_base:get_prop(name, interface)
    if not self.mds_obj then
        return nil
    end

    if interface then
        return self.mds_obj[interface][name]
    elseif self.mds_obj[name] then
        return self.mds_obj[name]
    else
        return self.mds_obj[self.default_interface][name]
    end
end

function c_base:set_prop(name, val, interface)
    if not self.mds_obj then
        return nil
    end
    local ok, msg
    local i = 0
    if interface then
        self.mds_obj[interface][name] = val
    elseif self.mds_obj[name] then
        repeat
            ok, msg = pcall(function()
                self.mds_obj[name] = val
            end)
            if not ok then
                i = i + 1
                cmn.skynet.sleep(100 * 1)
                log:error('[BizTopo] set name=%s failed, msg=%s', name, msg)
            end
        until ok or i > 10
    else
        repeat
            if not self.mds_obj or not self.default_interface or not self.mds_obj[self.default_interface] then
                log:debug('[BizTopo] obj nil')
                return nil
            end
            ok, msg = pcall(function()
                self.mds_obj[self.default_interface][name] = val
            end)
            if not ok then
                i = i + 1
                log:error('[BizTopo] set name=%s failed, msg=%s', name, msg)
            end
        until ok or i > 10
    end
end

function c_base:ctor(mds_obj)
    self.default_interface = 'XXX'
    self.mds_obj = mds_obj
end

return c_base
