-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeFunctionRAS = {}

---@class PCIeFunctionRAS.CorrectableErrorOverfrequencyCount
---@field CorrectableErrorOverfrequencyCount integer
local TCorrectableErrorOverfrequencyCount = {}
TCorrectableErrorOverfrequencyCount.__index = TCorrectableErrorOverfrequencyCount
TCorrectableErrorOverfrequencyCount.group = {}

local function TCorrectableErrorOverfrequencyCount_from_obj(obj)
    return setmetatable(obj, TCorrectableErrorOverfrequencyCount)
end

function TCorrectableErrorOverfrequencyCount.new(CorrectableErrorOverfrequencyCount)
    return TCorrectableErrorOverfrequencyCount_from_obj({
        CorrectableErrorOverfrequencyCount = CorrectableErrorOverfrequencyCount or 0
    })
end
---@param obj PCIeFunctionRAS.CorrectableErrorOverfrequencyCount
function TCorrectableErrorOverfrequencyCount:init_from_obj(obj)
    self.CorrectableErrorOverfrequencyCount = obj.CorrectableErrorOverfrequencyCount or 0
end

function TCorrectableErrorOverfrequencyCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCorrectableErrorOverfrequencyCount.group)
end

TCorrectableErrorOverfrequencyCount.from_obj = TCorrectableErrorOverfrequencyCount_from_obj

TCorrectableErrorOverfrequencyCount.proto_property = {'CorrectableErrorOverfrequencyCount'}

TCorrectableErrorOverfrequencyCount.default = {0}

TCorrectableErrorOverfrequencyCount.struct = {
    {name = 'CorrectableErrorOverfrequencyCount', is_array = false, struct = nil}
}

function TCorrectableErrorOverfrequencyCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CorrectableErrorOverfrequencyCount', self.CorrectableErrorOverfrequencyCount, 'uint32',
        false, errs, need_convert)

    TCorrectableErrorOverfrequencyCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCorrectableErrorOverfrequencyCount.proto_property, errs, need_convert)
    return self
end

function TCorrectableErrorOverfrequencyCount:unpack(_)
    return self.CorrectableErrorOverfrequencyCount
end

PCIeFunctionRAS.CorrectableErrorOverfrequencyCount = TCorrectableErrorOverfrequencyCount

---@class PCIeFunctionRAS.UnsupportedRequestCount
---@field UnsupportedRequestCount integer
local TUnsupportedRequestCount = {}
TUnsupportedRequestCount.__index = TUnsupportedRequestCount
TUnsupportedRequestCount.group = {}

local function TUnsupportedRequestCount_from_obj(obj)
    return setmetatable(obj, TUnsupportedRequestCount)
end

function TUnsupportedRequestCount.new(UnsupportedRequestCount)
    return TUnsupportedRequestCount_from_obj({UnsupportedRequestCount = UnsupportedRequestCount or 0})
end
---@param obj PCIeFunctionRAS.UnsupportedRequestCount
function TUnsupportedRequestCount:init_from_obj(obj)
    self.UnsupportedRequestCount = obj.UnsupportedRequestCount or 0
end

function TUnsupportedRequestCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnsupportedRequestCount.group)
end

TUnsupportedRequestCount.from_obj = TUnsupportedRequestCount_from_obj

TUnsupportedRequestCount.proto_property = {'UnsupportedRequestCount'}

TUnsupportedRequestCount.default = {0}

TUnsupportedRequestCount.struct = {{name = 'UnsupportedRequestCount', is_array = false, struct = nil}}

function TUnsupportedRequestCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnsupportedRequestCount', self.UnsupportedRequestCount, 'uint32', false, errs,
        need_convert)

    TUnsupportedRequestCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnsupportedRequestCount.proto_property, errs, need_convert)
    return self
end

function TUnsupportedRequestCount:unpack(_)
    return self.UnsupportedRequestCount
end

PCIeFunctionRAS.UnsupportedRequestCount = TUnsupportedRequestCount

---@class PCIeFunctionRAS.BadTLPCount
---@field BadTLPCount integer
local TBadTLPCount = {}
TBadTLPCount.__index = TBadTLPCount
TBadTLPCount.group = {}

local function TBadTLPCount_from_obj(obj)
    return setmetatable(obj, TBadTLPCount)
end

function TBadTLPCount.new(BadTLPCount)
    return TBadTLPCount_from_obj({BadTLPCount = BadTLPCount or 0})
end
---@param obj PCIeFunctionRAS.BadTLPCount
function TBadTLPCount:init_from_obj(obj)
    self.BadTLPCount = obj.BadTLPCount or 0
end

function TBadTLPCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBadTLPCount.group)
end

TBadTLPCount.from_obj = TBadTLPCount_from_obj

TBadTLPCount.proto_property = {'BadTLPCount'}

TBadTLPCount.default = {0}

TBadTLPCount.struct = {{name = 'BadTLPCount', is_array = false, struct = nil}}

function TBadTLPCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BadTLPCount', self.BadTLPCount, 'uint32', false, errs, need_convert)

    TBadTLPCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBadTLPCount.proto_property, errs, need_convert)
    return self
end

function TBadTLPCount:unpack(_)
    return self.BadTLPCount
end

PCIeFunctionRAS.BadTLPCount = TBadTLPCount

---@class PCIeFunctionRAS.BadDLLPCount
---@field BadDLLPCount integer
local TBadDLLPCount = {}
TBadDLLPCount.__index = TBadDLLPCount
TBadDLLPCount.group = {}

local function TBadDLLPCount_from_obj(obj)
    return setmetatable(obj, TBadDLLPCount)
end

function TBadDLLPCount.new(BadDLLPCount)
    return TBadDLLPCount_from_obj({BadDLLPCount = BadDLLPCount or 0})
end
---@param obj PCIeFunctionRAS.BadDLLPCount
function TBadDLLPCount:init_from_obj(obj)
    self.BadDLLPCount = obj.BadDLLPCount or 0
end

function TBadDLLPCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBadDLLPCount.group)
end

TBadDLLPCount.from_obj = TBadDLLPCount_from_obj

TBadDLLPCount.proto_property = {'BadDLLPCount'}

TBadDLLPCount.default = {0}

TBadDLLPCount.struct = {{name = 'BadDLLPCount', is_array = false, struct = nil}}

function TBadDLLPCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BadDLLPCount', self.BadDLLPCount, 'uint32', false, errs, need_convert)

    TBadDLLPCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBadDLLPCount.proto_property, errs, need_convert)
    return self
end

function TBadDLLPCount:unpack(_)
    return self.BadDLLPCount
end

PCIeFunctionRAS.BadDLLPCount = TBadDLLPCount

---@class PCIeFunctionRAS.NonFatalErrorCount
---@field NonFatalErrorCount integer
local TNonFatalErrorCount = {}
TNonFatalErrorCount.__index = TNonFatalErrorCount
TNonFatalErrorCount.group = {}

local function TNonFatalErrorCount_from_obj(obj)
    return setmetatable(obj, TNonFatalErrorCount)
end

function TNonFatalErrorCount.new(NonFatalErrorCount)
    return TNonFatalErrorCount_from_obj({NonFatalErrorCount = NonFatalErrorCount or 0})
end
---@param obj PCIeFunctionRAS.NonFatalErrorCount
function TNonFatalErrorCount:init_from_obj(obj)
    self.NonFatalErrorCount = obj.NonFatalErrorCount or 0
end

function TNonFatalErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNonFatalErrorCount.group)
end

TNonFatalErrorCount.from_obj = TNonFatalErrorCount_from_obj

TNonFatalErrorCount.proto_property = {'NonFatalErrorCount'}

TNonFatalErrorCount.default = {0}

TNonFatalErrorCount.struct = {{name = 'NonFatalErrorCount', is_array = false, struct = nil}}

function TNonFatalErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NonFatalErrorCount', self.NonFatalErrorCount, 'uint32', false, errs, need_convert)

    TNonFatalErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNonFatalErrorCount.proto_property, errs, need_convert)
    return self
end

function TNonFatalErrorCount:unpack(_)
    return self.NonFatalErrorCount
end

PCIeFunctionRAS.NonFatalErrorCount = TNonFatalErrorCount

---@class PCIeFunctionRAS.FatalErrorCount
---@field FatalErrorCount integer
local TFatalErrorCount = {}
TFatalErrorCount.__index = TFatalErrorCount
TFatalErrorCount.group = {}

local function TFatalErrorCount_from_obj(obj)
    return setmetatable(obj, TFatalErrorCount)
end

function TFatalErrorCount.new(FatalErrorCount)
    return TFatalErrorCount_from_obj({FatalErrorCount = FatalErrorCount or 0})
end
---@param obj PCIeFunctionRAS.FatalErrorCount
function TFatalErrorCount:init_from_obj(obj)
    self.FatalErrorCount = obj.FatalErrorCount or 0
end

function TFatalErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFatalErrorCount.group)
end

TFatalErrorCount.from_obj = TFatalErrorCount_from_obj

TFatalErrorCount.proto_property = {'FatalErrorCount'}

TFatalErrorCount.default = {0}

TFatalErrorCount.struct = {{name = 'FatalErrorCount', is_array = false, struct = nil}}

function TFatalErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FatalErrorCount', self.FatalErrorCount, 'uint32', false, errs, need_convert)

    TFatalErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFatalErrorCount.proto_property, errs, need_convert)
    return self
end

function TFatalErrorCount:unpack(_)
    return self.FatalErrorCount
end

PCIeFunctionRAS.FatalErrorCount = TFatalErrorCount

PCIeFunctionRAS.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevice.PCIeFunction.RAS', {
    FatalErrorCount = {'u', nil, false, 0},
    NonFatalErrorCount = {'u', nil, false, 0},
    BadDLLPCount = {'u', nil, false, 0},
    BadTLPCount = {'u', nil, false, 0},
    UnsupportedRequestCount = {'u', nil, false, 0},
    CorrectableErrorOverfrequencyCount = {'u', nil, false, 0}
}, {}, {})

return PCIeFunctionRAS
