-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeFunction = {}

---@class PCIeFunction.ProgrammingInterface
---@field ProgrammingInterface integer
local TProgrammingInterface = {}
TProgrammingInterface.__index = TProgrammingInterface
TProgrammingInterface.group = {}

local function TProgrammingInterface_from_obj(obj)
    return setmetatable(obj, TProgrammingInterface)
end

function TProgrammingInterface.new(ProgrammingInterface)
    return TProgrammingInterface_from_obj({ProgrammingInterface = ProgrammingInterface or 255})
end
---@param obj PCIeFunction.ProgrammingInterface
function TProgrammingInterface:init_from_obj(obj)
    self.ProgrammingInterface = obj.ProgrammingInterface or 255
end

function TProgrammingInterface:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProgrammingInterface.group)
end

TProgrammingInterface.from_obj = TProgrammingInterface_from_obj

TProgrammingInterface.proto_property = {'ProgrammingInterface'}

TProgrammingInterface.default = {0}

TProgrammingInterface.struct = {{name = 'ProgrammingInterface', is_array = false, struct = nil}}

function TProgrammingInterface:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ProgrammingInterface', self.ProgrammingInterface, 'uint8', true, errs, need_convert)

    TProgrammingInterface:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProgrammingInterface.proto_property, errs, need_convert)
    return self
end

function TProgrammingInterface:unpack(_)
    return self.ProgrammingInterface
end

PCIeFunction.ProgrammingInterface = TProgrammingInterface

---@class PCIeFunction.SubClassCode
---@field SubClassCode integer
local TSubClassCode = {}
TSubClassCode.__index = TSubClassCode
TSubClassCode.group = {}

local function TSubClassCode_from_obj(obj)
    return setmetatable(obj, TSubClassCode)
end

function TSubClassCode.new(SubClassCode)
    return TSubClassCode_from_obj({SubClassCode = SubClassCode or 255})
end
---@param obj PCIeFunction.SubClassCode
function TSubClassCode:init_from_obj(obj)
    self.SubClassCode = obj.SubClassCode or 255
end

function TSubClassCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubClassCode.group)
end

TSubClassCode.from_obj = TSubClassCode_from_obj

TSubClassCode.proto_property = {'SubClassCode'}

TSubClassCode.default = {0}

TSubClassCode.struct = {{name = 'SubClassCode', is_array = false, struct = nil}}

function TSubClassCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubClassCode', self.SubClassCode, 'uint8', true, errs, need_convert)

    TSubClassCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubClassCode.proto_property, errs, need_convert)
    return self
end

function TSubClassCode:unpack(_)
    return self.SubClassCode
end

PCIeFunction.SubClassCode = TSubClassCode

---@class PCIeFunction.BaseClassCode
---@field BaseClassCode integer
local TBaseClassCode = {}
TBaseClassCode.__index = TBaseClassCode
TBaseClassCode.group = {}

local function TBaseClassCode_from_obj(obj)
    return setmetatable(obj, TBaseClassCode)
end

function TBaseClassCode.new(BaseClassCode)
    return TBaseClassCode_from_obj({BaseClassCode = BaseClassCode or 255})
end
---@param obj PCIeFunction.BaseClassCode
function TBaseClassCode:init_from_obj(obj)
    self.BaseClassCode = obj.BaseClassCode or 255
end

function TBaseClassCode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBaseClassCode.group)
end

TBaseClassCode.from_obj = TBaseClassCode_from_obj

TBaseClassCode.proto_property = {'BaseClassCode'}

TBaseClassCode.default = {0}

TBaseClassCode.struct = {{name = 'BaseClassCode', is_array = false, struct = nil}}

function TBaseClassCode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BaseClassCode', self.BaseClassCode, 'uint8', true, errs, need_convert)

    TBaseClassCode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBaseClassCode.proto_property, errs, need_convert)
    return self
end

function TBaseClassCode:unpack(_)
    return self.BaseClassCode
end

PCIeFunction.BaseClassCode = TBaseClassCode

---@class PCIeFunction.FunctionType
---@field FunctionType string
local TFunctionType = {}
TFunctionType.__index = TFunctionType
TFunctionType.group = {}

local function TFunctionType_from_obj(obj)
    return setmetatable(obj, TFunctionType)
end

function TFunctionType.new(FunctionType)
    return TFunctionType_from_obj({FunctionType = FunctionType or [=[Physical]=]})
end
---@param obj PCIeFunction.FunctionType
function TFunctionType:init_from_obj(obj)
    self.FunctionType = obj.FunctionType or [=[Physical]=]
end

function TFunctionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionType.group)
end

TFunctionType.from_obj = TFunctionType_from_obj

TFunctionType.proto_property = {'FunctionType'}

TFunctionType.default = {''}

TFunctionType.struct = {{name = 'FunctionType', is_array = false, struct = nil}}

function TFunctionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionType', self.FunctionType, 'string', true, errs, need_convert)

    if self.FunctionType ~= nil then
        validate.Enum(prefix .. 'FunctionType', self.FunctionType, '', {'Physical', 'Virtual'}, errs, need_convert)
    end

    TFunctionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionType.proto_property, errs, need_convert)
    return self
end

function TFunctionType:unpack(_)
    return self.FunctionType
end

PCIeFunction.FunctionType = TFunctionType

---@class PCIeFunction.FunctionProtocol
---@field FunctionProtocol string
local TFunctionProtocol = {}
TFunctionProtocol.__index = TFunctionProtocol
TFunctionProtocol.group = {}

local function TFunctionProtocol_from_obj(obj)
    return setmetatable(obj, TFunctionProtocol)
end

function TFunctionProtocol.new(FunctionProtocol)
    return TFunctionProtocol_from_obj({FunctionProtocol = FunctionProtocol or [=[PCIe]=]})
end
---@param obj PCIeFunction.FunctionProtocol
function TFunctionProtocol:init_from_obj(obj)
    self.FunctionProtocol = obj.FunctionProtocol or [=[PCIe]=]
end

function TFunctionProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionProtocol.group)
end

TFunctionProtocol.from_obj = TFunctionProtocol_from_obj

TFunctionProtocol.proto_property = {'FunctionProtocol'}

TFunctionProtocol.default = {''}

TFunctionProtocol.struct = {{name = 'FunctionProtocol', is_array = false, struct = nil}}

function TFunctionProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionProtocol', self.FunctionProtocol, 'string', true, errs, need_convert)

    if self.FunctionProtocol ~= nil then
        validate.Enum(prefix .. 'FunctionProtocol', self.FunctionProtocol, '', {'CXL', 'PCIe'}, errs, need_convert)
    end

    TFunctionProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionProtocol.proto_property, errs, need_convert)
    return self
end

function TFunctionProtocol:unpack(_)
    return self.FunctionProtocol
end

PCIeFunction.FunctionProtocol = TFunctionProtocol

---@class PCIeFunction.SubsystemId
---@field SubsystemId integer
local TSubsystemId = {}
TSubsystemId.__index = TSubsystemId
TSubsystemId.group = {}

local function TSubsystemId_from_obj(obj)
    return setmetatable(obj, TSubsystemId)
end

function TSubsystemId.new(SubsystemId)
    return TSubsystemId_from_obj({SubsystemId = SubsystemId or 65535})
end
---@param obj PCIeFunction.SubsystemId
function TSubsystemId:init_from_obj(obj)
    self.SubsystemId = obj.SubsystemId or 65535
end

function TSubsystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubsystemId.group)
end

TSubsystemId.from_obj = TSubsystemId_from_obj

TSubsystemId.proto_property = {'SubsystemId'}

TSubsystemId.default = {0}

TSubsystemId.struct = {{name = 'SubsystemId', is_array = false, struct = nil}}

function TSubsystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubsystemId', self.SubsystemId, 'uint16', true, errs, need_convert)

    TSubsystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubsystemId.proto_property, errs, need_convert)
    return self
end

function TSubsystemId:unpack(_)
    return self.SubsystemId
end

PCIeFunction.SubsystemId = TSubsystemId

---@class PCIeFunction.SubsystemVendorId
---@field SubsystemVendorId integer
local TSubsystemVendorId = {}
TSubsystemVendorId.__index = TSubsystemVendorId
TSubsystemVendorId.group = {}

local function TSubsystemVendorId_from_obj(obj)
    return setmetatable(obj, TSubsystemVendorId)
end

function TSubsystemVendorId.new(SubsystemVendorId)
    return TSubsystemVendorId_from_obj({SubsystemVendorId = SubsystemVendorId or 65535})
end
---@param obj PCIeFunction.SubsystemVendorId
function TSubsystemVendorId:init_from_obj(obj)
    self.SubsystemVendorId = obj.SubsystemVendorId or 65535
end

function TSubsystemVendorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubsystemVendorId.group)
end

TSubsystemVendorId.from_obj = TSubsystemVendorId_from_obj

TSubsystemVendorId.proto_property = {'SubsystemVendorId'}

TSubsystemVendorId.default = {0}

TSubsystemVendorId.struct = {{name = 'SubsystemVendorId', is_array = false, struct = nil}}

function TSubsystemVendorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SubsystemVendorId', self.SubsystemVendorId, 'uint16', true, errs, need_convert)

    TSubsystemVendorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubsystemVendorId.proto_property, errs, need_convert)
    return self
end

function TSubsystemVendorId:unpack(_)
    return self.SubsystemVendorId
end

PCIeFunction.SubsystemVendorId = TSubsystemVendorId

---@class PCIeFunction.DeviceId
---@field DeviceId integer
local TDeviceId = {}
TDeviceId.__index = TDeviceId
TDeviceId.group = {}

local function TDeviceId_from_obj(obj)
    return setmetatable(obj, TDeviceId)
end

function TDeviceId.new(DeviceId)
    return TDeviceId_from_obj({DeviceId = DeviceId or 65535})
end
---@param obj PCIeFunction.DeviceId
function TDeviceId:init_from_obj(obj)
    self.DeviceId = obj.DeviceId or 65535
end

function TDeviceId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceId.group)
end

TDeviceId.from_obj = TDeviceId_from_obj

TDeviceId.proto_property = {'DeviceId'}

TDeviceId.default = {0}

TDeviceId.struct = {{name = 'DeviceId', is_array = false, struct = nil}}

function TDeviceId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceId', self.DeviceId, 'uint16', true, errs, need_convert)

    TDeviceId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceId.proto_property, errs, need_convert)
    return self
end

function TDeviceId:unpack(_)
    return self.DeviceId
end

PCIeFunction.DeviceId = TDeviceId

---@class PCIeFunction.VendorId
---@field VendorId integer
local TVendorId = {}
TVendorId.__index = TVendorId
TVendorId.group = {}

local function TVendorId_from_obj(obj)
    return setmetatable(obj, TVendorId)
end

function TVendorId.new(VendorId)
    return TVendorId_from_obj({VendorId = VendorId or 65535})
end
---@param obj PCIeFunction.VendorId
function TVendorId:init_from_obj(obj)
    self.VendorId = obj.VendorId or 65535
end

function TVendorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVendorId.group)
end

TVendorId.from_obj = TVendorId_from_obj

TVendorId.proto_property = {'VendorId'}

TVendorId.default = {0}

TVendorId.struct = {{name = 'VendorId', is_array = false, struct = nil}}

function TVendorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VendorId', self.VendorId, 'uint16', true, errs, need_convert)

    TVendorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVendorId.proto_property, errs, need_convert)
    return self
end

function TVendorId:unpack(_)
    return self.VendorId
end

PCIeFunction.VendorId = TVendorId

---@class PCIeFunction.RootFunctionNumber
---@field RootFunctionNumber integer
local TRootFunctionNumber = {}
TRootFunctionNumber.__index = TRootFunctionNumber
TRootFunctionNumber.group = {}

local function TRootFunctionNumber_from_obj(obj)
    return setmetatable(obj, TRootFunctionNumber)
end

function TRootFunctionNumber.new(RootFunctionNumber)
    return TRootFunctionNumber_from_obj({RootFunctionNumber = RootFunctionNumber or 255})
end
---@param obj PCIeFunction.RootFunctionNumber
function TRootFunctionNumber:init_from_obj(obj)
    self.RootFunctionNumber = obj.RootFunctionNumber or 255
end

function TRootFunctionNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootFunctionNumber.group)
end

TRootFunctionNumber.from_obj = TRootFunctionNumber_from_obj

TRootFunctionNumber.proto_property = {'RootFunctionNumber'}

TRootFunctionNumber.default = {0}

TRootFunctionNumber.struct = {{name = 'RootFunctionNumber', is_array = false, struct = nil}}

function TRootFunctionNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootFunctionNumber', self.RootFunctionNumber, 'uint8', true, errs, need_convert)

    TRootFunctionNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootFunctionNumber.proto_property, errs, need_convert)
    return self
end

function TRootFunctionNumber:unpack(_)
    return self.RootFunctionNumber
end

PCIeFunction.RootFunctionNumber = TRootFunctionNumber

---@class PCIeFunction.RootDeviceNumber
---@field RootDeviceNumber integer
local TRootDeviceNumber = {}
TRootDeviceNumber.__index = TRootDeviceNumber
TRootDeviceNumber.group = {}

local function TRootDeviceNumber_from_obj(obj)
    return setmetatable(obj, TRootDeviceNumber)
end

function TRootDeviceNumber.new(RootDeviceNumber)
    return TRootDeviceNumber_from_obj({RootDeviceNumber = RootDeviceNumber or 255})
end
---@param obj PCIeFunction.RootDeviceNumber
function TRootDeviceNumber:init_from_obj(obj)
    self.RootDeviceNumber = obj.RootDeviceNumber or 255
end

function TRootDeviceNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootDeviceNumber.group)
end

TRootDeviceNumber.from_obj = TRootDeviceNumber_from_obj

TRootDeviceNumber.proto_property = {'RootDeviceNumber'}

TRootDeviceNumber.default = {0}

TRootDeviceNumber.struct = {{name = 'RootDeviceNumber', is_array = false, struct = nil}}

function TRootDeviceNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootDeviceNumber', self.RootDeviceNumber, 'uint8', true, errs, need_convert)

    TRootDeviceNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootDeviceNumber.proto_property, errs, need_convert)
    return self
end

function TRootDeviceNumber:unpack(_)
    return self.RootDeviceNumber
end

PCIeFunction.RootDeviceNumber = TRootDeviceNumber

---@class PCIeFunction.RootBusNumber
---@field RootBusNumber integer
local TRootBusNumber = {}
TRootBusNumber.__index = TRootBusNumber
TRootBusNumber.group = {}

local function TRootBusNumber_from_obj(obj)
    return setmetatable(obj, TRootBusNumber)
end

function TRootBusNumber.new(RootBusNumber)
    return TRootBusNumber_from_obj({RootBusNumber = RootBusNumber or 255})
end
---@param obj PCIeFunction.RootBusNumber
function TRootBusNumber:init_from_obj(obj)
    self.RootBusNumber = obj.RootBusNumber or 255
end

function TRootBusNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRootBusNumber.group)
end

TRootBusNumber.from_obj = TRootBusNumber_from_obj

TRootBusNumber.proto_property = {'RootBusNumber'}

TRootBusNumber.default = {0}

TRootBusNumber.struct = {{name = 'RootBusNumber', is_array = false, struct = nil}}

function TRootBusNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RootBusNumber', self.RootBusNumber, 'uint8', true, errs, need_convert)

    TRootBusNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRootBusNumber.proto_property, errs, need_convert)
    return self
end

function TRootBusNumber:unpack(_)
    return self.RootBusNumber
end

PCIeFunction.RootBusNumber = TRootBusNumber

---@class PCIeFunction.RelatedProcessorId
---@field RelatedProcessorId integer
local TRelatedProcessorId = {}
TRelatedProcessorId.__index = TRelatedProcessorId
TRelatedProcessorId.group = {}

local function TRelatedProcessorId_from_obj(obj)
    return setmetatable(obj, TRelatedProcessorId)
end

function TRelatedProcessorId.new(RelatedProcessorId)
    return TRelatedProcessorId_from_obj({RelatedProcessorId = RelatedProcessorId or 255})
end
---@param obj PCIeFunction.RelatedProcessorId
function TRelatedProcessorId:init_from_obj(obj)
    self.RelatedProcessorId = obj.RelatedProcessorId or 255
end

function TRelatedProcessorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRelatedProcessorId.group)
end

TRelatedProcessorId.from_obj = TRelatedProcessorId_from_obj

TRelatedProcessorId.proto_property = {'RelatedProcessorId'}

TRelatedProcessorId.default = {0}

TRelatedProcessorId.struct = {{name = 'RelatedProcessorId', is_array = false, struct = nil}}

function TRelatedProcessorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RelatedProcessorId', self.RelatedProcessorId, 'uint8', true, errs, need_convert)

    TRelatedProcessorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRelatedProcessorId.proto_property, errs, need_convert)
    return self
end

function TRelatedProcessorId:unpack(_)
    return self.RelatedProcessorId
end

PCIeFunction.RelatedProcessorId = TRelatedProcessorId

---@class PCIeFunction.FunctionNumber
---@field FunctionNumber integer
local TFunctionNumber = {}
TFunctionNumber.__index = TFunctionNumber
TFunctionNumber.group = {}

local function TFunctionNumber_from_obj(obj)
    return setmetatable(obj, TFunctionNumber)
end

function TFunctionNumber.new(FunctionNumber)
    return TFunctionNumber_from_obj({FunctionNumber = FunctionNumber or 255})
end
---@param obj PCIeFunction.FunctionNumber
function TFunctionNumber:init_from_obj(obj)
    self.FunctionNumber = obj.FunctionNumber or 255
end

function TFunctionNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionNumber.group)
end

TFunctionNumber.from_obj = TFunctionNumber_from_obj

TFunctionNumber.proto_property = {'FunctionNumber'}

TFunctionNumber.default = {0}

TFunctionNumber.struct = {{name = 'FunctionNumber', is_array = false, struct = nil}}

function TFunctionNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionNumber', self.FunctionNumber, 'uint8', true, errs, need_convert)

    TFunctionNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionNumber.proto_property, errs, need_convert)
    return self
end

function TFunctionNumber:unpack(_)
    return self.FunctionNumber
end

PCIeFunction.FunctionNumber = TFunctionNumber

---@class PCIeFunction.DeviceNumber
---@field DeviceNumber integer
local TDeviceNumber = {}
TDeviceNumber.__index = TDeviceNumber
TDeviceNumber.group = {}

local function TDeviceNumber_from_obj(obj)
    return setmetatable(obj, TDeviceNumber)
end

function TDeviceNumber.new(DeviceNumber)
    return TDeviceNumber_from_obj({DeviceNumber = DeviceNumber or 255})
end
---@param obj PCIeFunction.DeviceNumber
function TDeviceNumber:init_from_obj(obj)
    self.DeviceNumber = obj.DeviceNumber or 255
end

function TDeviceNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceNumber.group)
end

TDeviceNumber.from_obj = TDeviceNumber_from_obj

TDeviceNumber.proto_property = {'DeviceNumber'}

TDeviceNumber.default = {0}

TDeviceNumber.struct = {{name = 'DeviceNumber', is_array = false, struct = nil}}

function TDeviceNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', true, errs, need_convert)

    TDeviceNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceNumber.proto_property, errs, need_convert)
    return self
end

function TDeviceNumber:unpack(_)
    return self.DeviceNumber
end

PCIeFunction.DeviceNumber = TDeviceNumber

---@class PCIeFunction.BusNumber
---@field BusNumber integer
local TBusNumber = {}
TBusNumber.__index = TBusNumber
TBusNumber.group = {}

local function TBusNumber_from_obj(obj)
    return setmetatable(obj, TBusNumber)
end

function TBusNumber.new(BusNumber)
    return TBusNumber_from_obj({BusNumber = BusNumber or 255})
end
---@param obj PCIeFunction.BusNumber
function TBusNumber:init_from_obj(obj)
    self.BusNumber = obj.BusNumber or 255
end

function TBusNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBusNumber.group)
end

TBusNumber.from_obj = TBusNumber_from_obj

TBusNumber.proto_property = {'BusNumber'}

TBusNumber.default = {0}

TBusNumber.struct = {{name = 'BusNumber', is_array = false, struct = nil}}

function TBusNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BusNumber', self.BusNumber, 'uint8', true, errs, need_convert)

    TBusNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBusNumber.proto_property, errs, need_convert)
    return self
end

function TBusNumber:unpack(_)
    return self.BusNumber
end

PCIeFunction.BusNumber = TBusNumber

---@class PCIeFunction.SegmentNumber
---@field SegmentNumber integer
local TSegmentNumber = {}
TSegmentNumber.__index = TSegmentNumber
TSegmentNumber.group = {}

local function TSegmentNumber_from_obj(obj)
    return setmetatable(obj, TSegmentNumber)
end

function TSegmentNumber.new(SegmentNumber)
    return TSegmentNumber_from_obj({SegmentNumber = SegmentNumber or 65535})
end
---@param obj PCIeFunction.SegmentNumber
function TSegmentNumber:init_from_obj(obj)
    self.SegmentNumber = obj.SegmentNumber or 65535
end

function TSegmentNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegmentNumber.group)
end

TSegmentNumber.from_obj = TSegmentNumber_from_obj

TSegmentNumber.proto_property = {'SegmentNumber'}

TSegmentNumber.default = {0}

TSegmentNumber.struct = {{name = 'SegmentNumber', is_array = false, struct = nil}}

function TSegmentNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SegmentNumber', self.SegmentNumber, 'uint16', true, errs, need_convert)

    TSegmentNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegmentNumber.proto_property, errs, need_convert)
    return self
end

function TSegmentNumber:unpack(_)
    return self.SegmentNumber
end

PCIeFunction.SegmentNumber = TSegmentNumber

PCIeFunction.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevice.PCIeFunction', {
    SegmentNumber = {'q', {}, true, 65535},
    BusNumber = {'y', {}, true, 255},
    DeviceNumber = {'y', {}, true, 255},
    FunctionNumber = {'y', {}, true, 255},
    RelatedProcessorId = {'y', {}, true, 255},
    RootBusNumber = {'y', {}, true, 255},
    RootDeviceNumber = {'y', {}, true, 255},
    RootFunctionNumber = {'y', {}, true, 255},
    VendorId = {'q', {}, true, 65535},
    DeviceId = {'q', {}, true, 65535},
    SubsystemVendorId = {'q', {}, true, 65535},
    SubsystemId = {'q', {}, true, 65535},
    FunctionProtocol = {'s', {}, true, 'PCIe'},
    FunctionType = {'s', {}, true, 'Physical'},
    BaseClassCode = {'y', {}, true, 255},
    SubClassCode = {'y', {}, true, 255},
    ProgrammingInterface = {'y', {}, true, 255}
}, {}, {})

return PCIeFunction
