-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIeDeviceRAS = {}

---@class PCIeDeviceRAS.TimeoutError
---@field TimeoutError integer
local TTimeoutError = {}
TTimeoutError.__index = TTimeoutError
TTimeoutError.group = {}

local function TTimeoutError_from_obj(obj)
    return setmetatable(obj, TTimeoutError)
end

function TTimeoutError.new(TimeoutError)
    return TTimeoutError_from_obj({TimeoutError = TimeoutError})
end
---@param obj PCIeDeviceRAS.TimeoutError
function TTimeoutError:init_from_obj(obj)
    self.TimeoutError = obj.TimeoutError
end

function TTimeoutError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTimeoutError.group)
end

TTimeoutError.from_obj = TTimeoutError_from_obj

TTimeoutError.proto_property = {'TimeoutError'}

TTimeoutError.default = {0}

TTimeoutError.struct = {{name = 'TimeoutError', is_array = false, struct = nil}}

function TTimeoutError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeoutError', self.TimeoutError, 'uint8', false, errs, need_convert)

    TTimeoutError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTimeoutError.proto_property, errs, need_convert)
    return self
end

function TTimeoutError:unpack(_)
    return self.TimeoutError
end

PCIeDeviceRAS.TimeoutError = TTimeoutError

---@class PCIeDeviceRAS.CorrectableErrorOverfrequencyCount
---@field CorrectableErrorOverfrequencyCount integer
local TCorrectableErrorOverfrequencyCount = {}
TCorrectableErrorOverfrequencyCount.__index = TCorrectableErrorOverfrequencyCount
TCorrectableErrorOverfrequencyCount.group = {}

local function TCorrectableErrorOverfrequencyCount_from_obj(obj)
    return setmetatable(obj, TCorrectableErrorOverfrequencyCount)
end

function TCorrectableErrorOverfrequencyCount.new(CorrectableErrorOverfrequencyCount)
    return TCorrectableErrorOverfrequencyCount_from_obj({
        CorrectableErrorOverfrequencyCount = CorrectableErrorOverfrequencyCount
    })
end
---@param obj PCIeDeviceRAS.CorrectableErrorOverfrequencyCount
function TCorrectableErrorOverfrequencyCount:init_from_obj(obj)
    self.CorrectableErrorOverfrequencyCount = obj.CorrectableErrorOverfrequencyCount
end

function TCorrectableErrorOverfrequencyCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCorrectableErrorOverfrequencyCount.group)
end

TCorrectableErrorOverfrequencyCount.from_obj = TCorrectableErrorOverfrequencyCount_from_obj

TCorrectableErrorOverfrequencyCount.proto_property = {'CorrectableErrorOverfrequencyCount'}

TCorrectableErrorOverfrequencyCount.default = {0}

TCorrectableErrorOverfrequencyCount.struct = {
    {name = 'CorrectableErrorOverfrequencyCount', is_array = false, struct = nil}
}

function TCorrectableErrorOverfrequencyCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CorrectableErrorOverfrequencyCount', self.CorrectableErrorOverfrequencyCount, 'uint32',
        false, errs, need_convert)

    TCorrectableErrorOverfrequencyCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCorrectableErrorOverfrequencyCount.proto_property, errs, need_convert)
    return self
end

function TCorrectableErrorOverfrequencyCount:unpack(_)
    return self.CorrectableErrorOverfrequencyCount
end

PCIeDeviceRAS.CorrectableErrorOverfrequencyCount = TCorrectableErrorOverfrequencyCount

---@class PCIeDeviceRAS.UnsupportedRequestCount
---@field UnsupportedRequestCount integer
local TUnsupportedRequestCount = {}
TUnsupportedRequestCount.__index = TUnsupportedRequestCount
TUnsupportedRequestCount.group = {}

local function TUnsupportedRequestCount_from_obj(obj)
    return setmetatable(obj, TUnsupportedRequestCount)
end

function TUnsupportedRequestCount.new(UnsupportedRequestCount)
    return TUnsupportedRequestCount_from_obj({UnsupportedRequestCount = UnsupportedRequestCount})
end
---@param obj PCIeDeviceRAS.UnsupportedRequestCount
function TUnsupportedRequestCount:init_from_obj(obj)
    self.UnsupportedRequestCount = obj.UnsupportedRequestCount
end

function TUnsupportedRequestCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnsupportedRequestCount.group)
end

TUnsupportedRequestCount.from_obj = TUnsupportedRequestCount_from_obj

TUnsupportedRequestCount.proto_property = {'UnsupportedRequestCount'}

TUnsupportedRequestCount.default = {0}

TUnsupportedRequestCount.struct = {{name = 'UnsupportedRequestCount', is_array = false, struct = nil}}

function TUnsupportedRequestCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UnsupportedRequestCount', self.UnsupportedRequestCount, 'uint32', false, errs,
        need_convert)

    TUnsupportedRequestCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnsupportedRequestCount.proto_property, errs, need_convert)
    return self
end

function TUnsupportedRequestCount:unpack(_)
    return self.UnsupportedRequestCount
end

PCIeDeviceRAS.UnsupportedRequestCount = TUnsupportedRequestCount

---@class PCIeDeviceRAS.BadTLPCount
---@field BadTLPCount integer
local TBadTLPCount = {}
TBadTLPCount.__index = TBadTLPCount
TBadTLPCount.group = {}

local function TBadTLPCount_from_obj(obj)
    return setmetatable(obj, TBadTLPCount)
end

function TBadTLPCount.new(BadTLPCount)
    return TBadTLPCount_from_obj({BadTLPCount = BadTLPCount})
end
---@param obj PCIeDeviceRAS.BadTLPCount
function TBadTLPCount:init_from_obj(obj)
    self.BadTLPCount = obj.BadTLPCount
end

function TBadTLPCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBadTLPCount.group)
end

TBadTLPCount.from_obj = TBadTLPCount_from_obj

TBadTLPCount.proto_property = {'BadTLPCount'}

TBadTLPCount.default = {0}

TBadTLPCount.struct = {{name = 'BadTLPCount', is_array = false, struct = nil}}

function TBadTLPCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BadTLPCount', self.BadTLPCount, 'uint32', false, errs, need_convert)

    TBadTLPCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBadTLPCount.proto_property, errs, need_convert)
    return self
end

function TBadTLPCount:unpack(_)
    return self.BadTLPCount
end

PCIeDeviceRAS.BadTLPCount = TBadTLPCount

---@class PCIeDeviceRAS.BadDLLPCount
---@field BadDLLPCount integer
local TBadDLLPCount = {}
TBadDLLPCount.__index = TBadDLLPCount
TBadDLLPCount.group = {}

local function TBadDLLPCount_from_obj(obj)
    return setmetatable(obj, TBadDLLPCount)
end

function TBadDLLPCount.new(BadDLLPCount)
    return TBadDLLPCount_from_obj({BadDLLPCount = BadDLLPCount})
end
---@param obj PCIeDeviceRAS.BadDLLPCount
function TBadDLLPCount:init_from_obj(obj)
    self.BadDLLPCount = obj.BadDLLPCount
end

function TBadDLLPCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBadDLLPCount.group)
end

TBadDLLPCount.from_obj = TBadDLLPCount_from_obj

TBadDLLPCount.proto_property = {'BadDLLPCount'}

TBadDLLPCount.default = {0}

TBadDLLPCount.struct = {{name = 'BadDLLPCount', is_array = false, struct = nil}}

function TBadDLLPCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BadDLLPCount', self.BadDLLPCount, 'uint32', false, errs, need_convert)

    TBadDLLPCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBadDLLPCount.proto_property, errs, need_convert)
    return self
end

function TBadDLLPCount:unpack(_)
    return self.BadDLLPCount
end

PCIeDeviceRAS.BadDLLPCount = TBadDLLPCount

---@class PCIeDeviceRAS.NonFatalErrorCount
---@field NonFatalErrorCount integer
local TNonFatalErrorCount = {}
TNonFatalErrorCount.__index = TNonFatalErrorCount
TNonFatalErrorCount.group = {}

local function TNonFatalErrorCount_from_obj(obj)
    return setmetatable(obj, TNonFatalErrorCount)
end

function TNonFatalErrorCount.new(NonFatalErrorCount)
    return TNonFatalErrorCount_from_obj({NonFatalErrorCount = NonFatalErrorCount})
end
---@param obj PCIeDeviceRAS.NonFatalErrorCount
function TNonFatalErrorCount:init_from_obj(obj)
    self.NonFatalErrorCount = obj.NonFatalErrorCount
end

function TNonFatalErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNonFatalErrorCount.group)
end

TNonFatalErrorCount.from_obj = TNonFatalErrorCount_from_obj

TNonFatalErrorCount.proto_property = {'NonFatalErrorCount'}

TNonFatalErrorCount.default = {0}

TNonFatalErrorCount.struct = {{name = 'NonFatalErrorCount', is_array = false, struct = nil}}

function TNonFatalErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NonFatalErrorCount', self.NonFatalErrorCount, 'uint32', false, errs, need_convert)

    TNonFatalErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNonFatalErrorCount.proto_property, errs, need_convert)
    return self
end

function TNonFatalErrorCount:unpack(_)
    return self.NonFatalErrorCount
end

PCIeDeviceRAS.NonFatalErrorCount = TNonFatalErrorCount

---@class PCIeDeviceRAS.FatalErrorCount
---@field FatalErrorCount integer
local TFatalErrorCount = {}
TFatalErrorCount.__index = TFatalErrorCount
TFatalErrorCount.group = {}

local function TFatalErrorCount_from_obj(obj)
    return setmetatable(obj, TFatalErrorCount)
end

function TFatalErrorCount.new(FatalErrorCount)
    return TFatalErrorCount_from_obj({FatalErrorCount = FatalErrorCount})
end
---@param obj PCIeDeviceRAS.FatalErrorCount
function TFatalErrorCount:init_from_obj(obj)
    self.FatalErrorCount = obj.FatalErrorCount
end

function TFatalErrorCount:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFatalErrorCount.group)
end

TFatalErrorCount.from_obj = TFatalErrorCount_from_obj

TFatalErrorCount.proto_property = {'FatalErrorCount'}

TFatalErrorCount.default = {0}

TFatalErrorCount.struct = {{name = 'FatalErrorCount', is_array = false, struct = nil}}

function TFatalErrorCount:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FatalErrorCount', self.FatalErrorCount, 'uint32', false, errs, need_convert)

    TFatalErrorCount:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFatalErrorCount.proto_property, errs, need_convert)
    return self
end

function TFatalErrorCount:unpack(_)
    return self.FatalErrorCount
end

PCIeDeviceRAS.FatalErrorCount = TFatalErrorCount

---@class PCIeDeviceRAS.SystemError
---@field SystemError integer
local TSystemError = {}
TSystemError.__index = TSystemError
TSystemError.group = {}

local function TSystemError_from_obj(obj)
    return setmetatable(obj, TSystemError)
end

function TSystemError.new(SystemError)
    return TSystemError_from_obj({SystemError = SystemError})
end
---@param obj PCIeDeviceRAS.SystemError
function TSystemError:init_from_obj(obj)
    self.SystemError = obj.SystemError
end

function TSystemError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemError.group)
end

TSystemError.from_obj = TSystemError_from_obj

TSystemError.proto_property = {'SystemError'}

TSystemError.default = {0}

TSystemError.struct = {{name = 'SystemError', is_array = false, struct = nil}}

function TSystemError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemError', self.SystemError, 'uint8', true, errs, need_convert)

    TSystemError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemError.proto_property, errs, need_convert)
    return self
end

function TSystemError:unpack(_)
    return self.SystemError
end

PCIeDeviceRAS.SystemError = TSystemError

---@class PCIeDeviceRAS.ParityError
---@field ParityError integer
local TParityError = {}
TParityError.__index = TParityError
TParityError.group = {}

local function TParityError_from_obj(obj)
    return setmetatable(obj, TParityError)
end

function TParityError.new(ParityError)
    return TParityError_from_obj({ParityError = ParityError})
end
---@param obj PCIeDeviceRAS.ParityError
function TParityError:init_from_obj(obj)
    self.ParityError = obj.ParityError
end

function TParityError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TParityError.group)
end

TParityError.from_obj = TParityError_from_obj

TParityError.proto_property = {'ParityError'}

TParityError.default = {0}

TParityError.struct = {{name = 'ParityError', is_array = false, struct = nil}}

function TParityError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ParityError', self.ParityError, 'uint8', true, errs, need_convert)

    TParityError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TParityError.proto_property, errs, need_convert)
    return self
end

function TParityError:unpack(_)
    return self.ParityError
end

PCIeDeviceRAS.ParityError = TParityError

---@class PCIeDeviceRAS.FatalError
---@field FatalError integer
local TFatalError = {}
TFatalError.__index = TFatalError
TFatalError.group = {}

local function TFatalError_from_obj(obj)
    return setmetatable(obj, TFatalError)
end

function TFatalError.new(FatalError)
    return TFatalError_from_obj({FatalError = FatalError})
end
---@param obj PCIeDeviceRAS.FatalError
function TFatalError:init_from_obj(obj)
    self.FatalError = obj.FatalError
end

function TFatalError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFatalError.group)
end

TFatalError.from_obj = TFatalError_from_obj

TFatalError.proto_property = {'FatalError'}

TFatalError.default = {0}

TFatalError.struct = {{name = 'FatalError', is_array = false, struct = nil}}

function TFatalError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FatalError', self.FatalError, 'uint8', true, errs, need_convert)

    TFatalError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFatalError.proto_property, errs, need_convert)
    return self
end

function TFatalError:unpack(_)
    return self.FatalError
end

PCIeDeviceRAS.FatalError = TFatalError

---@class PCIeDeviceRAS.UncorrectableError
---@field UncorrectableError integer
local TUncorrectableError = {}
TUncorrectableError.__index = TUncorrectableError
TUncorrectableError.group = {}

local function TUncorrectableError_from_obj(obj)
    return setmetatable(obj, TUncorrectableError)
end

function TUncorrectableError.new(UncorrectableError)
    return TUncorrectableError_from_obj({UncorrectableError = UncorrectableError})
end
---@param obj PCIeDeviceRAS.UncorrectableError
function TUncorrectableError:init_from_obj(obj)
    self.UncorrectableError = obj.UncorrectableError
end

function TUncorrectableError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUncorrectableError.group)
end

TUncorrectableError.from_obj = TUncorrectableError_from_obj

TUncorrectableError.proto_property = {'UncorrectableError'}

TUncorrectableError.default = {0}

TUncorrectableError.struct = {{name = 'UncorrectableError', is_array = false, struct = nil}}

function TUncorrectableError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UncorrectableError', self.UncorrectableError, 'uint8', true, errs, need_convert)

    TUncorrectableError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUncorrectableError.proto_property, errs, need_convert)
    return self
end

function TUncorrectableError:unpack(_)
    return self.UncorrectableError
end

PCIeDeviceRAS.UncorrectableError = TUncorrectableError

---@class PCIeDeviceRAS.CorrectableError
---@field CorrectableError integer
local TCorrectableError = {}
TCorrectableError.__index = TCorrectableError
TCorrectableError.group = {}

local function TCorrectableError_from_obj(obj)
    return setmetatable(obj, TCorrectableError)
end

function TCorrectableError.new(CorrectableError)
    return TCorrectableError_from_obj({CorrectableError = CorrectableError})
end
---@param obj PCIeDeviceRAS.CorrectableError
function TCorrectableError:init_from_obj(obj)
    self.CorrectableError = obj.CorrectableError
end

function TCorrectableError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCorrectableError.group)
end

TCorrectableError.from_obj = TCorrectableError_from_obj

TCorrectableError.proto_property = {'CorrectableError'}

TCorrectableError.default = {0}

TCorrectableError.struct = {{name = 'CorrectableError', is_array = false, struct = nil}}

function TCorrectableError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CorrectableError', self.CorrectableError, 'uint8', true, errs, need_convert)

    TCorrectableError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCorrectableError.proto_property, errs, need_convert)
    return self
end

function TCorrectableError:unpack(_)
    return self.CorrectableError
end

PCIeDeviceRAS.CorrectableError = TCorrectableError

PCIeDeviceRAS.interface = mdb.register_interface('bmc.kepler.Systems.PCIeDevices.PCIeDevice.RAS', {
    CorrectableError = {'y', nil, true, nil},
    UncorrectableError = {'y', nil, true, nil},
    FatalError = {'y', nil, true, nil},
    ParityError = {'y', nil, true, nil},
    SystemError = {'y', nil, true, nil},
    FatalErrorCount = {'u', {}, false, nil},
    NonFatalErrorCount = {'u', {}, false, nil},
    BadDLLPCount = {'u', {}, false, nil},
    BadTLPCount = {'u', {}, false, nil},
    UnsupportedRequestCount = {'u', {}, false, nil},
    CorrectableErrorOverfrequencyCount = {'u', nil, false, nil},
    TimeoutError = {'y', nil, false, nil}
}, {}, {})

return PCIeDeviceRAS
