-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NPU = {}

---@class NPU.DumpLogRsp
---@field TaskId integer
local TDumpLogRsp = {}
TDumpLogRsp.__index = TDumpLogRsp
TDumpLogRsp.group = {}

local function TDumpLogRsp_from_obj(obj)
    return setmetatable(obj, TDumpLogRsp)
end

function TDumpLogRsp.new(TaskId)
    return TDumpLogRsp_from_obj({TaskId = TaskId})
end
---@param obj NPU.DumpLogRsp
function TDumpLogRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpLogRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpLogRsp.group)
end

TDumpLogRsp.from_obj = TDumpLogRsp_from_obj

TDumpLogRsp.proto_property = {'TaskId'}

TDumpLogRsp.default = {0}

TDumpLogRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpLogRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDumpLogRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpLogRsp.proto_property, errs, need_convert)
    return self
end

function TDumpLogRsp:unpack(_)
    return self.TaskId
end

NPU.DumpLogRsp = TDumpLogRsp

---@class NPU.DumpLogReq
---@field LogType string[]
---@field OutputFilePath string
local TDumpLogReq = {}
TDumpLogReq.__index = TDumpLogReq
TDumpLogReq.group = {}

local function TDumpLogReq_from_obj(obj)
    return setmetatable(obj, TDumpLogReq)
end

function TDumpLogReq.new(LogType, OutputFilePath)
    return TDumpLogReq_from_obj({LogType = LogType, OutputFilePath = OutputFilePath})
end
---@param obj NPU.DumpLogReq
function TDumpLogReq:init_from_obj(obj)
    self.LogType = obj.LogType
    self.OutputFilePath = obj.OutputFilePath
end

function TDumpLogReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpLogReq.group)
end

TDumpLogReq.from_obj = TDumpLogReq_from_obj

TDumpLogReq.proto_property = {'LogType', 'OutputFilePath'}

TDumpLogReq.default = {{}, ''}

TDumpLogReq.struct = {
    {name = 'LogType', is_array = true, struct = nil}, {name = 'OutputFilePath', is_array = false, struct = nil}
}

function TDumpLogReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'LogType', self.LogType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'OutputFilePath', self.OutputFilePath, 'string', false, errs, need_convert)

    TDumpLogReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpLogReq.proto_property, errs, need_convert)
    return self
end

function TDumpLogReq:unpack(_)
    return self.LogType, self.OutputFilePath
end

NPU.DumpLogReq = TDumpLogReq

---@class NPU.GetEccInfoRsp
---@field SingleBitEcc string
---@field MultiBitEcc string
---@field SingleBitIsolatedPages string
---@field MultiBitIsolatedPages string
local TGetEccInfoRsp = {}
TGetEccInfoRsp.__index = TGetEccInfoRsp
TGetEccInfoRsp.group = {}

local function TGetEccInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetEccInfoRsp)
end

function TGetEccInfoRsp.new(SingleBitEcc, MultiBitEcc, SingleBitIsolatedPages, MultiBitIsolatedPages)
    return TGetEccInfoRsp_from_obj({
        SingleBitEcc = SingleBitEcc,
        MultiBitEcc = MultiBitEcc,
        SingleBitIsolatedPages = SingleBitIsolatedPages,
        MultiBitIsolatedPages = MultiBitIsolatedPages
    })
end
---@param obj NPU.GetEccInfoRsp
function TGetEccInfoRsp:init_from_obj(obj)
    self.SingleBitEcc = obj.SingleBitEcc
    self.MultiBitEcc = obj.MultiBitEcc
    self.SingleBitIsolatedPages = obj.SingleBitIsolatedPages
    self.MultiBitIsolatedPages = obj.MultiBitIsolatedPages
end

function TGetEccInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEccInfoRsp.group)
end

TGetEccInfoRsp.from_obj = TGetEccInfoRsp_from_obj

TGetEccInfoRsp.proto_property = {'SingleBitEcc', 'MultiBitEcc', 'SingleBitIsolatedPages', 'MultiBitIsolatedPages'}

TGetEccInfoRsp.default = {'', '', '', ''}

TGetEccInfoRsp.struct = {
    {name = 'SingleBitEcc', is_array = false, struct = nil}, {name = 'MultiBitEcc', is_array = false, struct = nil},
    {name = 'SingleBitIsolatedPages', is_array = false, struct = nil},
    {name = 'MultiBitIsolatedPages', is_array = false, struct = nil}
}

function TGetEccInfoRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SingleBitEcc', self.SingleBitEcc, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'MultiBitEcc', self.MultiBitEcc, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SingleBitIsolatedPages', self.SingleBitIsolatedPages, 'string', false, errs,
        need_convert)
    validate.Optional(prefix .. 'MultiBitIsolatedPages', self.MultiBitIsolatedPages, 'string', false, errs, need_convert)

    TGetEccInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEccInfoRsp.proto_property, errs, need_convert)
    return self
end

function TGetEccInfoRsp:unpack(_)
    return self.SingleBitEcc, self.MultiBitEcc, self.SingleBitIsolatedPages, self.MultiBitIsolatedPages
end

NPU.GetEccInfoRsp = TGetEccInfoRsp

---@class NPU.GetEccInfoReq
---@field Id integer
local TGetEccInfoReq = {}
TGetEccInfoReq.__index = TGetEccInfoReq
TGetEccInfoReq.group = {}

local function TGetEccInfoReq_from_obj(obj)
    return setmetatable(obj, TGetEccInfoReq)
end

function TGetEccInfoReq.new(Id)
    return TGetEccInfoReq_from_obj({Id = Id})
end
---@param obj NPU.GetEccInfoReq
function TGetEccInfoReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TGetEccInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEccInfoReq.group)
end

TGetEccInfoReq.from_obj = TGetEccInfoReq_from_obj

TGetEccInfoReq.proto_property = {'Id'}

TGetEccInfoReq.default = {0}

TGetEccInfoReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TGetEccInfoReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TGetEccInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEccInfoReq.proto_property, errs, need_convert)
    return self
end

function TGetEccInfoReq:unpack(_)
    return self.Id
end

NPU.GetEccInfoReq = TGetEccInfoReq

NPU.interface = mdb.register_interface('bmc.kepler.Systems.Processor.NPU', {
    TotalMemoryKiB = {'u', nil, true, nil},
    MemoryUsageKiB = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    MemoryFreeKiB = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    CapabilitySupportMask = {'u', nil, true, nil},
    MemoryCapacityKiB = {'u', nil, true, nil},
    MultiBitEcc = {'s', {['emitsChangedSignal'] = 'true'}, true, nil},
    SingleBitEcc = {'s', {['emitsChangedSignal'] = 'true'}, true, nil},
    AiCPUUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    HBMBWUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    MemBWUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    HBMUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    MemUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    AiCoreUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    AiCoreMaxSpeedMHz = {'q', nil, true, nil},
    AiCoreCurrentSpeedMHz = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    CtrlCPUUsagePercent = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    ComputeCapability = {'s', nil, true, nil},
    NimBusTemp = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    AiCoreTemp = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    HBMTemp = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    PowerOn = {'y', nil, true, nil},
    PowerState = {'s', nil, true, nil},
    PowerCapacityWatts = {'u', nil, true, nil},
    PowerConsumedWatts = {'q', nil, true, nil},
    Volt = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    Power = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    VRDChipTemp = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    BDF = {'s', nil, true, nil},
    RootBDF = {'s', nil, true, nil},
    MemoryBandWidth = {'u', nil, true, nil},
    ReadingCelsius = {'q', {['emitsChangedSignal'] = 'true'}, true, nil},
    Ierr = {'y', nil, true, nil},
    PredictiveFault = {'y', nil, false, nil},
    DiagnosticFault = {'y', nil, false, nil},
    ECCAlarmStatus = {'y', nil, true, nil},
    IErrFlag = {'u', nil, true, nil},
    VendorID = {'q', nil, true, nil},
    Version = {'s', nil, true, nil},
    DriverVersion = {'s', nil, true, nil},
    FaultCode = {'s', nil, true, nil},
    PowerCapWatts = {'q', nil, true, nil},
    TotalCores = {'u', nil, true, nil},
    Location = {'s', nil, true, nil},
    FlashIds = {'at', nil, true, nil},
    Slot = {'y', nil, true, nil},
    HBMSingleBitIsolatedPages = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    HBMMultiBitIsolatedPages = {'u', {['emitsChangedSignal'] = 'true'}, true, nil}
}, {
    GetEccInfo = {'a{ss}y', 'ssss', TGetEccInfoReq, TGetEccInfoRsp},
    DumpLog = {'a{ss}ass', 'u', TDumpLogReq, TDumpLogRsp}
}, {})

return NPU
