-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local CPU = {}

CPU.interface = mdb.register_interface('bmc.kepler.Systems.Processor.CPU', {
    PhysicalId = {'y', nil, true, nil},
    LogicalId = {'y', nil, true, nil},
    MaxSpeedMHz = {'u', nil, true, nil},
    CurrentSpeedMHz = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    ProcessorID = {'u', nil, true, nil},
    ProcessorIDString = {'s', nil, true, nil},
    TotalCores = {'u', nil, true, nil},
    TotalEnabledCores = {'u', nil, true, nil},
    TotalThreads = {'u', nil, true, nil},
    L1Cache = {'u', nil, true, nil},
    L2Cache = {'u', nil, true, nil},
    L3Cache = {'u', nil, true, nil},
    Characteristics = {'s', nil, true, nil},
    TemperatureCelsius = {'d', {['emitsChangedSignal'] = 'true'}, false, nil},
    MaxMemoryTemperatureCelsius = {'d', {['emitsChangedSignal'] = 'true'}, false, nil},
    MaxMemoryTSensorTemperatureCelsius = {'n', {['emitsChangedSignal'] = 'true'}, false, nil},
    MaxMemoryTemperatureName = {'s', nil, false, nil},
    DiagnosticFault = {'y', nil, false, 0},
    PredictiveFault = {'y', nil, false, 0},
    CATERR = {'y', nil, true, 0},
    DeviceLocator = {'s', nil, true, nil},
    ProcessorHot = {'y', nil, true, nil},
    Enabled = {'b', nil, true, nil},
    PowerGood = {'y', nil, true, nil},
    IsMemoryPresence = {'y', nil, true, nil},
    PowerWatt = {'d', {['emitsChangedSignal'] = 'true'}, true, nil},
    TotalEnabledThreads = {'u', {['emitsChangedSignal'] = 'true'}, true, nil},
    SilkText = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    BaseSpeedMHz = {'u', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {}, {})

return CPU
