--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local WritePCIeVPDInfoToBmc = {}

---@class PcieDevice.WritePCIeVPDInfoToBmcReq
---@field CardType integer
---@field PCIeSlotNumber integer
---@field BusNumber integer
---@field DeviceNumber integer
---@field FunctionNumber integer
---@field VPDItemData string
local TWritePCIeVPDInfoToBmcReq = {}
TWritePCIeVPDInfoToBmcReq.__index = TWritePCIeVPDInfoToBmcReq
TWritePCIeVPDInfoToBmcReq.group = {}

local function TWritePCIeVPDInfoToBmcReq_from_obj(obj)
    return setmetatable(obj, TWritePCIeVPDInfoToBmcReq)
end

function TWritePCIeVPDInfoToBmcReq.new(CardType, PCIeSlotNumber, BusNumber, DeviceNumber, FunctionNumber, VPDItemData)
    return TWritePCIeVPDInfoToBmcReq_from_obj({
        CardType = CardType,
        PCIeSlotNumber = PCIeSlotNumber,
        BusNumber = BusNumber,
        DeviceNumber = DeviceNumber,
        FunctionNumber = FunctionNumber,
        VPDItemData = VPDItemData
    })
end
---@param obj PcieDevice.WritePCIeVPDInfoToBmcReq
function TWritePCIeVPDInfoToBmcReq:init_from_obj(obj)
    self.CardType = obj.CardType
    self.PCIeSlotNumber = obj.PCIeSlotNumber
    self.BusNumber = obj.BusNumber
    self.DeviceNumber = obj.DeviceNumber
    self.FunctionNumber = obj.FunctionNumber
    self.VPDItemData = obj.VPDItemData
end

function TWritePCIeVPDInfoToBmcReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePCIeVPDInfoToBmcReq.group)
end

TWritePCIeVPDInfoToBmcReq.from_obj = TWritePCIeVPDInfoToBmcReq_from_obj

TWritePCIeVPDInfoToBmcReq.proto_property = {
    'CardType', 'PCIeSlotNumber', 'BusNumber', 'DeviceNumber', 'FunctionNumber', 'VPDItemData'
}

TWritePCIeVPDInfoToBmcReq.default = {0, 0, 0, 0, 0, ''}

TWritePCIeVPDInfoToBmcReq.struct = {
    {name = 'CardType', is_array = false, struct = nil}, {name = 'PCIeSlotNumber', is_array = false, struct = nil},
    {name = 'BusNumber', is_array = false, struct = nil}, {name = 'DeviceNumber', is_array = false, struct = nil},
    {name = 'FunctionNumber', is_array = false, struct = nil}, {name = 'VPDItemData', is_array = false, struct = nil}
}

function TWritePCIeVPDInfoToBmcReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardType', self.CardType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PCIeSlotNumber', self.PCIeSlotNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'BusNumber', self.BusNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'FunctionNumber', self.FunctionNumber, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'VPDItemData', self.VPDItemData, 'string', false, errs, need_convert)

    TWritePCIeVPDInfoToBmcReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePCIeVPDInfoToBmcReq.proto_property, errs, need_convert)
    return self
end

function TWritePCIeVPDInfoToBmcReq:unpack(_)
    return self.CardType, self.PCIeSlotNumber, self.BusNumber, self.DeviceNumber, self.FunctionNumber, self.VPDItemData
end

WritePCIeVPDInfoToBmc.WritePCIeVPDInfoToBmcReq = TWritePCIeVPDInfoToBmcReq

---@class PcieDevice.WritePCIeVPDInfoToBmcRsp
---@field CompletionCode integer
local TWritePCIeVPDInfoToBmcRsp = {}
TWritePCIeVPDInfoToBmcRsp.__index = TWritePCIeVPDInfoToBmcRsp
TWritePCIeVPDInfoToBmcRsp.group = {}

local function TWritePCIeVPDInfoToBmcRsp_from_obj(obj)
    return setmetatable(obj, TWritePCIeVPDInfoToBmcRsp)
end

function TWritePCIeVPDInfoToBmcRsp.new(CompletionCode)
    return TWritePCIeVPDInfoToBmcRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj PcieDevice.WritePCIeVPDInfoToBmcRsp
function TWritePCIeVPDInfoToBmcRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TWritePCIeVPDInfoToBmcRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWritePCIeVPDInfoToBmcRsp.group)
end

TWritePCIeVPDInfoToBmcRsp.from_obj = TWritePCIeVPDInfoToBmcRsp_from_obj

TWritePCIeVPDInfoToBmcRsp.proto_property = {'CompletionCode'}

TWritePCIeVPDInfoToBmcRsp.default = {0}

TWritePCIeVPDInfoToBmcRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TWritePCIeVPDInfoToBmcRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TWritePCIeVPDInfoToBmcRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWritePCIeVPDInfoToBmcRsp.proto_property, errs, need_convert)
    return self
end

function TWritePCIeVPDInfoToBmcRsp:unpack(_)
    return self.CompletionCode
end

WritePCIeVPDInfoToBmc.WritePCIeVPDInfoToBmcRsp = TWritePCIeVPDInfoToBmcRsp

return WritePCIeVPDInfoToBmc
