--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local UpdateIntegratedPcieConfig = {}

---@class PcieDevice.UpdateIntegratedPcieConfigReq
---@field ManuId integer
---@field DataLen integer
---@field Tail string
local TUpdateIntegratedPcieConfigReq = {}
TUpdateIntegratedPcieConfigReq.__index = TUpdateIntegratedPcieConfigReq
TUpdateIntegratedPcieConfigReq.group = {}

local function TUpdateIntegratedPcieConfigReq_from_obj(obj)
    return setmetatable(obj, TUpdateIntegratedPcieConfigReq)
end

function TUpdateIntegratedPcieConfigReq.new(ManuId, DataLen, Tail)
    return TUpdateIntegratedPcieConfigReq_from_obj({ManuId = ManuId, DataLen = DataLen, Tail = Tail})
end
---@param obj PcieDevice.UpdateIntegratedPcieConfigReq
function TUpdateIntegratedPcieConfigReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
    self.DataLen = obj.DataLen
    self.Tail = obj.Tail
end

function TUpdateIntegratedPcieConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateIntegratedPcieConfigReq.group)
end

TUpdateIntegratedPcieConfigReq.from_obj = TUpdateIntegratedPcieConfigReq_from_obj

TUpdateIntegratedPcieConfigReq.proto_property = {'ManuId', 'DataLen', 'Tail'}

TUpdateIntegratedPcieConfigReq.default = {0, 0, ''}

TUpdateIntegratedPcieConfigReq.struct = {
    {name = 'ManuId', is_array = false, struct = nil}, {name = 'DataLen', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TUpdateIntegratedPcieConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'DataLen', self.DataLen, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TUpdateIntegratedPcieConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateIntegratedPcieConfigReq.proto_property, errs, need_convert)
    return self
end

function TUpdateIntegratedPcieConfigReq:unpack(_)
    return self.ManuId, self.DataLen, self.Tail
end

UpdateIntegratedPcieConfig.UpdateIntegratedPcieConfigReq = TUpdateIntegratedPcieConfigReq

---@class PcieDevice.UpdateIntegratedPcieConfigRsp
---@field CompletionCode integer
---@field ManuId integer
local TUpdateIntegratedPcieConfigRsp = {}
TUpdateIntegratedPcieConfigRsp.__index = TUpdateIntegratedPcieConfigRsp
TUpdateIntegratedPcieConfigRsp.group = {}

local function TUpdateIntegratedPcieConfigRsp_from_obj(obj)
    return setmetatable(obj, TUpdateIntegratedPcieConfigRsp)
end

function TUpdateIntegratedPcieConfigRsp.new(CompletionCode, ManuId)
    return TUpdateIntegratedPcieConfigRsp_from_obj({CompletionCode = CompletionCode, ManuId = ManuId})
end
---@param obj PcieDevice.UpdateIntegratedPcieConfigRsp
function TUpdateIntegratedPcieConfigRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
end

function TUpdateIntegratedPcieConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpdateIntegratedPcieConfigRsp.group)
end

TUpdateIntegratedPcieConfigRsp.from_obj = TUpdateIntegratedPcieConfigRsp_from_obj

TUpdateIntegratedPcieConfigRsp.proto_property = {'CompletionCode', 'ManuId'}

TUpdateIntegratedPcieConfigRsp.default = {0, 0}

TUpdateIntegratedPcieConfigRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil}
}

function TUpdateIntegratedPcieConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)

    TUpdateIntegratedPcieConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpdateIntegratedPcieConfigRsp.proto_property, errs, need_convert)
    return self
end

function TUpdateIntegratedPcieConfigRsp:unpack(_)
    return self.CompletionCode, self.ManuId
end

UpdateIntegratedPcieConfig.UpdateIntegratedPcieConfigRsp = TUpdateIntegratedPcieConfigRsp

return UpdateIntegratedPcieConfig
