--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPCIeDiskBDFs = {}

---@class PcieDevice.SetPCIeDiskBDFsReq
---@field ManufactureId integer
---@field Number integer
---@field Length integer
---@field Data string
local TSetPCIeDiskBDFsReq = {}
TSetPCIeDiskBDFsReq.__index = TSetPCIeDiskBDFsReq
TSetPCIeDiskBDFsReq.group = {}

local function TSetPCIeDiskBDFsReq_from_obj(obj)
    return setmetatable(obj, TSetPCIeDiskBDFsReq)
end

function TSetPCIeDiskBDFsReq.new(ManufactureId, Number, Length, Data)
    return TSetPCIeDiskBDFsReq_from_obj({ManufactureId = ManufactureId, Number = Number, Length = Length, Data = Data})
end
---@param obj PcieDevice.SetPCIeDiskBDFsReq
function TSetPCIeDiskBDFsReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Number = obj.Number
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetPCIeDiskBDFsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCIeDiskBDFsReq.group)
end

TSetPCIeDiskBDFsReq.from_obj = TSetPCIeDiskBDFsReq_from_obj

TSetPCIeDiskBDFsReq.proto_property = {'ManufactureId', 'Number', 'Length', 'Data'}

TSetPCIeDiskBDFsReq.default = {0, 0, 0, ''}

TSetPCIeDiskBDFsReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Number', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetPCIeDiskBDFsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetPCIeDiskBDFsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCIeDiskBDFsReq.proto_property, errs, need_convert)
    return self
end

function TSetPCIeDiskBDFsReq:unpack(_)
    return self.ManufactureId, self.Number, self.Length, self.Data
end

SetPCIeDiskBDFs.SetPCIeDiskBDFsReq = TSetPCIeDiskBDFsReq

---@class PcieDevice.SetPCIeDiskBDFsRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetPCIeDiskBDFsRsp = {}
TSetPCIeDiskBDFsRsp.__index = TSetPCIeDiskBDFsRsp
TSetPCIeDiskBDFsRsp.group = {}

local function TSetPCIeDiskBDFsRsp_from_obj(obj)
    return setmetatable(obj, TSetPCIeDiskBDFsRsp)
end

function TSetPCIeDiskBDFsRsp.new(CompletionCode, ManufactureId)
    return TSetPCIeDiskBDFsRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj PcieDevice.SetPCIeDiskBDFsRsp
function TSetPCIeDiskBDFsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetPCIeDiskBDFsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCIeDiskBDFsRsp.group)
end

TSetPCIeDiskBDFsRsp.from_obj = TSetPCIeDiskBDFsRsp_from_obj

TSetPCIeDiskBDFsRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetPCIeDiskBDFsRsp.default = {0, 0}

TSetPCIeDiskBDFsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetPCIeDiskBDFsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetPCIeDiskBDFsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCIeDiskBDFsRsp.proto_property, errs, need_convert)
    return self
end

function TSetPCIeDiskBDFsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetPCIeDiskBDFs.SetPCIeDiskBDFsRsp = TSetPCIeDiskBDFsRsp

return SetPCIeDiskBDFs
