--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetPCIeCardBDFs = {}

---@class PcieDevice.SetPCIeCardBDFsReq
---@field ManufactureId integer
---@field Number integer
---@field Length integer
---@field Data string
local TSetPCIeCardBDFsReq = {}
TSetPCIeCardBDFsReq.__index = TSetPCIeCardBDFsReq
TSetPCIeCardBDFsReq.group = {}

local function TSetPCIeCardBDFsReq_from_obj(obj)
    return setmetatable(obj, TSetPCIeCardBDFsReq)
end

function TSetPCIeCardBDFsReq.new(ManufactureId, Number, Length, Data)
    return TSetPCIeCardBDFsReq_from_obj({ManufactureId = ManufactureId, Number = Number, Length = Length, Data = Data})
end
---@param obj PcieDevice.SetPCIeCardBDFsReq
function TSetPCIeCardBDFsReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Number = obj.Number
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetPCIeCardBDFsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCIeCardBDFsReq.group)
end

TSetPCIeCardBDFsReq.from_obj = TSetPCIeCardBDFsReq_from_obj

TSetPCIeCardBDFsReq.proto_property = {'ManufactureId', 'Number', 'Length', 'Data'}

TSetPCIeCardBDFsReq.default = {0, 0, 0, ''}

TSetPCIeCardBDFsReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Number', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetPCIeCardBDFsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetPCIeCardBDFsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCIeCardBDFsReq.proto_property, errs, need_convert)
    return self
end

function TSetPCIeCardBDFsReq:unpack(_)
    return self.ManufactureId, self.Number, self.Length, self.Data
end

SetPCIeCardBDFs.SetPCIeCardBDFsReq = TSetPCIeCardBDFsReq

---@class PcieDevice.SetPCIeCardBDFsRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetPCIeCardBDFsRsp = {}
TSetPCIeCardBDFsRsp.__index = TSetPCIeCardBDFsRsp
TSetPCIeCardBDFsRsp.group = {}

local function TSetPCIeCardBDFsRsp_from_obj(obj)
    return setmetatable(obj, TSetPCIeCardBDFsRsp)
end

function TSetPCIeCardBDFsRsp.new(CompletionCode, ManufactureId)
    return TSetPCIeCardBDFsRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj PcieDevice.SetPCIeCardBDFsRsp
function TSetPCIeCardBDFsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetPCIeCardBDFsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPCIeCardBDFsRsp.group)
end

TSetPCIeCardBDFsRsp.from_obj = TSetPCIeCardBDFsRsp_from_obj

TSetPCIeCardBDFsRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetPCIeCardBDFsRsp.default = {0, 0}

TSetPCIeCardBDFsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetPCIeCardBDFsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetPCIeCardBDFsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPCIeCardBDFsRsp.proto_property, errs, need_convert)
    return self
end

function TSetPCIeCardBDFsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetPCIeCardBDFs.SetPCIeCardBDFsRsp = TSetPCIeCardBDFsRsp

return SetPCIeCardBDFs
