--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetOCPCardBDFs = {}

---@class PcieDevice.SetOCPCardBDFsReq
---@field ManufactureId integer
---@field Number integer
---@field Length integer
---@field Data string
local TSetOCPCardBDFsReq = {}
TSetOCPCardBDFsReq.__index = TSetOCPCardBDFsReq
TSetOCPCardBDFsReq.group = {}

local function TSetOCPCardBDFsReq_from_obj(obj)
    return setmetatable(obj, TSetOCPCardBDFsReq)
end

function TSetOCPCardBDFsReq.new(ManufactureId, Number, Length, Data)
    return TSetOCPCardBDFsReq_from_obj({ManufactureId = ManufactureId, Number = Number, Length = Length, Data = Data})
end
---@param obj PcieDevice.SetOCPCardBDFsReq
function TSetOCPCardBDFsReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Number = obj.Number
    self.Length = obj.Length
    self.Data = obj.Data
end

function TSetOCPCardBDFsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOCPCardBDFsReq.group)
end

TSetOCPCardBDFsReq.from_obj = TSetOCPCardBDFsReq_from_obj

TSetOCPCardBDFsReq.proto_property = {'ManufactureId', 'Number', 'Length', 'Data'}

TSetOCPCardBDFsReq.default = {0, 0, 0, ''}

TSetOCPCardBDFsReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Number', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Data', is_array = false, struct = nil}
}

function TSetOCPCardBDFsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Number', self.Number, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSetOCPCardBDFsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOCPCardBDFsReq.proto_property, errs, need_convert)
    return self
end

function TSetOCPCardBDFsReq:unpack(_)
    return self.ManufactureId, self.Number, self.Length, self.Data
end

SetOCPCardBDFs.SetOCPCardBDFsReq = TSetOCPCardBDFsReq

---@class PcieDevice.SetOCPCardBDFsRsp
---@field CompletionCode integer
---@field ManufactureId integer
local TSetOCPCardBDFsRsp = {}
TSetOCPCardBDFsRsp.__index = TSetOCPCardBDFsRsp
TSetOCPCardBDFsRsp.group = {}

local function TSetOCPCardBDFsRsp_from_obj(obj)
    return setmetatable(obj, TSetOCPCardBDFsRsp)
end

function TSetOCPCardBDFsRsp.new(CompletionCode, ManufactureId)
    return TSetOCPCardBDFsRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId})
end
---@param obj PcieDevice.SetOCPCardBDFsRsp
function TSetOCPCardBDFsRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
end

function TSetOCPCardBDFsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetOCPCardBDFsRsp.group)
end

TSetOCPCardBDFsRsp.from_obj = TSetOCPCardBDFsRsp_from_obj

TSetOCPCardBDFsRsp.proto_property = {'CompletionCode', 'ManufactureId'}

TSetOCPCardBDFsRsp.default = {0, 0}

TSetOCPCardBDFsRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil}
}

function TSetOCPCardBDFsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TSetOCPCardBDFsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetOCPCardBDFsRsp.proto_property, errs, need_convert)
    return self
end

function TSetOCPCardBDFsRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId
end

SetOCPCardBDFs.SetOCPCardBDFsRsp = TSetOCPCardBDFsRsp

return SetOCPCardBDFs
