--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetMezzSilkName = {}

---@class PcieDevice.GetMezzSilkNameReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetMezzSilkNameReq = {}
TGetMezzSilkNameReq.__index = TGetMezzSilkNameReq
TGetMezzSilkNameReq.group = {}

local function TGetMezzSilkNameReq_from_obj(obj)
    return setmetatable(obj, TGetMezzSilkNameReq)
end

function TGetMezzSilkNameReq.new(ManufacturerId, Length, Data)
    return TGetMezzSilkNameReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj PcieDevice.GetMezzSilkNameReq
function TGetMezzSilkNameReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetMezzSilkNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMezzSilkNameReq.group)
end

TGetMezzSilkNameReq.from_obj = TGetMezzSilkNameReq_from_obj

TGetMezzSilkNameReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetMezzSilkNameReq.default = {0, 0, ''}

TGetMezzSilkNameReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetMezzSilkNameReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetMezzSilkNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMezzSilkNameReq.proto_property, errs, need_convert)
    return self
end

function TGetMezzSilkNameReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetMezzSilkName.GetMezzSilkNameReq = TGetMezzSilkNameReq

---@class PcieDevice.GetMezzSilkNameRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetMezzSilkNameRsp = {}
TGetMezzSilkNameRsp.__index = TGetMezzSilkNameRsp
TGetMezzSilkNameRsp.group = {}

local function TGetMezzSilkNameRsp_from_obj(obj)
    return setmetatable(obj, TGetMezzSilkNameRsp)
end

function TGetMezzSilkNameRsp.new(CompletionCode, ManufactureId, Data)
    return TGetMezzSilkNameRsp_from_obj({CompletionCode = CompletionCode, ManufactureId = ManufactureId, Data = Data})
end
---@param obj PcieDevice.GetMezzSilkNameRsp
function TGetMezzSilkNameRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetMezzSilkNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMezzSilkNameRsp.group)
end

TGetMezzSilkNameRsp.from_obj = TGetMezzSilkNameRsp_from_obj

TGetMezzSilkNameRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetMezzSilkNameRsp.default = {0, 0, ''}

TGetMezzSilkNameRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetMezzSilkNameRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetMezzSilkNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMezzSilkNameRsp.proto_property, errs, need_convert)
    return self
end

function TGetMezzSilkNameRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetMezzSilkName.GetMezzSilkNameRsp = TGetMezzSilkNameRsp

return GetMezzSilkName
