-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeSlot = {}

---@class MPCIeSlot.PowerOnSwitch
---@field PowerOnSwitch integer
local TPowerOnSwitch = {}
TPowerOnSwitch.__index = TPowerOnSwitch
TPowerOnSwitch.group = {}

local function TPowerOnSwitch_from_obj(obj)
    return setmetatable(obj, TPowerOnSwitch)
end

function TPowerOnSwitch.new(PowerOnSwitch)
    return TPowerOnSwitch_from_obj({PowerOnSwitch = PowerOnSwitch})
end
---@param obj MPCIeSlot.PowerOnSwitch
function TPowerOnSwitch:init_from_obj(obj)
    self.PowerOnSwitch = obj.PowerOnSwitch
end

function TPowerOnSwitch:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerOnSwitch.group)
end

TPowerOnSwitch.from_obj = TPowerOnSwitch_from_obj

TPowerOnSwitch.proto_property = {'PowerOnSwitch'}

TPowerOnSwitch.default = {0}

TPowerOnSwitch.struct = {{name = 'PowerOnSwitch', is_array = false, struct = nil}}

function TPowerOnSwitch:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerOnSwitch', self.PowerOnSwitch, 'uint8', false, errs, need_convert)

    TPowerOnSwitch:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerOnSwitch.proto_property, errs, need_convert)
    return self
end

function TPowerOnSwitch:unpack(_)
    return self.PowerOnSwitch
end

MPCIeSlot.PowerOnSwitch = TPowerOnSwitch

---@class MPCIeSlot.ReadyToRemove
---@field ReadyToRemove integer
local TReadyToRemove = {}
TReadyToRemove.__index = TReadyToRemove
TReadyToRemove.group = {}

local function TReadyToRemove_from_obj(obj)
    return setmetatable(obj, TReadyToRemove)
end

function TReadyToRemove.new(ReadyToRemove)
    return TReadyToRemove_from_obj({ReadyToRemove = ReadyToRemove})
end
---@param obj MPCIeSlot.ReadyToRemove
function TReadyToRemove:init_from_obj(obj)
    self.ReadyToRemove = obj.ReadyToRemove
end

function TReadyToRemove:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadyToRemove.group)
end

TReadyToRemove.from_obj = TReadyToRemove_from_obj

TReadyToRemove.proto_property = {'ReadyToRemove'}

TReadyToRemove.default = {0}

TReadyToRemove.struct = {{name = 'ReadyToRemove', is_array = false, struct = nil}}

function TReadyToRemove:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadyToRemove', self.ReadyToRemove, 'uint8', false, errs, need_convert)

    TReadyToRemove:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadyToRemove.proto_property, errs, need_convert)
    return self
end

function TReadyToRemove:unpack(_)
    return self.ReadyToRemove
end

MPCIeSlot.ReadyToRemove = TReadyToRemove

return MPCIeSlot
