-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeFunctionLoadInfo = {}

---@class MPCIeFunctionLoadInfo.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId or 255})
end
---@param obj MPCIeFunctionLoadInfo.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId or 255
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

MPCIeFunctionLoadInfo.SystemId = TSystemId

---@class MPCIeFunctionLoadInfo.LogicProcessorId
---@field LogicProcessorId integer
local TLogicProcessorId = {}
TLogicProcessorId.__index = TLogicProcessorId
TLogicProcessorId.group = {}

local function TLogicProcessorId_from_obj(obj)
    return setmetatable(obj, TLogicProcessorId)
end

function TLogicProcessorId.new(LogicProcessorId)
    return TLogicProcessorId_from_obj({LogicProcessorId = LogicProcessorId or 255})
end
---@param obj MPCIeFunctionLoadInfo.LogicProcessorId
function TLogicProcessorId:init_from_obj(obj)
    self.LogicProcessorId = obj.LogicProcessorId or 255
end

function TLogicProcessorId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicProcessorId.group)
end

TLogicProcessorId.from_obj = TLogicProcessorId_from_obj

TLogicProcessorId.proto_property = {'LogicProcessorId'}

TLogicProcessorId.default = {0}

TLogicProcessorId.struct = {{name = 'LogicProcessorId', is_array = false, struct = nil}}

function TLogicProcessorId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicProcessorId', self.LogicProcessorId, 'uint8', false, errs, need_convert)

    TLogicProcessorId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicProcessorId.proto_property, errs, need_convert)
    return self
end

function TLogicProcessorId:unpack(_)
    return self.LogicProcessorId
end

MPCIeFunctionLoadInfo.LogicProcessorId = TLogicProcessorId

---@class MPCIeFunctionLoadInfo.FunctionNumber
---@field FunctionNumber integer
local TFunctionNumber = {}
TFunctionNumber.__index = TFunctionNumber
TFunctionNumber.group = {}

local function TFunctionNumber_from_obj(obj)
    return setmetatable(obj, TFunctionNumber)
end

function TFunctionNumber.new(FunctionNumber)
    return TFunctionNumber_from_obj({FunctionNumber = FunctionNumber or 255})
end
---@param obj MPCIeFunctionLoadInfo.FunctionNumber
function TFunctionNumber:init_from_obj(obj)
    self.FunctionNumber = obj.FunctionNumber or 255
end

function TFunctionNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionNumber.group)
end

TFunctionNumber.from_obj = TFunctionNumber_from_obj

TFunctionNumber.proto_property = {'FunctionNumber'}

TFunctionNumber.default = {0}

TFunctionNumber.struct = {{name = 'FunctionNumber', is_array = false, struct = nil}}

function TFunctionNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'FunctionNumber', self.FunctionNumber, 'uint8', false, errs, need_convert)

    TFunctionNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionNumber.proto_property, errs, need_convert)
    return self
end

function TFunctionNumber:unpack(_)
    return self.FunctionNumber
end

MPCIeFunctionLoadInfo.FunctionNumber = TFunctionNumber

---@class MPCIeFunctionLoadInfo.DeviceNumber
---@field DeviceNumber integer
local TDeviceNumber = {}
TDeviceNumber.__index = TDeviceNumber
TDeviceNumber.group = {}

local function TDeviceNumber_from_obj(obj)
    return setmetatable(obj, TDeviceNumber)
end

function TDeviceNumber.new(DeviceNumber)
    return TDeviceNumber_from_obj({DeviceNumber = DeviceNumber or 255})
end
---@param obj MPCIeFunctionLoadInfo.DeviceNumber
function TDeviceNumber:init_from_obj(obj)
    self.DeviceNumber = obj.DeviceNumber or 255
end

function TDeviceNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceNumber.group)
end

TDeviceNumber.from_obj = TDeviceNumber_from_obj

TDeviceNumber.proto_property = {'DeviceNumber'}

TDeviceNumber.default = {0}

TDeviceNumber.struct = {{name = 'DeviceNumber', is_array = false, struct = nil}}

function TDeviceNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'DeviceNumber', self.DeviceNumber, 'uint8', false, errs, need_convert)

    TDeviceNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceNumber.proto_property, errs, need_convert)
    return self
end

function TDeviceNumber:unpack(_)
    return self.DeviceNumber
end

MPCIeFunctionLoadInfo.DeviceNumber = TDeviceNumber

---@class MPCIeFunctionLoadInfo.BusNumber
---@field BusNumber integer
local TBusNumber = {}
TBusNumber.__index = TBusNumber
TBusNumber.group = {}

local function TBusNumber_from_obj(obj)
    return setmetatable(obj, TBusNumber)
end

function TBusNumber.new(BusNumber)
    return TBusNumber_from_obj({BusNumber = BusNumber or 255})
end
---@param obj MPCIeFunctionLoadInfo.BusNumber
function TBusNumber:init_from_obj(obj)
    self.BusNumber = obj.BusNumber or 255
end

function TBusNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBusNumber.group)
end

TBusNumber.from_obj = TBusNumber_from_obj

TBusNumber.proto_property = {'BusNumber'}

TBusNumber.default = {0}

TBusNumber.struct = {{name = 'BusNumber', is_array = false, struct = nil}}

function TBusNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BusNumber', self.BusNumber, 'uint8', false, errs, need_convert)

    TBusNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBusNumber.proto_property, errs, need_convert)
    return self
end

function TBusNumber:unpack(_)
    return self.BusNumber
end

MPCIeFunctionLoadInfo.BusNumber = TBusNumber

---@class MPCIeFunctionLoadInfo.SegmentNumber
---@field SegmentNumber integer
local TSegmentNumber = {}
TSegmentNumber.__index = TSegmentNumber
TSegmentNumber.group = {}

local function TSegmentNumber_from_obj(obj)
    return setmetatable(obj, TSegmentNumber)
end

function TSegmentNumber.new(SegmentNumber)
    return TSegmentNumber_from_obj({SegmentNumber = SegmentNumber or 65535})
end
---@param obj MPCIeFunctionLoadInfo.SegmentNumber
function TSegmentNumber:init_from_obj(obj)
    self.SegmentNumber = obj.SegmentNumber or 65535
end

function TSegmentNumber:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSegmentNumber.group)
end

TSegmentNumber.from_obj = TSegmentNumber_from_obj

TSegmentNumber.proto_property = {'SegmentNumber'}

TSegmentNumber.default = {0}

TSegmentNumber.struct = {{name = 'SegmentNumber', is_array = false, struct = nil}}

function TSegmentNumber:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SegmentNumber', self.SegmentNumber, 'uint16', false, errs, need_convert)

    TSegmentNumber:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSegmentNumber.proto_property, errs, need_convert)
    return self
end

function TSegmentNumber:unpack(_)
    return self.SegmentNumber
end

MPCIeFunctionLoadInfo.SegmentNumber = TSegmentNumber

---@class MPCIeFunctionLoadInfo.SlotId
---@field SlotId integer
local TSlotId = {}
TSlotId.__index = TSlotId
TSlotId.group = {}

local function TSlotId_from_obj(obj)
    return setmetatable(obj, TSlotId)
end

function TSlotId.new(SlotId)
    return TSlotId_from_obj({SlotId = SlotId or 0})
end
---@param obj MPCIeFunctionLoadInfo.SlotId
function TSlotId:init_from_obj(obj)
    self.SlotId = obj.SlotId or 0
end

function TSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotId.group)
end

TSlotId.from_obj = TSlotId_from_obj

TSlotId.proto_property = {'SlotId'}

TSlotId.default = {0}

TSlotId.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)

    TSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotId.proto_property, errs, need_convert)
    return self
end

function TSlotId:unpack(_)
    return self.SlotId
end

MPCIeFunctionLoadInfo.SlotId = TSlotId

---@class MPCIeFunctionLoadInfo.DeviceType
---@field DeviceType string
local TDeviceType = {}
TDeviceType.__index = TDeviceType
TDeviceType.group = {}

local function TDeviceType_from_obj(obj)
    return setmetatable(obj, TDeviceType)
end

function TDeviceType.new(DeviceType)
    return TDeviceType_from_obj({DeviceType = DeviceType or [=[N/A]=]})
end
---@param obj MPCIeFunctionLoadInfo.DeviceType
function TDeviceType:init_from_obj(obj)
    self.DeviceType = obj.DeviceType or [=[N/A]=]
end

function TDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceType.group)
end

TDeviceType.from_obj = TDeviceType_from_obj

TDeviceType.proto_property = {'DeviceType'}

TDeviceType.default = {''}

TDeviceType.struct = {{name = 'DeviceType', is_array = false, struct = nil}}

function TDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'DeviceType', self.DeviceType, 'string', false, errs, need_convert)

    TDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceType.proto_property, errs, need_convert)
    return self
end

function TDeviceType:unpack(_)
    return self.DeviceType
end

MPCIeFunctionLoadInfo.DeviceType = TDeviceType

return MPCIeFunctionLoadInfo
