-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeFunction = {}

---@class MPCIeFunction.BDF
---@field BDF string
local TBDF = {}
TBDF.__index = TBDF
TBDF.group = {}

local function TBDF_from_obj(obj)
    return setmetatable(obj, TBDF)
end

function TBDF.new(BDF)
    return TBDF_from_obj({BDF = BDF})
end
---@param obj MPCIeFunction.BDF
function TBDF:init_from_obj(obj)
    self.BDF = obj.BDF
end

function TBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBDF.group)
end

TBDF.from_obj = TBDF_from_obj

TBDF.proto_property = {'BDF'}

TBDF.default = {''}

TBDF.struct = {{name = 'BDF', is_array = false, struct = nil}}

function TBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BDF', self.BDF, 'string', false, errs, need_convert)

    TBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBDF.proto_property, errs, need_convert)
    return self
end

function TBDF:unpack(_)
    return self.BDF
end

MPCIeFunction.BDF = TBDF

---@class MPCIeFunction.SlotId
---@field SlotId integer
local TSlotId = {}
TSlotId.__index = TSlotId
TSlotId.group = {}

local function TSlotId_from_obj(obj)
    return setmetatable(obj, TSlotId)
end

function TSlotId.new(SlotId)
    return TSlotId_from_obj({SlotId = SlotId})
end
---@param obj MPCIeFunction.SlotId
function TSlotId:init_from_obj(obj)
    self.SlotId = obj.SlotId
end

function TSlotId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlotId.group)
end

TSlotId.from_obj = TSlotId_from_obj

TSlotId.proto_property = {'SlotId'}

TSlotId.default = {0}

TSlotId.struct = {{name = 'SlotId', is_array = false, struct = nil}}

function TSlotId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SlotId', self.SlotId, 'uint8', false, errs, need_convert)

    TSlotId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlotId.proto_property, errs, need_convert)
    return self
end

function TSlotId:unpack(_)
    return self.SlotId
end

MPCIeFunction.SlotId = TSlotId

---@class MPCIeFunction.DeviceType
---@field DeviceType string
local TDeviceType = {}
TDeviceType.__index = TDeviceType
TDeviceType.group = {}

local function TDeviceType_from_obj(obj)
    return setmetatable(obj, TDeviceType)
end

function TDeviceType.new(DeviceType)
    return TDeviceType_from_obj({DeviceType = DeviceType})
end
---@param obj MPCIeFunction.DeviceType
function TDeviceType:init_from_obj(obj)
    self.DeviceType = obj.DeviceType
end

function TDeviceType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeviceType.group)
end

TDeviceType.from_obj = TDeviceType_from_obj

TDeviceType.proto_property = {'DeviceType'}

TDeviceType.default = {''}

TDeviceType.struct = {{name = 'DeviceType', is_array = false, struct = nil}}

function TDeviceType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'DeviceType', self.DeviceType, 'string', false, errs, need_convert)

    TDeviceType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeviceType.proto_property, errs, need_convert)
    return self
end

function TDeviceType:unpack(_)
    return self.DeviceType
end

MPCIeFunction.DeviceType = TDeviceType

return MPCIeFunction
