-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeCardDisplayCustom = {}

---@class MPCIeCardDisplayCustom.CardType
---@field CardType string
local TCardType = {}
TCardType.__index = TCardType
TCardType.group = {}

local function TCardType_from_obj(obj)
    return setmetatable(obj, TCardType)
end

function TCardType.new(CardType)
    return TCardType_from_obj({CardType = CardType or [=[NA]=]})
end
---@param obj MPCIeCardDisplayCustom.CardType
function TCardType:init_from_obj(obj)
    self.CardType = obj.CardType or [=[NA]=]
end

function TCardType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCardType.group)
end

TCardType.from_obj = TCardType_from_obj

TCardType.proto_property = {'CardType'}

TCardType.default = {''}

TCardType.struct = {{name = 'CardType', is_array = false, struct = nil}}

function TCardType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CardType', self.CardType, 'string', false, errs, need_convert)

    TCardType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCardType.proto_property, errs, need_convert)
    return self
end

function TCardType:unpack(_)
    return self.CardType
end

MPCIeCardDisplayCustom.CardType = TCardType

---@class MPCIeCardDisplayCustom.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj MPCIeCardDisplayCustom.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

MPCIeCardDisplayCustom.Enabled = TEnabled

---@class MPCIeCardDisplayCustom.CustomType
---@field CustomType string
local TCustomType = {}
TCustomType.__index = TCustomType
TCustomType.group = {}

local function TCustomType_from_obj(obj)
    return setmetatable(obj, TCustomType)
end

function TCustomType.new(CustomType)
    return TCustomType_from_obj({CustomType = CustomType or [=[]=]})
end
---@param obj MPCIeCardDisplayCustom.CustomType
function TCustomType:init_from_obj(obj)
    self.CustomType = obj.CustomType or [=[]=]
end

function TCustomType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCustomType.group)
end

TCustomType.from_obj = TCustomType_from_obj

TCustomType.proto_property = {'CustomType'}

TCustomType.default = {''}

TCustomType.struct = {{name = 'CustomType', is_array = false, struct = nil}}

function TCustomType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'CustomType', self.CustomType, 'string', false, errs, need_convert)

    TCustomType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCustomType.proto_property, errs, need_convert)
    return self
end

function TCustomType:unpack(_)
    return self.CustomType
end

MPCIeCardDisplayCustom.CustomType = TCustomType

---@class MPCIeCardDisplayCustom.QuadrupleId
---@field QuadrupleId string
local TQuadrupleId = {}
TQuadrupleId.__index = TQuadrupleId
TQuadrupleId.group = {}

local function TQuadrupleId_from_obj(obj)
    return setmetatable(obj, TQuadrupleId)
end

function TQuadrupleId.new(QuadrupleId)
    return TQuadrupleId_from_obj({QuadrupleId = QuadrupleId or [=[]=]})
end
---@param obj MPCIeCardDisplayCustom.QuadrupleId
function TQuadrupleId:init_from_obj(obj)
    self.QuadrupleId = obj.QuadrupleId or [=[]=]
end

function TQuadrupleId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TQuadrupleId.group)
end

TQuadrupleId.from_obj = TQuadrupleId_from_obj

TQuadrupleId.proto_property = {'QuadrupleId'}

TQuadrupleId.default = {''}

TQuadrupleId.struct = {{name = 'QuadrupleId', is_array = false, struct = nil}}

function TQuadrupleId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'QuadrupleId', self.QuadrupleId, 'string', false, errs, need_convert)

    TQuadrupleId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TQuadrupleId.proto_property, errs, need_convert)
    return self
end

function TQuadrupleId:unpack(_)
    return self.QuadrupleId
end

MPCIeCardDisplayCustom.QuadrupleId = TQuadrupleId

return MPCIeCardDisplayCustom
