-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPCIeCard = {}

---@class MPCIeCard.DevFunction
---@field DevFunction integer
local TDevFunction = {}
TDevFunction.__index = TDevFunction
TDevFunction.group = {}

local function TDevFunction_from_obj(obj)
    return setmetatable(obj, TDevFunction)
end

function TDevFunction.new(DevFunction)
    return TDevFunction_from_obj({DevFunction = DevFunction})
end
---@param obj MPCIeCard.DevFunction
function TDevFunction:init_from_obj(obj)
    self.DevFunction = obj.DevFunction
end

function TDevFunction:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevFunction.group)
end

TDevFunction.from_obj = TDevFunction_from_obj

TDevFunction.proto_property = {'DevFunction'}

TDevFunction.default = {0}

TDevFunction.struct = {{name = 'DevFunction', is_array = false, struct = nil}}

function TDevFunction:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevFunction', self.DevFunction, 'uint8', false, errs, need_convert)

    TDevFunction:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevFunction.proto_property, errs, need_convert)
    return self
end

function TDevFunction:unpack(_)
    return self.DevFunction
end

MPCIeCard.DevFunction = TDevFunction

---@class MPCIeCard.DevDevice
---@field DevDevice integer
local TDevDevice = {}
TDevDevice.__index = TDevDevice
TDevDevice.group = {}

local function TDevDevice_from_obj(obj)
    return setmetatable(obj, TDevDevice)
end

function TDevDevice.new(DevDevice)
    return TDevDevice_from_obj({DevDevice = DevDevice})
end
---@param obj MPCIeCard.DevDevice
function TDevDevice:init_from_obj(obj)
    self.DevDevice = obj.DevDevice
end

function TDevDevice:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevDevice.group)
end

TDevDevice.from_obj = TDevDevice_from_obj

TDevDevice.proto_property = {'DevDevice'}

TDevDevice.default = {0}

TDevDevice.struct = {{name = 'DevDevice', is_array = false, struct = nil}}

function TDevDevice:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevDevice', self.DevDevice, 'uint8', false, errs, need_convert)

    TDevDevice:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevDevice.proto_property, errs, need_convert)
    return self
end

function TDevDevice:unpack(_)
    return self.DevDevice
end

MPCIeCard.DevDevice = TDevDevice

---@class MPCIeCard.DevBus
---@field DevBus integer
local TDevBus = {}
TDevBus.__index = TDevBus
TDevBus.group = {}

local function TDevBus_from_obj(obj)
    return setmetatable(obj, TDevBus)
end

function TDevBus.new(DevBus)
    return TDevBus_from_obj({DevBus = DevBus})
end
---@param obj MPCIeCard.DevBus
function TDevBus:init_from_obj(obj)
    self.DevBus = obj.DevBus
end

function TDevBus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDevBus.group)
end

TDevBus.from_obj = TDevBus_from_obj

TDevBus.proto_property = {'DevBus'}

TDevBus.default = {0}

TDevBus.struct = {{name = 'DevBus', is_array = false, struct = nil}}

function TDevBus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DevBus', self.DevBus, 'uint8', false, errs, need_convert)

    TDevBus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDevBus.proto_property, errs, need_convert)
    return self
end

function TDevBus:unpack(_)
    return self.DevBus
end

MPCIeCard.DevBus = TDevBus

---@class MPCIeCard.MaxFrameLen
---@field MaxFrameLen integer
local TMaxFrameLen = {}
TMaxFrameLen.__index = TMaxFrameLen
TMaxFrameLen.group = {}

local function TMaxFrameLen_from_obj(obj)
    return setmetatable(obj, TMaxFrameLen)
end

function TMaxFrameLen.new(MaxFrameLen)
    return TMaxFrameLen_from_obj({MaxFrameLen = MaxFrameLen})
end
---@param obj MPCIeCard.MaxFrameLen
function TMaxFrameLen:init_from_obj(obj)
    self.MaxFrameLen = obj.MaxFrameLen
end

function TMaxFrameLen:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMaxFrameLen.group)
end

TMaxFrameLen.from_obj = TMaxFrameLen_from_obj

TMaxFrameLen.proto_property = {'MaxFrameLen'}

TMaxFrameLen.default = {0}

TMaxFrameLen.struct = {{name = 'MaxFrameLen', is_array = false, struct = nil}}

function TMaxFrameLen:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MaxFrameLen', self.MaxFrameLen, 'uint32', false, errs, need_convert)

    TMaxFrameLen:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMaxFrameLen.proto_property, errs, need_convert)
    return self
end

function TMaxFrameLen:unpack(_)
    return self.MaxFrameLen
end

MPCIeCard.MaxFrameLen = TMaxFrameLen

---@class MPCIeCard.Protocol
---@field Protocol string
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol})
end
---@param obj MPCIeCard.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {''}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'string', false, errs, need_convert)

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

MPCIeCard.Protocol = TProtocol

---@class MPCIeCard.RefChip
---@field RefChip integer[]
local TRefChip = {}
TRefChip.__index = TRefChip
TRefChip.group = {}

local function TRefChip_from_obj(obj)
    return setmetatable(obj, TRefChip)
end

function TRefChip.new(RefChip)
    return TRefChip_from_obj({RefChip = RefChip})
end
---@param obj MPCIeCard.RefChip
function TRefChip:init_from_obj(obj)
    self.RefChip = obj.RefChip
end

function TRefChip:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRefChip.group)
end

TRefChip.from_obj = TRefChip_from_obj

TRefChip.proto_property = {'RefChip'}

TRefChip.default = {{}}

TRefChip.struct = {{name = 'RefChip', is_array = true, struct = nil}}

function TRefChip:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RefChip', self.RefChip, 'uint8', false, errs, need_convert)

    TRefChip:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRefChip.proto_property, errs, need_convert)
    return self
end

function TRefChip:unpack(_)
    return self.RefChip
end

MPCIeCard.RefChip = TRefChip

---@class MPCIeCard.PcbID
---@field PcbID integer
local TPcbID = {}
TPcbID.__index = TPcbID
TPcbID.group = {}

local function TPcbID_from_obj(obj)
    return setmetatable(obj, TPcbID)
end

function TPcbID.new(PcbID)
    return TPcbID_from_obj({PcbID = PcbID})
end
---@param obj MPCIeCard.PcbID
function TPcbID:init_from_obj(obj)
    self.PcbID = obj.PcbID
end

function TPcbID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcbID.group)
end

TPcbID.from_obj = TPcbID_from_obj

TPcbID.proto_property = {'PcbID'}

TPcbID.default = {0}

TPcbID.struct = {{name = 'PcbID', is_array = false, struct = nil}}

function TPcbID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PcbID', self.PcbID, 'uint8', false, errs, need_convert)

    TPcbID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcbID.proto_property, errs, need_convert)
    return self
end

function TPcbID:unpack(_)
    return self.PcbID
end

MPCIeCard.PcbID = TPcbID

return MPCIeCard
