-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MCpuBusInfo = {}

---@class MCpuBusInfo.BusSize
---@field BusSize integer
local TBusSize = {}
TBusSize.__index = TBusSize
TBusSize.group = {}

local function TBusSize_from_obj(obj)
    return setmetatable(obj, TBusSize)
end

function TBusSize.new(BusSize)
    return TBusSize_from_obj({BusSize = BusSize or 0})
end
---@param obj MCpuBusInfo.BusSize
function TBusSize:init_from_obj(obj)
    self.BusSize = obj.BusSize or 0
end

function TBusSize:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBusSize.group)
end

TBusSize.from_obj = TBusSize_from_obj

TBusSize.proto_property = {'BusSize'}

TBusSize.default = {0}

TBusSize.struct = {{name = 'BusSize', is_array = false, struct = nil}}

function TBusSize:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BusSize', self.BusSize, 'uint8', false, errs, need_convert)

    TBusSize:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBusSize.proto_property, errs, need_convert)
    return self
end

function TBusSize:unpack(_)
    return self.BusSize
end

MCpuBusInfo.BusSize = TBusSize

---@class MCpuBusInfo.BusBaseAddr
---@field BusBaseAddr integer
local TBusBaseAddr = {}
TBusBaseAddr.__index = TBusBaseAddr
TBusBaseAddr.group = {}

local function TBusBaseAddr_from_obj(obj)
    return setmetatable(obj, TBusBaseAddr)
end

function TBusBaseAddr.new(BusBaseAddr)
    return TBusBaseAddr_from_obj({BusBaseAddr = BusBaseAddr or 0})
end
---@param obj MCpuBusInfo.BusBaseAddr
function TBusBaseAddr:init_from_obj(obj)
    self.BusBaseAddr = obj.BusBaseAddr or 0
end

function TBusBaseAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBusBaseAddr.group)
end

TBusBaseAddr.from_obj = TBusBaseAddr_from_obj

TBusBaseAddr.proto_property = {'BusBaseAddr'}

TBusBaseAddr.default = {0}

TBusBaseAddr.struct = {{name = 'BusBaseAddr', is_array = false, struct = nil}}

function TBusBaseAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BusBaseAddr', self.BusBaseAddr, 'uint8', false, errs, need_convert)

    TBusBaseAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBusBaseAddr.proto_property, errs, need_convert)
    return self
end

function TBusBaseAddr:unpack(_)
    return self.BusBaseAddr
end

MCpuBusInfo.BusBaseAddr = TBusBaseAddr

---@class MCpuBusInfo.SysId
---@field SysId integer
local TSysId = {}
TSysId.__index = TSysId
TSysId.group = {}

local function TSysId_from_obj(obj)
    return setmetatable(obj, TSysId)
end

function TSysId.new(SysId)
    return TSysId_from_obj({SysId = SysId or 1})
end
---@param obj MCpuBusInfo.SysId
function TSysId:init_from_obj(obj)
    self.SysId = obj.SysId or 1
end

function TSysId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSysId.group)
end

TSysId.from_obj = TSysId_from_obj

TSysId.proto_property = {'SysId'}

TSysId.default = {0}

TSysId.struct = {{name = 'SysId', is_array = false, struct = nil}}

function TSysId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SysId', self.SysId, 'uint8', false, errs, need_convert)

    TSysId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSysId.proto_property, errs, need_convert)
    return self
end

function TSysId:unpack(_)
    return self.SysId
end

MCpuBusInfo.SysId = TSysId

---@class MCpuBusInfo.SocketID
---@field SocketID integer
local TSocketID = {}
TSocketID.__index = TSocketID
TSocketID.group = {}

local function TSocketID_from_obj(obj)
    return setmetatable(obj, TSocketID)
end

function TSocketID.new(SocketID)
    return TSocketID_from_obj({SocketID = SocketID or 0})
end
---@param obj MCpuBusInfo.SocketID
function TSocketID:init_from_obj(obj)
    self.SocketID = obj.SocketID or 0
end

function TSocketID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSocketID.group)
end

TSocketID.from_obj = TSocketID_from_obj

TSocketID.proto_property = {'SocketID'}

TSocketID.default = {0}

TSocketID.struct = {{name = 'SocketID', is_array = false, struct = nil}}

function TSocketID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SocketID', self.SocketID, 'uint8', false, errs, need_convert)

    TSocketID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSocketID.proto_property, errs, need_convert)
    return self
end

function TSocketID:unpack(_)
    return self.SocketID
end

MCpuBusInfo.SocketID = TSocketID

return MCpuBusInfo
