-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local defs = {}

defs.FLUENT_BIT_LISTEN_ADDRESS = '127.0.0.1'
defs.FLUENT_BIT_LISTEN_PORT = '44318'

defs.FLUENT_BIT_CFG_PATH = '/data/trust/etc/fluent-bit.yaml'
defs.TLS_CA_FILE_PATH = '/dev/shm/ca-bundle.crt'
defs.HTTPS_CERTIFICATES_PATH = '/bmc/kepler/Managers/1/NetworkProtocol/HTTPS/Certificates/1'
defs.CERTIFICATE_INTERFACE = 'bmc.kepler.CertificateService.Certificate'

defs.SSL_KEY_PATH = '/data/trust/observability'
defs.SSL_KEY_NAME = 'client.key'
defs.SSL_KEY_FILE_PATH = defs.SSL_KEY_PATH .. '/' .. defs.SSL_KEY_NAME

defs.TMP_OBSERVABILITY_PATH = '/dev/shm/observability/'
defs.TMP_OBSERVABILITY_DIR = '/dev/shm/observability'
defs.FLUENT_BIT_PID_FILE_PATH = '/dev/shm/observability/fluent-bit.pid'
defs.MEMORY_MONITOR_SCRIPT = '/opt/bmc/script/fluent_memory_monitor.sh'

defs.COMM_USER_GID = 101
defs.COMM_USER_UID = 101

defs.FRU_ID = 0
defs.FRUDATA_BOARD_INTF = 'bmc.kepler.Systems.FruData.Board'
defs.FRUDATA_PRODUCT_INTF = 'bmc.kepler.Systems.FruData.Product'
defs.ASSEMBLY_PATH = '/bmc/kepler/Managers/1/Assembly'
defs.ASSEMBLY_INTF = 'bmc.kepler.Assembly'

return defs