/* Copyright (c) 2024 Huawei Technologies Co., Ltd.
 * openUBMC is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */
#ifndef OTEL_PARSE_CFG_H
#define OTEL_PARSE_CFG_H
#include <map>
#include <string>
namespace Otel {
namespace Utils {

// 定义属性结构体
struct Attribute {
    std::string name;
    std::string description;
    std::string type;
    std::string level;
};

// 定义指标结构体
struct Metric {
    std::string name;
    std::string description;
    std::string unit;
    std::string type;
    std::map<std::string, Attribute> attributes;
};

std::map<std::string, Metric> parseMetrics(const char *path);

} // namespace Utils
} // namespace Otel

#endif // OTEL_PARSE_CFG_H