-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Receiver = {}

---@class Receiver.Protocol
---@field Protocol string
local TProtocol = {}
TProtocol.__index = TProtocol
TProtocol.group = {}

local function TProtocol_from_obj(obj)
    return setmetatable(obj, TProtocol)
end

function TProtocol.new(Protocol)
    return TProtocol_from_obj({Protocol = Protocol or [=[OtlpHttp]=]})
end
---@param obj Receiver.Protocol
function TProtocol:init_from_obj(obj)
    self.Protocol = obj.Protocol or [=[OtlpHttp]=]
end

function TProtocol:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TProtocol.group)
end

TProtocol.from_obj = TProtocol_from_obj

TProtocol.proto_property = {'Protocol'}

TProtocol.default = {''}

TProtocol.struct = {{name = 'Protocol', is_array = false, struct = nil}}

function TProtocol:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Protocol', self.Protocol, 'string', false, errs, need_convert)

    if self.Protocol ~= nil then
        validate.Enum(prefix .. 'Protocol', self.Protocol, '', {'OtlpHttp'}, errs, need_convert)
    end

    TProtocol:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TProtocol.proto_property, errs, need_convert)
    return self
end

function TProtocol:unpack(_)
    return self.Protocol
end

Receiver.Protocol = TProtocol

---@class Receiver.Port
---@field Port integer
local TPort = {}
TPort.__index = TPort
TPort.group = {}

local function TPort_from_obj(obj)
    return setmetatable(obj, TPort)
end

function TPort.new(Port)
    return TPort_from_obj({Port = Port or 0})
end
---@param obj Receiver.Port
function TPort:init_from_obj(obj)
    self.Port = obj.Port or 0
end

function TPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPort.group)
end

TPort.from_obj = TPort_from_obj

TPort.proto_property = {'Port'}

TPort.default = {0}

TPort.struct = {{name = 'Port', is_array = false, struct = nil}}

function TPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Port', self.Port, 'uint16', false, errs, need_convert)

    if self.Port ~= nil then
        validate.ranges(prefix .. 'Port', self.Port, 0, 65535, errs, need_convert)
    end

    TPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPort.proto_property, errs, need_convert)
    return self
end

function TPort:unpack(_)
    return self.Port
end

Receiver.Port = TPort

---@class Receiver.Address
---@field Address string
local TAddress = {}
TAddress.__index = TAddress
TAddress.group = {}

local function TAddress_from_obj(obj)
    return setmetatable(obj, TAddress)
end

function TAddress.new(Address)
    return TAddress_from_obj({Address = Address or [=[]=]})
end
---@param obj Receiver.Address
function TAddress:init_from_obj(obj)
    self.Address = obj.Address or [=[]=]
end

function TAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddress.group)
end

TAddress.from_obj = TAddress_from_obj

TAddress.proto_property = {'Address'}

TAddress.default = {''}

TAddress.struct = {{name = 'Address', is_array = false, struct = nil}}

function TAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Address', self.Address, 'string', false, errs, need_convert)

    TAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddress.proto_property, errs, need_convert)
    return self
end

function TAddress:unpack(_)
    return self.Address
end

Receiver.Address = TAddress

---@class Receiver.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj Receiver.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

Receiver.Enabled = TEnabled

---@class Receiver.ReceiverId
---@field ReceiverId integer
local TReceiverId = {}
TReceiverId.__index = TReceiverId
TReceiverId.group = {}

local function TReceiverId_from_obj(obj)
    return setmetatable(obj, TReceiverId)
end

function TReceiverId.new(ReceiverId)
    return TReceiverId_from_obj({ReceiverId = ReceiverId or 0})
end
---@param obj Receiver.ReceiverId
function TReceiverId:init_from_obj(obj)
    self.ReceiverId = obj.ReceiverId or 0
end

function TReceiverId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReceiverId.group)
end

TReceiverId.from_obj = TReceiverId_from_obj

TReceiverId.proto_property = {'ReceiverId'}

TReceiverId.default = {0}

TReceiverId.struct = {{name = 'ReceiverId', is_array = false, struct = nil}}

function TReceiverId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ReceiverId', self.ReceiverId, 'uint8', true, errs, need_convert)

    TReceiverId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReceiverId.proto_property, errs, need_convert)
    return self
end

function TReceiverId:unpack(_)
    return self.ReceiverId
end

Receiver.ReceiverId = TReceiverId

---@class Receiver.SubmitTestTelemetryDataRsp
local TSubmitTestTelemetryDataRsp = {}
TSubmitTestTelemetryDataRsp.__index = TSubmitTestTelemetryDataRsp
TSubmitTestTelemetryDataRsp.group = {}

local function TSubmitTestTelemetryDataRsp_from_obj(obj)
    return setmetatable(obj, TSubmitTestTelemetryDataRsp)
end

function TSubmitTestTelemetryDataRsp.new()
    return TSubmitTestTelemetryDataRsp_from_obj({})
end
---@param obj Receiver.SubmitTestTelemetryDataRsp
function TSubmitTestTelemetryDataRsp:init_from_obj(obj)

end

function TSubmitTestTelemetryDataRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubmitTestTelemetryDataRsp.group)
end

TSubmitTestTelemetryDataRsp.from_obj = TSubmitTestTelemetryDataRsp_from_obj

TSubmitTestTelemetryDataRsp.proto_property = {}

TSubmitTestTelemetryDataRsp.default = {}

TSubmitTestTelemetryDataRsp.struct = {}

function TSubmitTestTelemetryDataRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSubmitTestTelemetryDataRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubmitTestTelemetryDataRsp.proto_property, errs, need_convert)
    return self
end

function TSubmitTestTelemetryDataRsp:unpack(_)
end

Receiver.SubmitTestTelemetryDataRsp = TSubmitTestTelemetryDataRsp

---@class Receiver.SubmitTestTelemetryDataReq
local TSubmitTestTelemetryDataReq = {}
TSubmitTestTelemetryDataReq.__index = TSubmitTestTelemetryDataReq
TSubmitTestTelemetryDataReq.group = {}

local function TSubmitTestTelemetryDataReq_from_obj(obj)
    return setmetatable(obj, TSubmitTestTelemetryDataReq)
end

function TSubmitTestTelemetryDataReq.new()
    return TSubmitTestTelemetryDataReq_from_obj({})
end
---@param obj Receiver.SubmitTestTelemetryDataReq
function TSubmitTestTelemetryDataReq:init_from_obj(obj)

end

function TSubmitTestTelemetryDataReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubmitTestTelemetryDataReq.group)
end

TSubmitTestTelemetryDataReq.from_obj = TSubmitTestTelemetryDataReq_from_obj

TSubmitTestTelemetryDataReq.proto_property = {}

TSubmitTestTelemetryDataReq.default = {}

TSubmitTestTelemetryDataReq.struct = {}

function TSubmitTestTelemetryDataReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSubmitTestTelemetryDataReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubmitTestTelemetryDataReq.proto_property, errs, need_convert)
    return self
end

function TSubmitTestTelemetryDataReq:unpack(_)
end

Receiver.SubmitTestTelemetryDataReq = TSubmitTestTelemetryDataReq

Receiver.interface = mdb.register_interface('bmc.kepler.ObservabilityService.Receiver', {
    ReceiverId = {'y', {'EMIT_CHANGE'}, true, 0},
    Enabled = {'b', {'EMIT_CHANGE'}, false, false},
    Address = {'s', {'EMIT_CHANGE'}, false, ''},
    Port = {'q', {'EMIT_CHANGE'}, false, 0},
    Protocol = {'s', {'EMIT_CHANGE'}, false, 'OtlpHttp'}
}, {SubmitTestTelemetryData = {'a{ss}', '', TSubmitTestTelemetryDataReq, TSubmitTestTelemetryDataRsp}}, {})

return Receiver
