-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-7-25
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ObservabilityServiceTraces = {}

---@class ObservabilityServiceTraces.SupportedSamplingRate
---@field SupportedSamplingRate number[]
local TSupportedSamplingRate = {}
TSupportedSamplingRate.__index = TSupportedSamplingRate
TSupportedSamplingRate.group = {}

local function TSupportedSamplingRate_from_obj(obj)
    return setmetatable(obj, TSupportedSamplingRate)
end

function TSupportedSamplingRate.new(SupportedSamplingRate)
    return TSupportedSamplingRate_from_obj({SupportedSamplingRate = SupportedSamplingRate})
end
---@param obj ObservabilityServiceTraces.SupportedSamplingRate
function TSupportedSamplingRate:init_from_obj(obj)
    self.SupportedSamplingRate = obj.SupportedSamplingRate
end

function TSupportedSamplingRate:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedSamplingRate.group)
end

TSupportedSamplingRate.from_obj = TSupportedSamplingRate_from_obj

TSupportedSamplingRate.proto_property = {'SupportedSamplingRate'}

TSupportedSamplingRate.default = {{}}

TSupportedSamplingRate.struct = {{name = 'SupportedSamplingRate', is_array = true, struct = nil}}

function TSupportedSamplingRate:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'SupportedSamplingRate', self.SupportedSamplingRate, 'double', true, errs,
        need_convert)

    TSupportedSamplingRate:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedSamplingRate.proto_property, errs, need_convert)
    return self
end

function TSupportedSamplingRate:unpack(_)
    return self.SupportedSamplingRate
end

ObservabilityServiceTraces.SupportedSamplingRate = TSupportedSamplingRate

---@class ObservabilityServiceTraces.SetConfigurationsRsp
local TSetConfigurationsRsp = {}
TSetConfigurationsRsp.__index = TSetConfigurationsRsp
TSetConfigurationsRsp.group = {}

local function TSetConfigurationsRsp_from_obj(obj)
    return setmetatable(obj, TSetConfigurationsRsp)
end

function TSetConfigurationsRsp.new()
    return TSetConfigurationsRsp_from_obj({})
end
---@param obj ObservabilityServiceTraces.SetConfigurationsRsp
function TSetConfigurationsRsp:init_from_obj(obj)

end

function TSetConfigurationsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConfigurationsRsp.group)
end

TSetConfigurationsRsp.from_obj = TSetConfigurationsRsp_from_obj

TSetConfigurationsRsp.proto_property = {}

TSetConfigurationsRsp.default = {}

TSetConfigurationsRsp.struct = {}

function TSetConfigurationsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetConfigurationsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConfigurationsRsp.proto_property, errs, need_convert)
    return self
end

function TSetConfigurationsRsp:unpack(_)
end

ObservabilityServiceTraces.SetConfigurationsRsp = TSetConfigurationsRsp

---@class ObservabilityServiceTraces.GetConfigurationsReq
local TGetConfigurationsReq = {}
TGetConfigurationsReq.__index = TGetConfigurationsReq
TGetConfigurationsReq.group = {}

local function TGetConfigurationsReq_from_obj(obj)
    return setmetatable(obj, TGetConfigurationsReq)
end

function TGetConfigurationsReq.new()
    return TGetConfigurationsReq_from_obj({})
end
---@param obj ObservabilityServiceTraces.GetConfigurationsReq
function TGetConfigurationsReq:init_from_obj(obj)

end

function TGetConfigurationsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigurationsReq.group)
end

TGetConfigurationsReq.from_obj = TGetConfigurationsReq_from_obj

TGetConfigurationsReq.proto_property = {}

TGetConfigurationsReq.default = {}

TGetConfigurationsReq.struct = {}

function TGetConfigurationsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetConfigurationsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigurationsReq.proto_property, errs, need_convert)
    return self
end

function TGetConfigurationsReq:unpack(_)
end

ObservabilityServiceTraces.GetConfigurationsReq = TGetConfigurationsReq

---@class ObservabilityServiceTraces.ConfigData
---@field key string
---@field value string
local TConfigData = {}
TConfigData.__index = TConfigData
TConfigData.group = {}

local function TConfigData_from_obj(obj)
    return setmetatable(obj, TConfigData)
end

function TConfigData.new(dict)
    return TConfigData_from_obj(dict)
end

---@param obj ObservabilityServiceTraces.ConfigData
function TConfigData:init_from_obj(obj)
    self = obj
end

function TConfigData:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigData.group)
end

TConfigData.from_obj = TConfigData_from_obj

TConfigData.proto_property = {}

TConfigData.default = {}

TConfigData.struct = {}

function TConfigData:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TConfigData:remove_error_props(errs, self)
    return self
end

function TConfigData:unpack(_)
    return self
end

ObservabilityServiceTraces.ConfigData = TConfigData

---@class ObservabilityServiceTraces.SetConfigurationsReq
---@field Configurations ObservabilityServiceTraces.ConfigData
local TSetConfigurationsReq = {}
TSetConfigurationsReq.__index = TSetConfigurationsReq
TSetConfigurationsReq.group = {}

local function TSetConfigurationsReq_from_obj(obj)
    return setmetatable(obj, TSetConfigurationsReq)
end

function TSetConfigurationsReq.new(Configurations)
    return TSetConfigurationsReq_from_obj({Configurations = Configurations})
end
---@param obj ObservabilityServiceTraces.SetConfigurationsReq
function TSetConfigurationsReq:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TSetConfigurationsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetConfigurationsReq.group)
end

TSetConfigurationsReq.from_obj = TSetConfigurationsReq_from_obj

TSetConfigurationsReq.proto_property = {'Configurations'}

TSetConfigurationsReq.default = {ObservabilityServiceTraces.ConfigData.default}

TSetConfigurationsReq.struct = {
    {name = 'Configurations', is_array = false, struct = ObservabilityServiceTraces.ConfigData.struct}
}

function TSetConfigurationsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ObservabilityServiceTraces.ConfigData.new(self.Configurations):validate(prefix, errs, need_convert)

    TSetConfigurationsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetConfigurationsReq.proto_property, errs, need_convert)
    return self
end

function TSetConfigurationsReq:unpack(_)
    return self.Configurations
end

ObservabilityServiceTraces.SetConfigurationsReq = TSetConfigurationsReq

---@class ObservabilityServiceTraces.GetConfigurationsRsp
---@field Configurations ObservabilityServiceTraces.ConfigData
local TGetConfigurationsRsp = {}
TGetConfigurationsRsp.__index = TGetConfigurationsRsp
TGetConfigurationsRsp.group = {}

local function TGetConfigurationsRsp_from_obj(obj)
    return setmetatable(obj, TGetConfigurationsRsp)
end

function TGetConfigurationsRsp.new(Configurations)
    return TGetConfigurationsRsp_from_obj({Configurations = Configurations})
end
---@param obj ObservabilityServiceTraces.GetConfigurationsRsp
function TGetConfigurationsRsp:init_from_obj(obj)
    self.Configurations = obj.Configurations
end

function TGetConfigurationsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetConfigurationsRsp.group)
end

TGetConfigurationsRsp.from_obj = TGetConfigurationsRsp_from_obj

TGetConfigurationsRsp.proto_property = {'Configurations'}

TGetConfigurationsRsp.default = {ObservabilityServiceTraces.ConfigData.default}

TGetConfigurationsRsp.struct = {
    {name = 'Configurations', is_array = false, struct = ObservabilityServiceTraces.ConfigData.struct}
}

function TGetConfigurationsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    ObservabilityServiceTraces.ConfigData.new(self.Configurations):validate(prefix, errs, need_convert)

    TGetConfigurationsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetConfigurationsRsp.proto_property, errs, need_convert)
    return self
end

function TGetConfigurationsRsp:unpack(_)
    return self.Configurations
end

ObservabilityServiceTraces.GetConfigurationsRsp = TGetConfigurationsRsp

ObservabilityServiceTraces.interface = mdb.register_interface('bmc.kepler.ObservabilityService.Traces',
    {SupportedSamplingRate = {'ad', {}, true, nil}}, {
        GetConfigurations = {'a{ss}', 'a{ss}', TGetConfigurationsReq, TGetConfigurationsRsp},
        SetConfigurations = {'a{ss}a{ss}', '', TSetConfigurationsReq, TSetConfigurationsRsp}
    }, {})

return ObservabilityServiceTraces
