-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-5-9
-- Description: DO NOT EDIT; Code generated by "message.lua.mako"
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ObservabilityService = {}

---@class ObservabilityService.ServerIdentity
---@field ServerIdentity string
local TServerIdentity = {}
TServerIdentity.__index = TServerIdentity
TServerIdentity.group = {}

local function TServerIdentity_from_obj(obj)
    return setmetatable(obj, TServerIdentity)
end

function TServerIdentity.new(ServerIdentity)
    return TServerIdentity_from_obj({ServerIdentity = ServerIdentity or [=[BoardSN]=]})
end
---@param obj ObservabilityService.ServerIdentity
function TServerIdentity:init_from_obj(obj)
    self.ServerIdentity = obj.ServerIdentity or [=[BoardSN]=]
end

function TServerIdentity:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TServerIdentity.group)
end

TServerIdentity.from_obj = TServerIdentity_from_obj

TServerIdentity.proto_property = {'ServerIdentity'}

TServerIdentity.default = {''}

TServerIdentity.struct = {{name = 'ServerIdentity', is_array = false, struct = nil}}

function TServerIdentity:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ServerIdentity', self.ServerIdentity, 'string', false, errs, need_convert)

    if self.ServerIdentity ~= nil then
        validate.Enum(prefix .. 'ServerIdentity', self.ServerIdentity, '', {'BoardSN', 'ProductAssetTag', 'HostName'},
            errs, need_convert)
    end

    TServerIdentity:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TServerIdentity.proto_property, errs, need_convert)
    return self
end

function TServerIdentity:unpack(_)
    return self.ServerIdentity
end

ObservabilityService.ServerIdentity = TServerIdentity

---@class ObservabilityService.TLSMode
---@field TLSMode string
local TTLSMode = {}
TTLSMode.__index = TTLSMode
TTLSMode.group = {}

local function TTLSMode_from_obj(obj)
    return setmetatable(obj, TTLSMode)
end

function TTLSMode.new(TLSMode)
    return TTLSMode_from_obj({TLSMode = TLSMode or [=[TLS]=]})
end
---@param obj ObservabilityService.TLSMode
function TTLSMode:init_from_obj(obj)
    self.TLSMode = obj.TLSMode or [=[TLS]=]
end

function TTLSMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTLSMode.group)
end

TTLSMode.from_obj = TTLSMode_from_obj

TTLSMode.proto_property = {'TLSMode'}

TTLSMode.default = {''}

TTLSMode.struct = {{name = 'TLSMode', is_array = false, struct = nil}}

function TTLSMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TLSMode', self.TLSMode, 'string', false, errs, need_convert)

    if self.TLSMode ~= nil then
        validate.Enum(prefix .. 'TLSMode', self.TLSMode, '', {'TLS', 'mTLS'}, errs, need_convert)
    end

    TTLSMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTLSMode.proto_property, errs, need_convert)
    return self
end

function TTLSMode:unpack(_)
    return self.TLSMode
end

ObservabilityService.TLSMode = TTLSMode

---@class ObservabilityService.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled or false})
end
---@param obj ObservabilityService.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled or false
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', false, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

ObservabilityService.Enabled = TEnabled

ObservabilityService.interface = mdb.register_interface('bmc.kepler.ObservabilityService', {
    Enabled = {'b', {'EMIT_CHANGE'}, false, false},
    TLSMode = {'s', {'EMIT_CHANGE'}, false, 'TLS'},
    ServerIdentity = {'s', {}, false, 'BoardSN'}
}, {}, {})

return ObservabilityService
