-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "model.lua.mako"
local mdb = require 'mc.mdb'
local class = require 'mc.class_mgnt'
local privilege = require 'mc.privilege'

local observability_service_class_types = require 'class.types.ObservabilityService'
local observability_service_intf_types = require 'observability.json_types.ObservabilityService'
local properties_intf_types = require 'mdb.bmc.kepler.Object.PropertiesInterface'
local receiver_intf_types = require 'observability.json_types.Receiver'
local observability_service_traces_intf_types = require 'observability.json_types.ObservabilityServiceTraces'
local observability_service_metrics_intf_types = require 'observability.json_types.ObservabilityServiceMetrics'
local observability_service_logs_intf_types = require 'observability.json_types.ObservabilityServiceLogs'

local ObservabilityService = {
    ['table_name'] = 't_observability',
    ['prop_configs'] = {
        ['Id'] = {
            ['baseType'] = 'U8',
            ['usage'] = {'PoweroffPer'},
            ['primaryKey'] = true,
            ['validator'] = observability_service_class_types.Id
        }
    },
    ['default_props'] = {['Id'] = observability_service_class_types.Id.default[1]},
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService'] = {
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = observability_service_intf_types.Enabled
            },
            ['TLSMode'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 'TLS',
                ['enum'] = {'TLS', 'mTLS'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = observability_service_intf_types.TLSMode
            },
            ['ServerIdentity'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['default'] = 'BoardSN',
                ['enum'] = {'BoardSN', 'ProductAssetTag', 'HostName'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = observability_service_intf_types.ServerIdentity
            }
        },
        ['bmc.kepler.Object.Properties'] = mdb.OBJECT_PROPERTIES_INTERFACE_PROP_CONFIGS
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService'] = {
            ['property_defaults'] = {['Enabled'] = false, ['TLSMode'] = 'TLS', ['ServerIdentity'] = 'BoardSN'},
            ['privileges'] = {
                ['props'] = {
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['TLSMode'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['ServerIdentity'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt}
                }
            },
            ['interface_types'] = observability_service_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local Receivers = {
    ['table_name'] = 't_observability_receivers',
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService.Receiver'] = {
            ['ReceiverId'] = {
                ['baseType'] = 'U8',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['usage'] = {'PoweroffPer'},
                ['primaryKey'] = true,
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = receiver_intf_types.ReceiverId
            },
            ['Enabled'] = {
                ['baseType'] = 'Boolean',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = false,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Enabled
            },
            ['Address'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = '',
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Address
            },
            ['Port'] = {
                ['baseType'] = 'U16',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 0,
                ['minimum'] = 0,
                ['maximum'] = 65535,
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Port
            },
            ['Protocol'] = {
                ['baseType'] = 'String',
                ['readOnly'] = false,
                ['options'] = {['emitsChangedSignal'] = 'true'},
                ['default'] = 'OtlpHttp',
                ['enum'] = {'OtlpHttp'},
                ['usage'] = {'PoweroffPer'},
                ['privilege'] = {['read'] = {'ReadOnly'}, ['write'] = {'DiagnoseMgmt'}},
                ['validator'] = receiver_intf_types.Protocol
            }
        },
        ['bmc.kepler.Object.Properties'] = mdb.OBJECT_PROPERTIES_INTERFACE_PROP_CONFIGS
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ObservabilityService.Receiver'] = {['SubmitTestTelemetryData'] = {['req'] = {}, ['rsp'] = {}}}
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService/Receivers/:Id'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService.Receiver'] = {
            ['property_defaults'] = {
                ['ReceiverId'] = 0,
                ['Enabled'] = false,
                ['Address'] = '',
                ['Port'] = 0,
                ['Protocol'] = 'OtlpHttp'
            },
            ['privileges'] = {
                ['props'] = {
                    ['ReceiverId'] = {['read'] = privilege.ReadOnly},
                    ['Enabled'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Address'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Port'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt},
                    ['Protocol'] = {['read'] = privilege.ReadOnly, ['write'] = privilege.DiagnoseMgmt}
                }
            },
            ['interface_types'] = receiver_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local Traces = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService.Traces'] = {
            ['SupportedSamplingRate'] = {
                ['baseType'] = 'Double[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = observability_service_traces_intf_types.SupportedSamplingRate
            }
        },
        ['bmc.kepler.Object.Properties'] = mdb.OBJECT_PROPERTIES_INTERFACE_PROP_CONFIGS
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ObservabilityService.Traces'] = {
            ['GetConfigurations'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['privilege'] = {'ReadOnly'}
            },
            ['SetConfigurations'] = {
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['rsp'] = {},
                ['privilege'] = {'DiagnoseMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService/Traces'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService.Traces'] = {
            ['property_defaults'] = {
                ['SupportedSamplingRate'] = observability_service_traces_intf_types.SupportedSamplingRate.default[1]
            },
            ['privileges'] = {
                ['props'] = {['SupportedSamplingRate'] = {['read'] = privilege.ReadOnly}},
                ['methods'] = {
                    ['GetConfigurations'] = privilege.ReadOnly,
                    ['SetConfigurations'] = privilege.DiagnoseMgmt
                }
            },
            ['interface_types'] = observability_service_traces_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local Metrics = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService.Metrics'] = {
            ['SupportedMetrics'] = {
                ['baseType'] = 'String[]',
                ['readOnly'] = true,
                ['options'] = {['emitsChangedSignal'] = 'false'},
                ['privilege'] = {['read'] = {'ReadOnly'}},
                ['validator'] = observability_service_metrics_intf_types.SupportedMetrics
            }
        },
        ['bmc.kepler.Object.Properties'] = mdb.OBJECT_PROPERTIES_INTERFACE_PROP_CONFIGS
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ObservabilityService.Metrics'] = {
            ['GetConfigurations'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['privilege'] = {'ReadOnly'}
            },
            ['SetConfigurations'] = {
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['rsp'] = {},
                ['privilege'] = {'DiagnoseMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService/Metrics'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService.Metrics'] = {
            ['property_defaults'] = {
                ['SupportedMetrics'] = observability_service_metrics_intf_types.SupportedMetrics.default[1]
            },
            ['privileges'] = {
                ['props'] = {['SupportedMetrics'] = {['read'] = privilege.ReadOnly}},
                ['methods'] = {
                    ['GetConfigurations'] = privilege.ReadOnly,
                    ['SetConfigurations'] = privilege.DiagnoseMgmt
                }
            },
            ['interface_types'] = observability_service_metrics_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local Logs = {
    ['mdb_prop_configs'] = {
        ['bmc.kepler.ObservabilityService.Logs'] = {},
        ['bmc.kepler.Object.Properties'] = mdb.OBJECT_PROPERTIES_INTERFACE_PROP_CONFIGS
    },
    ['mdb_method_configs'] = {
        ['bmc.kepler.ObservabilityService.Logs'] = {
            ['GetConfigurations'] = {
                ['req'] = {},
                ['rsp'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['privilege'] = {'ReadOnly'}
            },
            ['SetConfigurations'] = {
                ['req'] = {{['baseType'] = 'Dictionary', ['$ref'] = '#/defs/ConfigData', ['param'] = 'Configurations'}},
                ['rsp'] = {},
                ['privilege'] = {'DiagnoseMgmt'}
            }
        }
    },
    ['mdb_classes'] = mdb.get_class_obj('/bmc/kepler/ObservabilityService/Logs'),
    ['new_mdb_objects'] = mdb.new_objects_builder({
        ['bmc.kepler.ObservabilityService.Logs'] = {
            ['property_defaults'] = {},
            ['privileges'] = {
                ['methods'] = {
                    ['GetConfigurations'] = privilege.ReadOnly,
                    ['SetConfigurations'] = privilege.DiagnoseMgmt
                }
            },
            ['interface_types'] = observability_service_logs_intf_types
        },
        ['bmc.kepler.Object.Properties'] = {
            ['property_defaults'] = {
                ['ClassName'] = properties_intf_types.ClassName.default[1],
                ['ObjectName'] = properties_intf_types.ObjectName.default[1],
                ['ObjectIdentifier'] = properties_intf_types.ObjectIdentifier.default[1]
            },
            ['interface_types'] = properties_intf_types
        }
    })
}

local M = {}

function M.init(bus)
    class('ObservabilityService', ObservabilityService):set_bus(bus)
    class('Receivers', Receivers):set_bus(bus)
    class('Traces', Traces):set_bus(bus)
    class('Metrics', Metrics):set_bus(bus)
    class('Logs', Logs):set_bus(bus)
end

-- The callback needs to be registered during app initialization
function M.ImplReceiversReceiverSubmitTestTelemetryData(cb)
    class('Receivers')['bmc.kepler.ObservabilityService.Receiver'].SubmitTestTelemetryData = function(obj, ctx, ...)
        local req = receiver_intf_types.SubmitTestTelemetryDataReq.new(...):validate(nil, nil, true)
        local rsp = receiver_intf_types.SubmitTestTelemetryDataRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplTracesObservabilityServiceTracesGetConfigurations(cb)
    class('Traces')['bmc.kepler.ObservabilityService.Traces'].GetConfigurations = function(obj, ctx, ...)
        local req = observability_service_traces_intf_types.GetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_traces_intf_types.GetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplTracesObservabilityServiceTracesSetConfigurations(cb)
    class('Traces')['bmc.kepler.ObservabilityService.Traces'].SetConfigurations = function(obj, ctx, ...)
        local req = observability_service_traces_intf_types.SetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_traces_intf_types.SetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplMetricsObservabilityServiceMetricsGetConfigurations(cb)
    class('Metrics')['bmc.kepler.ObservabilityService.Metrics'].GetConfigurations = function(obj, ctx, ...)
        local req = observability_service_metrics_intf_types.GetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_metrics_intf_types.GetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplMetricsObservabilityServiceMetricsSetConfigurations(cb)
    class('Metrics')['bmc.kepler.ObservabilityService.Metrics'].SetConfigurations = function(obj, ctx, ...)
        local req = observability_service_metrics_intf_types.SetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_metrics_intf_types.SetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLogsObservabilityServiceLogsGetConfigurations(cb)
    class('Logs')['bmc.kepler.ObservabilityService.Logs'].GetConfigurations = function(obj, ctx, ...)
        local req = observability_service_logs_intf_types.GetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_logs_intf_types.GetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

-- The callback needs to be registered during app initialization
function M.ImplLogsObservabilityServiceLogsSetConfigurations(cb)
    class('Logs')['bmc.kepler.ObservabilityService.Logs'].SetConfigurations = function(obj, ctx, ...)
        local req = observability_service_logs_intf_types.SetConfigurationsReq.new(...):validate(nil, nil, true)
        local rsp =
            observability_service_logs_intf_types.SetConfigurationsRsp.new(cb(obj, ctx, req:unpack())):validate()
        return rsp:unpack(true)
    end
end

return M
