-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local network_adapter_debug = require 'network_adapter_debug'
local c_optical_module = require 'device.class.optical_module'

local lu = require 'luaunit'

TEST_optical_adapter_debug = {}

function TEST_optical_adapter_debug:test_set_configurations()
    local optical_module = {
        extreme_value_log_interval = 60
    }
    network_adapter_debug:props_changed_callback('ExtremeValueLogIntervalSeconds', 100)
    lu.assertEquals(optical_module.extreme_value_log_interval, 60)
    c_optical_module.collection.objects = {
        optical_module
    }
    network_adapter_debug:props_changed_callback('ExtremeValueLogIntervalSeconds', 100)
    lu.assertEquals(optical_module.extreme_value_log_interval, 100)
end

return TEST_optical_adapter_debug