-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local ncsi_lldp = require 'ncsi.ncsi_lldp'

-- 测试套件
TestNCSILldp = {}

function TestNCSILldp:test_process_lldp_over_ncsi_state()
    local lldp_obj = {
        is_recovered = false,
        is_process = false,
        process_lldp_over_ncsi_state = ncsi_lldp.process_lldp_over_ncsi_state,
        set_lldp_state = function(obj, state)
        end,
        recover_vlan_enable_state = function(obj)
            obj.is_recovered = true
        end
    }
    -- 执行测试
    lldp_obj:process_lldp_over_ncsi_state(false)

    -- 验证结果
    lu.assertEquals(lldp_obj.is_recovered, true)
    lu.assertEquals(lldp_obj.is_process, false)
end

return TestNCSILldp