-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'
local client = require 'network_adapter.client'
local fructl = require 'infrastructure.fructl'

TEST_fructl = {}


function TEST_fructl:test_get_power_status()
    local func = fructl.get_fructl_obj
    fructl.get_fructl_obj = function()
        return nil
    end
    local ret = fructl.get_power_status()
    lu.assertEquals(ret, nil)

    fructl.get_fructl_obj = function()
        return {PowerState = 1}
    end
    local ret2 = fructl.get_power_status()
    lu.assertEquals(ret2, 1)
    fructl.get_fructl_obj = func
end

function TEST_fructl:test_get_system_reset_flag()
    local func = client.GetFruCtrlObjects
    local obj = {SysResetDetected = 1}
    client.GetFruCtrlObjects = function()
        return {obj}
    end
    local ret1 = fructl.get_system_reset_flag()
    lu.assertEquals(ret1, 1)

    client.GetFruCtrlObjects = function()
        return {nil}
    end
    local ret2 = fructl.get_system_reset_flag()
    lu.assertEquals(ret2, nil)
    client.GetFruCtrlObjects = func
end