-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local BF3 = require 'hardware_config.BF3' -- 假设BF3代码文件路径为hardware_config/BF3.lua
local bf3_mctp = BF3.mctp('test_endpoint')

-- 测试套件
TestBF3 = {}

-- 1. 测试 HostAccess 相关功能
function TestBF3:test_host_access()
    -- 1.1 GetHostAccess：正常状态（0x00=Disable）
    local get_disable_data = string.char(
        0x00, -- reserved_1
        0x00, 0x00, 0x00, -- reserved_2
        0x00 -- host_access_state=0x00
    )
    local result = bf3_mctp.properties.GetHostAccess.response(get_disable_data)
    lu.assertEquals(result, 0x00)

    -- 1.2 GetHostAccess：正常状态（0x01=Enable）
    local get_enable_data = string.char(0x00, 0x00, 0x00, 0x00, 0x01)
    result = bf3_mctp.properties.GetHostAccess.response(get_enable_data)
    lu.assertEquals(result, 0x01)

    -- 1.3 GetHostAccess：非法状态（0x02）
    local invalid_state_data = string.char(0x00, 0x00, 0x00, 0x00, 0x02)
    result = bf3_mctp.properties.GetHostAccess.response(invalid_state_data)
    lu.assertEquals(result, 0xfe)

    -- 1.4 GetHostAccess：unpack返回nil
    local invalid_data = string.char(0x00)
    result = bf3_mctp.properties.GetHostAccess.response(invalid_data)
    lu.assertEquals(result, 0xff)

    -- 1.5 SetHostAccessDisable：响应返回0x00
    local set_disable_data = string.char(0x00, 0x00, 0x00, 0x00, 0x00)
    result = bf3_mctp.properties.SetHostAccessDisable.response(set_disable_data)
    lu.assertEquals(result, 0x00)

    -- 1.6 SetHostAccessEnable：响应返回0x01
    local set_enable_data = string.char(0x00, 0x00, 0x00, 0x00, 0x01)
    result = bf3_mctp.properties.SetHostAccessEnable.response(set_enable_data)
    lu.assertEquals(result, 0x01)
end

-- 2. 测试 ExtendedHostPrivilege 相关功能
function TestBF3:test_extended_host_privilege()
    -- 2.1 GetExtendedHostPrivilege：正常状态（0=Disable）
    local get_disable_data = string.char(
        0x00, -- reserved_1
        0x00, -- nic_reset:2 + nic_fw_update:2 + pcc_fw_update:2 + emb_cpu_setting_change:2
        0x08, -- global_non-volatile_change:2 + network_port_parameters_change:2 + external_host_parameters_change:2 + nic_flash_access:2
        0x00, 0x00 -- reserved_2
    )
    local result = bf3_mctp.properties.GetExtendedHostPrivilege.response(get_disable_data)
    lu.assertEquals(result, 0x00)

    -- 2.2 GetExtendedHostPrivilege：正常状态（1=Enable）
    local get_enable_data = string.char(0x00, 0x00, 0x04, 0x00, 0x00)
    result = bf3_mctp.properties.GetExtendedHostPrivilege.response(get_enable_data)
    lu.assertEquals(result, 0x01)

    -- 2.3 GetExtendedHostPrivilege：非法状态（2）
    local invalid_state_data = string.char(0x00, 0x00, 0x00, 0x00, 0x00)
    result = bf3_mctp.properties.GetExtendedHostPrivilege.response(invalid_state_data)
    lu.assertEquals(result, 0xf0)

    -- 2.4 SetExtendedHostPrivilegeDisable：响应非nil
    local set_disable_data = string.char(0x00)
    result = bf3_mctp.properties.SetExtendedHostPrivilegeDisable.response(set_disable_data)
    lu.assertTrue(result)

    -- 2.5 SetExtendedHostPrivilegeEnable：响应非nil
    local set_enable_data = string.char(0x00)
    result = bf3_mctp.properties.SetExtendedHostPrivilegeEnable.response(set_enable_data)
    lu.assertTrue(result)
end

-- 3. 测试 Mode 相关功能
function TestBF3:test_mode()
    -- 3.1 GetMode：NIC mode（offload_engine=1）
    local nic_mode_data = string.char(
        0x00, -- reserved_1
        0x00, 0x00, 0x00,  -- reserved_2:24 
        0x01 -- reserved_3 + offload_engine:1（bit0）
    )
    local result = bf3_mctp.properties.GetMode.response(nic_mode_data)
    lu.assertEquals(result, 0)

    -- 3.2 GetMode：DPU mode（offload_engine=0）
    local dpu_mode_data = string.char(0x00, 0x00, 0x00, 0x00, 0x00)
    result = bf3_mctp.properties.GetMode.response(dpu_mode_data)
    lu.assertEquals(result, 1)

    -- 3.3 SetModeFromDPUToNIC：响应非nil
    local set_nic_data = string.char(0x00)
    result = bf3_mctp.properties.SetModeFromDPUToNIC.response(set_nic_data)
    lu.assertTrue(result)

    -- 3.4 SetModeFromNICToDPU：响应非nil
    local set_dpu_data = string.char(0x00)
    result = bf3_mctp.properties.SetModeFromNICToDPU.response(set_dpu_data)
    lu.assertTrue(result)
end
