-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local EthernetInterface = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0",
    "@odata.type": "#EthernetInterface.v1_0_2.EthernetInterface",
    "AutoNeg": null,
    "Description": "Huawei Technologies Co., Ltd. Hi1822 Family (4*25GE) (rev 45)",
    "FullDuplex": null,
    "IPv4Addresses": [],
    "IPv6Addresses": [],
    "Id": "0000:05:01.0_0000:07:00.0",
    "LinkStatus": "NoLink",
    "MACAddress": "04:8c:16:59:c8:6e",
    "MTUSize": 1500,
    "Manufacturer": "Huawei Technologies Co., Ltd",
    "Name": "enp7s0",
    "OAM": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/OAM"
    },
    "Oem": {
        "Huawei": {
            "BDFNumber": {
                "BDF": "0000:07:00.0",
                "PortNum": null,
                "RootBDF": "0000:05:01.0"
            },
            "DeviceID": "0x1822",
            "DeviceLocation": null,
            "DeviceName": null,
            "DeviceSilkScreen": null,
            "DiagnosticStatus": 0,
            "DriverInfo": {
                "DriverName": "hinic",
                "DriverVersion": "3.9.0.8"
            },
            "FirmwareVersion": "3.0.0.21",
            "Model": "Hi1822",
            "NICName": "enp7s0",
            "PCIePath": "/sys/devices/pci0000:00/0000:00:0c.0/0000:04:00.0/0000:05:01.0/0000:07:00.0",
            "PortType": "Physical",
            "SubsystemDeviceID": "0xd136",
            "SubsystemVendorID": "0x19e5",
            "VendorID": "0x19e5"
        }
    },
    "Sff": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Sff"
    },
    "SpeedMbps": null,
    "Statistics": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Statistics"
    },
    "VLANs": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/VLANs"
    }
}]]

local OemEthernetInterfaceSff = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/ethX/Sff/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Sff",
    "@odata.type": "#EthernetInterface.v1_0_2.OemEthernetInterfaceSff",
    "ChannelNum": 1,
    "Diagnostic": {
        "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Sff/Diagnostic"
    },
    "DiagnosticStatus": [
        "0x1000d00"
    ],
    "Id": "0000:05:01.0_0000:07:00.0",
    "IsSffExist": true,
    "ManufactureDate": "170710",
    "MediumMode": "COPPER",
    "NICName": "enp7s0",
    "Name": "Ethernet Interface Sff",
    "PartNumber": "TR-PY85S-N00",
    "SerialNumber": "INHAX4480013",
    "SpeedMatch": true,
    "TransceiverType": "25GBASE-SR",
    "TypeMatch": true,
    "VendorName": "INNOLIGHT",
    "Wavelength": "850nm",
    "speed": [
        "25000M"
    ],
    "type": "SFP/SFP+/SFP28"
}]]

local OemEthernetInterfaceSffDiagnostic = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/ethX/Sff/Diagnostic",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Sff/Diagnostic",
    "@odata.type": "#EthernetInterface.v1_0_2.OemEthernetInterfaceSffDiagnostic",
    "ChannelNum": 1,
    "Id": "0000:05:01.0_0000:07:00.0",
    "IsSffExist": true,
    "NICName": "enp7s0",
    "Name": "Ethernet Interface Sff Diagnostic",
    "RxPowerCurrentMilliwatt": [
        0.0
    ],
    "RxPowerHighAlarmMilliwatt": 3.47,
    "RxPowerHighWarnMilliwatt": 1.74,
    "RxPowerLowAlarmMilliwatt": 0.05,
    "RxPowerLowWarnMilliwatt": 0.09,
    "TempCurrentCelsius": 36.91,
    "TempHighAlarmCelsius": 80.0,
    "TempHighWarnCelsius": 70.0,
    "TempLowAlarmCelsius": -10.0,
    "TempLowWarnCelsius": 0.0,
    "TxBiasCurrentMilliampere": [
        8.08
    ],
    "TxBiasHighAlarmMilliampere": 20.0,
    "TxBiasHighWarnMilliampere": 18.0,
    "TxBiasLowAlarmMilliampere": 0.5,
    "TxBiasLowWarnMilliampere": 1.0,
    "TxPowerCurrentMilliwatt": [
        0.98
    ],
    "TxPowerHighAlarmMilliwatt": 3.47,
    "TxPowerHighWarnMilliwatt": 1.74,
    "TxPowerLowAlarmMilliwatt": 0.07,
    "TxPowerLowWarnMilliwatt": 0.14,
    "VccCurrentVolts": 3.27,
    "VccHighAlarmVolts": 3.63,
    "VccHighWarnVolts": 3.46,
    "VccLowAlarmVolts": 2.97,
    "VccLowWarnVolts": 3.13
}]]

local OemEthernetInterfaceStatistics = [[{
    "@odata.context": "/redfish/v1/$metadata#Systems/Members/1/EthernetInterfaces/Members/ethX/Statistics/$entity",
    "@odata.id": "/redfish/v1/Sms/1/Systems/1/EthernetInterfaces/0000:05:01.0_0000:07:00.0/Statistics",
    "@odata.type": "#EthernetInterface.v1_0_2.OemEthernetInterfaceStatistics",
    "BandwidthUsage": null,
    "CRCErrors": 0,
    "DroppedPackets": 0,
    "ErrorPackets": 0,
    "FrameErrors": 0,
    "Id": "0000:05:01.0_0000:07:00.0",
    "MissedErrors": 0,
    "Name": "enp7s0",
    "Oem": {
        "Huawei": {
            "NICName": "enp7s0"
        }
    },
    "RxPackets": 0,
    "RxSpeedMbps": null,
    "TxPackets": 0,
    "TxSpeedMbps": null
}]]
return {
    OemEthernetInterfaceSff = OemEthernetInterfaceSff,
    EthernetInterface = EthernetInterface,
    OemEthernetInterfaceSffDiagnostic = OemEthernetInterfaceSffDiagnostic,
    OemEthernetInterfaceStatistics = OemEthernetInterfaceStatistics
}
