-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local common = require 'bma.rpc.common'
local mdb = require 'mc.mdb'
local client = require 'network_adapter.client'

TestBmaRpc = {}

-- 测试bma是否运行
function TestBmaRpc:test_is_bma_running()
    local origin_get_bus = client.get_bus
    client.get_bus = function()
    end
    local origin_get_object = mdb.get_object
    mdb.get_object = function()
        error()
    end
    local ret = common.is_bma_running()
    lu.assertEquals(ret, false)
    mdb.get_object = function()
        return {
            RunningState = 'Running'
        }
    end
    ret = common.is_bma_running()
    lu.assertEquals(ret, true)
    mdb.get_object = function()
    end
    ret = common.is_bma_running()
    lu.assertEquals(ret, false)
    mdb.get_object = origin_get_object
    client.get_bus = origin_get_bus
end