-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require('luaunit')

-- 记录原始依赖
local orig_port_comm = package.loaded['device.class.nic_mgmt.port.port_comm']
local orig_port_defs = package.loaded['device.class.nic_mgmt.port.port_defs']
local orig_port_manage = package.loaded['device.class.nic_mgmt.port.port_manage']

-- mock port_comm
package.loaded['device.class.nic_mgmt.port.port_comm'] = { is_virtual_port = function(tp) return tp == 6 end }
-- mock port_defs
package.loaded['device.class.nic_mgmt.port.port_defs'] = { INVALID_DATA_STRING = 'N/A', NPU_MODEL = 'NPU' }
-- mock port_manage
local called = { npu = false, reg = false, update_mac = false }
package.loaded['device.class.nic_mgmt.port.port_manage'] = {
    init_npu_port = function(orm_obj) called.npu = orm_obj end,
    register_property_changed_callback = function(orm_obj) called.reg = orm_obj end,
    update_mac_addr_from_db = function(orm_obj) called.update_mac = orm_obj end
}

local port_init = require 'device.class.nic_mgmt.port.port_init'

TestPortInit = {}

function TestPortInit:tearDown()
    if orig_port_comm then package.loaded['device.class.nic_mgmt.port.port_comm'] = orig_port_comm end
    if orig_port_defs then package.loaded['device.class.nic_mgmt.port.port_defs'] = orig_port_defs end
    if orig_port_manage then package.loaded['device.class.nic_mgmt.port.port_manage'] = orig_port_manage end
end

function TestPortInit:test_init_npu_model()
    called.npu, called.reg, called.update_mac = false, false, false
    local orm_obj = {
        Type = 1,
        PortID = 2,
        path = '/na/Ports/np',
        parent = { NodeId = 'nid', Model = 'NPU', SlotNumber = 7 },
        tasks = { sleep_ms = function() end },
        next_tick = function() end
    }
    port_init.init(orm_obj)
    lu.assertEquals(orm_obj.NetworkAdapterId, 'nid')
    lu.assertEquals(orm_obj.NodeId, 'nid3')
    lu.assertNotNil(orm_obj.t_port_prop_without_bma)
    lu.assertEquals(orm_obj.t_port_prop_without_bma.LinkStatus, 'N/A')
    lu.assertEquals(called.npu, orm_obj)
    lu.assertFalse(called.reg)
    lu.assertFalse(called.update_mac)
end

function TestPortInit:test_init_roh_parent()
    local orm_obj = {
        Type = 1,
        PortID = 1,
        path = '/na/Ports/np',
        parent = { NodeId = 'ROH123', Model = 'OTHER' },
        tasks = { sleep_ms = function() end },
        next_tick = function() end
    }
    port_init.init(orm_obj)
    -- ROH分支直接return
    lu.assertEquals(orm_obj.NetworkAdapterId, 'ROH123')
    lu.assertEquals(orm_obj.NodeId, 'ROH1232')
    lu.assertNil(orm_obj.t_port_prop_without_bma)
end 