-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local skynet = require 'skynet'
local lu = require 'luaunit'
local context = require 'mc.context'
local common = require 'bma.rpc.common'
local json = require 'cjson'

local cases = {}

local function set_up()
    common.is_bma_running = function()
        return true
    end
end

function cases.test_get_netcard_port_num(network_adapter_rpc)
    skynet.sleep(500)
    log:info(
        '-------------------test get_netcard_port_num start------------------------------------')
    local ok, netcard_exist, port_num = pcall(network_adapter_rpc.GetNetCardPortNum,
        network_adapter_rpc, context.new(), 3, 1, 1)
    lu.assertEquals(ok, true) -- 是否有error
    lu.assertEquals(netcard_exist, 1) -- 1: 网卡存在
    lu.assertEquals(port_num, 5) -- 0: 网卡端口数

    -- 网卡不存在时
    ok, _, _ = pcall(network_adapter_rpc.GetNetCardPortNum, network_adapter_rpc, context.new(), 1,
        9, 9)
    lu.assertEquals(ok, false) -- 是否有error
    log:info('-------------------test get_netcard_port_num end------------------------------------')
end

function cases.test_get_port_speed(network_adapter_rpc)
    log:info('-------------------test get_port_speed start------------------------------------')
    local ret, speed = network_adapter_rpc:GetPortSpeed(context.new(), 1, 7, 0)
    lu.assertEquals(ret, 0) -- 0: 正常返回
    lu.assertEquals(speed, 4294967295) -- 0: 网口速率
    log:info('-------------------test get_port_speed end------------------------------------')
end

function cases.test_get_network_port_num(network_adapter_rpc)
    skynet.sleep(500)
    log:info(
        '-------------------test get_network_port_num start------------------------------------')
    local num = network_adapter_rpc:GetNetworkPortNum(context.new())
    lu.assertEquals(num, 9) -- 0: 网络端口数
    log:info('-------------------test get_network_port_num end------------------------------------')
end

function cases.test_get_network_adapter_num(network_adapter_rpc)
    log:info(
        '-------------------test get_network_adapter_num start------------------------------------')
    local num = network_adapter_rpc:GetNetworkAdapterNum(context.new())
    lu.assertEquals(num, 5) -- 1 网络适配器数固定
    log:info(
        '-------------------test get_network_adapter_num end------------------------------------')
end

function cases.test_clear_band_width_history_succ(network_adapter_rpc)
    log:info(
        '-------------------test test_clear_band_width_history_succ start------------------------------------')
    local ok, _ = pcall(network_adapter_rpc.ClearBandwidthHistory,
        network_adapter_rpc, context.new(), 'chassisOCPCard1(SC332)')
    lu.assertEquals(ok, true)
    log:info(
        '-------------------test test_clear_band_width_history_succ end------------------------------------')
end

function cases.test_clear_band_width_history_fail(network_adapter_rpc)
    log:info(
        '-------------------test test_clear_band_width_history_fail start------------------------------------')
    local ok, _ = pcall(network_adapter_rpc.ClearBandwidthHistory,
        network_adapter_rpc, context.new(), 'chassisOCPCard1(666)')
    lu.assertEquals(ok, false)
    log:info(
        '-------------------test test_clear_band_width_history_fail end------------------------------------')
end

function cases.test_set_usage_threshold_succ(network_adapter_rpc)
    log:info(
        '-------------------test test_set_usage_threshold_succ start------------------------------------')
    local ok, ret = pcall(network_adapter_rpc.SetBandwidthThreshold, network_adapter_rpc, context.new(), 66)
    lu.assertEquals(ok, true)
    lu.assertEquals(ret, 0)
    log:info(
        '-------------------test test_set_usage_threshold_succ end------------------------------------')
end

function cases.test_set_usage_threshold_fail(network_adapter_rpc)
    log:info(
        '-------------------test test_set_usage_threshold_fail start------------------------------------')
    local ok, _ = pcall(network_adapter_rpc.SetBandwidthThreshold, network_adapter_rpc, context.new(), 160)
    lu.assertEquals(ok, false)
    log:info(
        '-------------------test test_set_usage_threshold_fail end------------------------------------')
end

function cases.test_entry(network_adapter_rpc)
    log:info('==> test network adapter rpc interfaces start ...')
    set_up()
    cases.test_get_netcard_port_num(network_adapter_rpc)
    cases.test_get_netcard_port_num(network_adapter_rpc)
    cases.test_get_network_port_num(network_adapter_rpc)
    cases.test_get_network_adapter_num(network_adapter_rpc)
    cases.test_clear_band_width_history_succ(network_adapter_rpc)
    cases.test_clear_band_width_history_fail(network_adapter_rpc)
    cases.test_set_usage_threshold_succ(network_adapter_rpc)
    cases.test_set_usage_threshold_fail(network_adapter_rpc)
    log:info('==> test network adapter rpc interfaces completed')
end

return cases