-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 装备测试集成测试用例
local lu = require 'luaunit'
local log = require 'mc.logging'
local mdb = require 'mc.mdb'
local context = require 'mc.context'

require 'network_adapter.json_types.Manufacture'
local test_dft = {}

local DFTPMU_PATH = '/bmc/kepler/Manufacture/PrepareTest/DftNCSI/DftNCSI_1_0001'
local DFTPMU_INTERFACE = 'bmc.kepler.Manufacture'

-- 测试装备项 DftPmu
local function test_dft_ncsi(bus)
    local ok, obj = pcall(mdb.get_object,bus, DFTPMU_PATH, DFTPMU_INTERFACE)
    if not ok then
        log:error(obj)
        return
    end
    obj:Start_PACKED(context.new())
    obj:Stop_PACKED(context.new())
    local resp = obj:GetResult_PACKED(context.new())
    lu.assertEquals(resp.Status, "Succeed")
    lu.assertEquals(resp.Description, "")
    log:info('test dft ncsi finish')
end

function test_dft.test_all_dft_method(bus)
    test_dft_ncsi(bus)
end

return test_dft