-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local c_optical_module = require 'device.class.optical_module'

local c_network_adapter_debug = class()

function c_network_adapter_debug:ctor(db, bus)
    self.db = db
    self.bus = bus
end

function c_network_adapter_debug:init()

end

local function set_optical_module_extreme_value_log_interval(period)
    if not c_optical_module.collection.objects then
        log:notice('c_optical_module collection objects is nil')
        return
    end
    for _, optical_module in pairs(c_optical_module.collection.objects) do
        log:notice('set optical module %s extreme value log interval from %s to %s',
            optical_module.Name, optical_module.extreme_value_log_interval, period)
        optical_module.extreme_value_log_interval = period
    end
end

local set_configurations_func_table = {
    ExtremeValueLogIntervalSeconds = set_optical_module_extreme_value_log_interval
}

function c_network_adapter_debug:props_changed_callback(name, value)
    log:notice("name: %s, value: %s", name, value)
    if  set_configurations_func_table[name] ~= nil then
        return set_configurations_func_table[name](value)
    end
end


return singleton(c_network_adapter_debug)