-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ncsi_def = require 'ncsi.ncsi_protocol.ncsi_def'
local ncsi_protocol_intf = require 'ncsi_protocol_intf'
local ncsi_aen = require 'ncsi.ncsi_protocol.ncsi_aen'

local ncsi_scoket = {}

local function ncsi_drvbuf_to_ncsibuf(data, eth_name)
    -- aen事件处理
    local is_aen_pkt, aen_oem_status = ncsi_aen.ncsi_aen_packet_proc(data, eth_name)
    if is_aen_pkt then
        return aen_oem_status
    end

    -- 限制接收数据长度，最大1160字节
    local new_data
    if #data > ncsi_def.PACKET_ALL_LEN then
        new_data = string.sub(data, 1, ncsi_def.PACKET_ALL_LEN)
    else
        new_data = data
    end
    return 0, new_data
end

function ncsi_scoket.ncsi_receive_packet(fd, eth_name)
    local aen_oem_status = 0
    local new_data = nil
    local data = ncsi_protocol_intf.ncsi_recv_packet(fd)
    if #data > 0 then
        aen_oem_status, new_data = ncsi_drvbuf_to_ncsibuf(data, eth_name)
    end
    return aen_oem_status, new_data
end

return ncsi_scoket