-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: fructl的相关工具
local log = require 'mc.logging'
local class = require 'mc.class'
local client = require 'network_adapter.client'

local fructl = class()

function fructl.get_fructl_obj()
    local objects = client:GetFruCtrlObjects()
    local _, obj = next(objects)
    return obj
end

-- 获取上下电状态
function fructl.get_power_status()
    local obj = fructl.get_fructl_obj()
    if not obj then
        log:error('[network_adapter]get_power_status: get power object failed')
        return nil
    end
    return obj.PowerState
end

-- 获取复位状态
function fructl.get_system_reset_flag()
    local obj = fructl.get_fructl_obj()
    if not obj then
        log:error('[network_adapter]get_system_reset_flag: get power object failed')
        return nil
    end
    return obj.SysResetDetected
end

return fructl