-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local context = require 'mc.context'
local log = require 'mc.logging'
local skynet = require 'skynet'

local MAC_OFFSET<const> = {
    0x20,
    0x26,
    0x30,
    0x36
}
local MAC_LENGTH<const> = 6

local function chip_read(chip, offset, length)
    local ok, ret
    for _ = 1, 3 do
        ok, ret = pcall(chip.Read, chip, context.get_context_or_default(), offset, length)
        if ok then
            break
        end
        skynet.sleep(30)
    end
    return ok, ret
end

local CTCloud11JA4 = class()

function CTCloud11JA4:ctor(chip)
    self.chip = chip
end

function CTCloud11JA4:init()
end

function CTCloud11JA4:GetMacAddress()
    local mac_infos = {}
    for i = 1, #MAC_OFFSET do
        local ok, mac_info = chip_read(self.chip, MAC_OFFSET[i], MAC_LENGTH)
        if not ok then
            log:debug('[CTCloud11JA4] get mac address failed, error: %s', mac_infos)
            goto continue
        end
        mac_infos[i] = mac_info
        ::continue::
    end

    return mac_infos
end

return {
    oem_smbus = CTCloud11JA4
}